/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.graphics;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rwt.internal.resources.ResourceManager;
import org.eclipse.rwt.internal.service.ServletLog;
import org.eclipse.rwt.resources.IResourceManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.graphics.ImageDataCache;

public final class ResourceFactory {
    private static final Map colors = new HashMap();
    private static final Map fonts = new HashMap();
    private static final Map images = new HashMap();
    private static final Map cursors = new HashMap();
    private static final ImageDataCache imageDataCache = new ImageDataCache();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public static Color getColor(RGB rgb) {
        if (rgb == null) {
            SWT.error(4);
        }
        return ResourceFactory.getColor(rgb.red, rgb.green, rgb.blue);
    }

    public static Color getColor(int red, int green, int blue) {
        int colorNr = ResourceFactory.computeColorNr(red, green, blue);
        return ResourceFactory.getColor(colorNr);
    }

    public static int computeColorNr(int red, int green, int blue) {
        if (red > 255 || red < 0 || green > 255 || green < 0 || blue > 255 || blue < 0) {
            SWT.error(5);
        }
        int colorNr = red | green << 8 | blue << 16;
        return colorNr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Color getColor(int value) {
        Color result;
        Integer key = new Integer(value);
        Map map = colors;
        synchronized (map) {
            if (colors.containsKey(key)) {
                result = (Color)colors.get(key);
            } else {
                result = ResourceFactory.createColorInstance(value);
                colors.put(key, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Font getFont(String name, int height, int style) {
        Font result;
        int checkedStyle = ResourceFactory.checkFontStyle(style);
        Integer key = new Integer(ResourceFactory.fontHashCode(name, height, checkedStyle));
        Map map = fonts;
        synchronized (map) {
            result = (Font)fonts.get(key);
            if (result == null) {
                FontData fontData = new FontData(name, height, checkedStyle);
                result = ResourceFactory.createFontInstance(fontData);
                fonts.put(key, result);
            }
        }
        return result;
    }

    public static int fontHashCode(String name, int height, int style) {
        int nameHashCode = name == null ? 0 : name.hashCode();
        return nameHashCode ^ height << 2 ^ style;
    }

    public static int checkFontStyle(int style) {
        int result = 0;
        if ((style & 1) != 0) {
            result |= 1;
        }
        if ((style & 2) != 0) {
            result |= 2;
        }
        return result;
    }

    public static synchronized Image findImage(String path) {
        IResourceManager manager = ResourceManager.getInstance();
        return ResourceFactory.findImage(path, manager.getContextLoader());
    }

    public static synchronized Image findImage(String path, ClassLoader imageLoader) {
        if (path == null) {
            SWT.error(4);
        }
        if ("".equals(path)) {
            SWT.error(5);
        }
        Image result = images.containsKey(path) ? (Image)images.get(path) : ResourceFactory.createImage(path, imageLoader);
        return result;
    }

    public static synchronized Image findImage(String path, InputStream inputStream) {
        if (path == null) {
            SWT.error(4);
        }
        if ("".equals(path)) {
            SWT.error(5);
        }
        Image result = images.containsKey(path) ? (Image)images.get(path) : ResourceFactory.createImage(path, inputStream);
        return result;
    }

    public static synchronized Image findImage(ImageData imageData) {
        if (imageData == null) {
            SWT.error(4);
        }
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{imageData};
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        int type = imageData.type != -1 ? imageData.type : 5;
        loader.save(outputStream, type);
        byte[] bytes = outputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        String path = "generated/" + ResourceFactory.hashCode(bytes) + ResourceFactory.getImageFileExtension(type);
        Image result = images.containsKey(path) ? (Image)images.get(path) : ResourceFactory.createImage(path, inputStream);
        return result;
    }

    public static String getImagePath(Image image) {
        String result = null;
        if (image != null) {
            result = ResourceManager.getInstance().getLocation(image.resourceName);
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ImageData getImageData(Image image) {
        ImageData result = imageDataCache.getImageData(image);
        if (result == null) {
            block8: {
                if (image != null) {
                    String imagePath = image.resourceName;
                    try {
                        IResourceManager manager = ResourceManager.getInstance();
                        InputStream inputStream = manager.getRegisteredContent(imagePath);
                        if (inputStream == null) break block8;
                        try {
                            result = new ImageData(inputStream);
                        }
                        catch (Throwable throwable) {
                            Object var5_7 = null;
                            inputStream.close();
                            throw throwable;
                        }
                        {
                            Object var5_8 = null;
                            inputStream.close();
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            if (result != null) {
                imageDataCache.putImageData(image, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cursor getCursor(int style) {
        Integer key = new Integer(style);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Cursor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            Cursor result = (Cursor)cursors.get(key);
            if (result == null) {
                result = ResourceFactory.createCursorInstance(style);
                cursors.put(key, result);
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return result;
        }
    }

    public static void clear() {
        colors.clear();
        fonts.clear();
        images.clear();
        cursors.clear();
    }

    static int colorsCount() {
        return colors.size();
    }

    static int fontsCount() {
        return fonts.size();
    }

    static int imagesCount() {
        return images.size();
    }

    static int cursorsCount() {
        return cursors.size();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Image createImage(String path, ClassLoader imageLoader) {
        Image result;
        IResourceManager manager = ResourceManager.getInstance();
        ClassLoader loaderBuffer = manager.getContextLoader();
        if (imageLoader != null) {
            manager.setContextLoader(imageLoader);
        }
        try {
            InputStream inputStream = manager.getResourceAsStream(path);
            result = ResourceFactory.createImage(path, inputStream);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            manager.setContextLoader(loaderBuffer);
            throw throwable;
        }
        {
            Object var6_8 = null;
            manager.setContextLoader(loaderBuffer);
            return result;
        }
    }

    private static Image createImage(String path, InputStream inputStream) {
        Point size;
        if (inputStream == null) {
            String txt = "Image ''{0}'' cannot be found.";
            String msg = MessageFormat.format(txt, path);
            SWT.error(5, new IllegalArgumentException(msg), msg);
        }
        Image result = (size = ResourceFactory.registerImage(path, inputStream)) != null ? ResourceFactory.createImageInstance(path, size.x, size.y) : ResourceFactory.createImageInstance(path, -1, -1);
        images.put(path, result);
        return result;
    }

    public static Point registerImage(String name, InputStream inputStream) {
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        bis.mark(Integer.MAX_VALUE);
        Point result = null;
        try {
            ImageData data = new ImageData(bis);
            result = new Point(data.width, data.height);
        }
        catch (SWTException e) {
            ServletLog.log("Failed to determine size for image: " + name, e);
        }
        try {
            bis.reset();
        }
        catch (IOException shouldNotHappen) {
            String txt = "Could not reset input stream while reading image ''{0}''.";
            String msg = MessageFormat.format(txt, name);
            throw new RuntimeException(msg, shouldNotHappen);
        }
        IResourceManager manager = ResourceManager.getInstance();
        manager.register(name, bis);
        return result;
    }

    private static String getImageFileExtension(int type) {
        String result;
        switch (type) {
            case 0: 
            case 1: 
            case 7: {
                result = ".bmp";
                break;
            }
            case 2: {
                result = ".gif";
                break;
            }
            case 3: {
                result = ".ico";
                break;
            }
            case 4: {
                result = ".jpg";
                break;
            }
            case 5: {
                result = ".png";
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    private static int hashCode(byte[] bytes) {
        int result;
        if (bytes == null) {
            result = 0;
        } else {
            result = 1;
            int i = 0;
            while (i < bytes.length) {
                result = 31 * result + bytes[i];
                ++i;
            }
        }
        return result;
    }

    private static Color createColorInstance(int colorNr) {
        Color result = null;
        try {
            Class[] paramList = new Class[]{Integer.TYPE};
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.swt.graphics.Color");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Constructor constr = clazz.getDeclaredConstructor(paramList);
            constr.setAccessible(true);
            Object[] args = new Object[]{new Integer(colorNr)};
            result = (Color)constr.newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate Color", e);
        }
        return result;
    }

    private static Font createFontInstance(FontData fontData) {
        Font result = null;
        try {
            Class[] classArray = new Class[1];
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.swt.graphics.FontData");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class[] paramList = classArray;
            Class<?> clazz2 = class$3;
            if (clazz2 == null) {
                try {
                    clazz2 = class$3 = Class.forName("org.eclipse.swt.graphics.Font");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Constructor constr = clazz2.getDeclaredConstructor(paramList);
            constr.setAccessible(true);
            result = (Font)constr.newInstance(fontData);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate Font", e);
        }
        return result;
    }

    private static Image createImageInstance(String resourceName, int width, int height) {
        Image result = null;
        try {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.swt.graphics.Image");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> imageClass = clazz;
            Class[] classArray = new Class[3];
            Class<?> clazz2 = class$5;
            if (clazz2 == null) {
                try {
                    clazz2 = class$5 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            classArray[1] = Integer.TYPE;
            classArray[2] = Integer.TYPE;
            Class[] paramList = classArray;
            Constructor<?> constructor = imageClass.getDeclaredConstructor(paramList);
            constructor.setAccessible(true);
            Object[] args = new Object[]{resourceName, new Integer(width), new Integer(height)};
            result = (Image)constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate Image", e);
        }
        return result;
    }

    private static Cursor createCursorInstance(int style) {
        Cursor result = null;
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Cursor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> cursorClass = clazz;
            Class[] paramList = new Class[]{Integer.TYPE};
            Constructor<?> constr = cursorClass.getDeclaredConstructor(paramList);
            constr.setAccessible(true);
            result = (Cursor)constr.newInstance(new Integer(style));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate Cursor", e);
        }
        return result;
    }

    private ResourceFactory() {
    }
}

