/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.internal.widgets.IListAdapter;
import org.eclipse.swt.internal.widgets.ListModel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Scrollable;

public class List
extends Scrollable {
    private static final int VERTICAL_ITEM_MARGIN = 3;
    private static final int HORIZONTAL_ITEM_MARGIN = 5;
    private final ListModel model;
    private int focusIndex = -1;
    private IListAdapter listAdapter;
    private final ResizeListener resizeListener;
    private int topIndex = 0;
    private boolean hasVScrollBar;
    private boolean hasHScrollBar;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public List(Composite parent, int style) {
        super(parent, List.checkStyle(style));
        this.model = new ListModel((style & 4) != 0);
        this.resizeListener = new ResizeListener();
        this.addControlListener(this.resizeListener);
    }

    public Object getAdapter(Class adapter) {
        Object result;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IListAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            if (this.listAdapter == null) {
                this.listAdapter = new IListAdapter(){

                    public void setFocusIndex(int focusIndex) {
                        List.this.setFocusIndex(focusIndex);
                    }

                    public boolean hasHScrollBar() {
                        return List.this.hasHScrollBar();
                    }

                    public boolean hasVScrollBar() {
                        return List.this.hasVScrollBar();
                    }
                };
            }
            result = this.listAdapter;
        } else {
            result = super.getAdapter(adapter);
        }
        return result;
    }

    public String[] getSelection() {
        this.checkWidget();
        int[] selectionIndices = this.model.getSelectionIndices();
        String[] result = new String[selectionIndices.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.model.getItem(selectionIndices[i]);
            ++i;
        }
        return result;
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return this.model.getSelectionIndex();
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        return this.model.getSelectionIndices();
    }

    public int getSelectionCount() {
        this.checkWidget();
        return this.model.getSelectionCount();
    }

    public void setSelection(int selection) {
        this.checkWidget();
        this.model.setSelection(selection);
        this.updateFocusIndexAfterSelectionChange();
    }

    public void setSelection(int[] selection) {
        this.checkWidget();
        this.model.setSelection(selection);
        this.updateFocusIndexAfterSelectionChange();
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        this.model.setSelection(start, end);
        this.updateFocusIndexAfterSelectionChange();
    }

    public void setSelection(String[] selection) {
        this.checkWidget();
        this.model.setSelection(selection);
        this.updateFocusIndexAfterSelectionChange();
    }

    public void select(int index) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if (index >= 0 && index < this.model.getItemCount()) {
                this.model.setSelection(index);
            }
        } else {
            this.model.addSelection(index);
        }
    }

    public void select(int[] indices) {
        int length;
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if ((length = indices.length) != 0 && ((this.style & 4) == 0 || length <= 1)) {
            int i = 0;
            while (i < length) {
                int index = indices[i];
                this.model.addSelection(index);
                ++i;
            }
        }
    }

    public void select(int start, int end) {
        int count;
        this.checkWidget();
        if (end >= 0 && start <= end && ((this.style & 4) == 0 || start == end) && (count = this.model.getItemCount()) != 0 && start < count) {
            int startIndex = Math.max(0, start);
            int endIndex = Math.min(end, count - 1);
            if ((this.style & 4) != 0) {
                this.model.setSelection(startIndex);
            } else {
                int i = startIndex;
                while (i <= endIndex) {
                    this.model.addSelection(i);
                    ++i;
                }
            }
        }
    }

    public void selectAll() {
        this.checkWidget();
        this.model.selectAll();
        this.updateFocusIndexAfterSelectionChange();
    }

    public void deselectAll() {
        this.checkWidget();
        this.model.deselectAll();
        this.updateFocusIndexAfterSelectionChange();
    }

    public void deselect(int index) {
        this.checkWidget();
        this.removeFromSelection(index);
    }

    public void deselect(int start, int end) {
        this.checkWidget();
        if (start == 0 && end == this.model.getItemCount() - 1) {
            this.deselectAll();
        } else {
            int actualStart;
            int i = actualStart = Math.max(0, start);
            while (i <= end) {
                this.removeFromSelection(i);
                ++i;
            }
        }
    }

    public void deselect(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        int i = 0;
        while (i < indices.length) {
            this.removeFromSelection(indices[i]);
            ++i;
        }
    }

    private void removeFromSelection(int index) {
        if (index >= 0 && index < this.model.getItemCount()) {
            boolean found = false;
            int[] selection = this.model.getSelectionIndices();
            int i = 0;
            while (!found && i < selection.length) {
                if (index == selection[i]) {
                    int length = selection.length;
                    int[] newSel = new int[length - 1];
                    System.arraycopy(selection, 0, newSel, 0, i);
                    if (i < length - 1) {
                        System.arraycopy(selection, i + 1, newSel, i, length - i - 1);
                    }
                    selection = newSel;
                    this.model.setSelection(selection);
                    found = true;
                }
                ++i;
            }
        }
    }

    public boolean isSelected(int index) {
        boolean result;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            result = index == this.getSelectionIndex();
        } else {
            int[] selectionIndices = this.getSelectionIndices();
            result = false;
            int i = 0;
            while (!result && i < selectionIndices.length) {
                if (index == selectionIndices[i]) {
                    result = true;
                }
                ++i;
            }
        }
        return result;
    }

    public void setTopIndex(int topIndex) {
        this.checkWidget();
        int count = this.model.getItemCount();
        if (this.topIndex != topIndex && topIndex >= 0 && topIndex < count) {
            this.topIndex = topIndex;
        }
    }

    public int getTopIndex() {
        this.checkWidget();
        return this.topIndex;
    }

    public void showSelection() {
        this.checkWidget();
        int index = this.getSelectionIndex();
        if (index != -1) {
            int itemCount = this.getVisibleItemCount();
            if (index < this.topIndex) {
                this.setTopIndex(index);
            } else if (itemCount > 0 && index >= this.topIndex + itemCount) {
                this.setTopIndex(index - itemCount + 1);
            }
        }
    }

    public int getFocusIndex() {
        this.checkWidget();
        return this.focusIndex;
    }

    public void add(String string) {
        this.checkWidget();
        this.model.add(string);
        this.updateFocusIndexAfterItemChange();
        this.updateScrollBars();
    }

    public void add(String string, int index) {
        this.checkWidget();
        this.model.add(string, index);
        this.updateFocusIndexAfterItemChange();
        this.updateScrollBars();
    }

    public void remove(int index) {
        this.checkWidget();
        this.model.remove(index);
        this.updateFocusIndexAfterItemChange();
        this.adjustTopIndex();
        this.updateScrollBars();
    }

    public void remove(int start, int end) {
        this.checkWidget();
        this.model.remove(start, end);
        this.updateFocusIndexAfterItemChange();
        this.adjustTopIndex();
        this.updateScrollBars();
    }

    public void remove(int[] indices) {
        this.checkWidget();
        this.model.remove(indices);
        this.updateFocusIndexAfterItemChange();
        this.adjustTopIndex();
        this.updateScrollBars();
    }

    public void remove(String string) {
        this.checkWidget();
        this.model.remove(string);
        this.updateFocusIndexAfterItemChange();
        this.adjustTopIndex();
        this.updateScrollBars();
    }

    public void removeAll() {
        this.checkWidget();
        this.model.removeAll();
        this.updateFocusIndexAfterItemChange();
        this.adjustTopIndex();
        this.updateScrollBars();
    }

    public void setItem(int index, String string) {
        this.checkWidget();
        this.model.setItem(index, string);
        this.updateScrollBars();
    }

    public void setItems(String[] items) {
        this.checkWidget();
        this.model.setItems(items);
        this.updateScrollBars();
    }

    public String getItem(int index) {
        this.checkWidget();
        return this.model.getItem(index);
    }

    public int getItemCount() {
        this.checkWidget();
        return this.model.getItemCount();
    }

    public String[] getItems() {
        this.checkWidget();
        return this.model.getItems();
    }

    public int indexOf(String string) {
        this.checkWidget();
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        int result = -1;
        int count = this.getItemCount();
        int i = start;
        while (result == -1 && i < count) {
            if (string.equals(this.getItem(i))) {
                result = i;
            }
            ++i;
        }
        return result;
    }

    public int getItemHeight() {
        this.checkWidget();
        int margin = 6;
        return Graphics.getCharHeight(this.getFont()) + margin;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.addListener(this, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.removeListener(this, listener);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.updateScrollBars();
    }

    boolean isTabGroup() {
        return true;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        String[] items = this.getItems();
        int itemWidth = 0;
        int i = 0;
        while (i < items.length) {
            itemWidth = this.getItemWidth(items[i]);
            width = Math.max(width, itemWidth);
            ++i;
        }
        height = this.getItemHeight() * items.length;
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        width += border * 2;
        height += border * 2;
        if ((this.style & 0x200) != 0) {
            width += this.getScrollBarSize();
        }
        if ((this.style & 0x100) != 0) {
            height += this.getScrollBarSize();
        }
        return new Point(width, height);
    }

    private void setFocusIndex(int focusIndex) {
        int count = this.model.getItemCount();
        if (focusIndex == -1 || focusIndex >= 0 && focusIndex < count) {
            this.focusIndex = focusIndex;
        }
    }

    private void updateFocusIndexAfterSelectionChange() {
        this.focusIndex = -1;
        if (this.model.getItemCount() > 0) {
            this.focusIndex = this.model.getSelectionIndex() == -1 ? 0 : this.model.getSelectionIndices()[0];
        }
    }

    private void updateFocusIndexAfterItemChange() {
        if (this.model.getItemCount() == 0) {
            this.focusIndex = -1;
        } else if (this.model.getSelectionIndex() == -1) {
            this.focusIndex = this.model.getItemCount() - 1;
        }
    }

    private static int checkStyle(int style) {
        return List.checkBits(style, 4, 2, 0, 0, 0, 0);
    }

    private int getItemWidth(String item) {
        int margin = 10;
        return Graphics.stringExtent((Font)this.getFont(), (String)item).x + margin;
    }

    private void adjustTopIndex() {
        int count = this.model.getItemCount();
        if (count == 0) {
            this.topIndex = 0;
        } else if (this.topIndex >= count - 1) {
            this.topIndex = count - 1;
        }
    }

    final int getVisibleItemCount() {
        int clientHeight = this.getBounds().height;
        if ((this.style & 0x100) != 0) {
            clientHeight -= this.getScrollBarSize();
        }
        int result = 0;
        if (clientHeight >= 0) {
            int itemHeight = this.getItemHeight();
            result = clientHeight / itemHeight;
        }
        return result;
    }

    boolean hasVScrollBar() {
        return this.hasVScrollBar;
    }

    boolean hasHScrollBar() {
        return this.hasHScrollBar;
    }

    int getVScrollBarWidth() {
        int result = 0;
        if (this.hasVScrollBar()) {
            result = this.getScrollBarSize();
        }
        return result;
    }

    int getHScrollBarHeight() {
        int result = 0;
        if (this.hasHScrollBar()) {
            result = this.getScrollBarSize();
        }
        return result;
    }

    boolean needsVScrollBar() {
        int availableHeight = this.getClientArea().height - this.getHScrollBarHeight();
        int height = this.getItemCount() * this.getItemHeight();
        return height > availableHeight;
    }

    boolean needsHScrollBar() {
        int availableWidth = this.getClientArea().width - this.getVScrollBarWidth();
        String[] items = this.getItems();
        int width = 0;
        int i = 0;
        while (i < items.length) {
            int itemWidth = this.getItemWidth(items[i]);
            width = Math.max(width, itemWidth);
            ++i;
        }
        return width > availableWidth;
    }

    void updateScrollBars() {
        this.hasVScrollBar = false;
        this.hasHScrollBar = this.needsHScrollBar();
        if (this.needsVScrollBar()) {
            this.hasVScrollBar = true;
            this.hasHScrollBar = this.needsHScrollBar();
        }
        this.hasVScrollBar = (this.style & 0x200) != 0 && this.hasVScrollBar;
        this.hasHScrollBar = (this.style & 0x100) != 0 && this.hasHScrollBar;
    }

    private int getScrollBarSize() {
        Display display = this.getDisplay();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.IDisplayAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object object = display.getAdapter(clazz);
        IDisplayAdapter adapter = (IDisplayAdapter)object;
        return adapter.getScrollBarSize();
    }

    private final class ResizeListener
    extends ControlAdapter {
        private ResizeListener() {
        }

        public void controlResized(ControlEvent event) {
            List.this.updateScrollBars();
        }
    }
}

