/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.lifecycle;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.rwt.SessionSingletonBase;
import org.eclipse.rwt.internal.lifecycle.RWTLifeCycle;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.service.ISessionStore;
import org.eclipse.rwt.service.SessionStoreEvent;
import org.eclipse.rwt.service.SessionStoreListener;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.widgets.Display;

public final class UICallBackManager {
    final Object lock = new Object();
    private final Set blockedCallBackRequests = new HashSet();
    private boolean uiThreadRunning = false;
    private boolean waitForUIThread = false;
    private boolean active = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static UICallBackManager getInstance() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.lifecycle.UICallBackManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object inst = SessionSingletonBase.getInstance(clazz);
        return (UICallBackManager)inst;
    }

    private UICallBackManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCallBackRequestBlocked() {
        Object object = this.lock;
        synchronized (object) {
            return !this.blockedCallBackRequests.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(boolean active) {
        Object object = this.lock;
        synchronized (object) {
            this.active = active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendUICallBack() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.uiThreadRunning || !this.active) {
                this.sendImmediately();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendImmediately() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyUIThreadStart() {
        Object object = this.lock;
        synchronized (object) {
            this.uiThreadRunning = true;
            this.waitForUIThread = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyUIThreadEnd() {
        Object object = this.lock;
        synchronized (object) {
            this.uiThreadRunning = false;
            if (this.hasRunnables()) {
                this.sendUICallBack();
            }
        }
    }

    boolean hasRunnables() {
        boolean result = false;
        Display display = RWTLifeCycle.getSessionDisplay();
        if (display != null && !display.isDisposed()) {
            IDisplayAdapter adapter;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.IDisplayAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            result = (adapter = (IDisplayAdapter)display.getAdapter(clazz)).getAsyncRunnablesCount() > 0;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean blockCallBackRequest() {
        boolean result = false;
        Object object = this.lock;
        synchronized (object) {
            final Thread currentThread = Thread.currentThread();
            SessionStoreListener listener = new SessionStoreListener(){

                public void beforeDestroy(SessionStoreEvent event) {
                    currentThread.interrupt();
                }
            };
            try {
                try {
                    if (this.mustBlockCallBackRequest()) {
                        this.blockedCallBackRequests.add(currentThread);
                        ISessionStore session = ContextProvider.getSession();
                        session.addSessionStoreListener(listener);
                        this.lock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    result = true;
                    Thread.interrupted();
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.blockedCallBackRequests.remove(currentThread);
                if (result) throw throwable;
                ContextProvider.getSession().removeSessionStoreListener(listener);
                throw throwable;
            }
            {
                Object var6_8 = null;
                this.blockedCallBackRequests.remove(currentThread);
            }
            if (!result) {
                ContextProvider.getSession().removeSessionStoreListener(listener);
            }
            this.waitForUIThread = true;
            return result;
        }
    }

    private boolean mustBlockCallBackRequest() {
        return this.active && this.blockedCallBackRequests.isEmpty() && (this.waitForUIThread || this.uiThreadRunning || !this.hasRunnables());
    }
}

