/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.lifecycle;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rwt.internal.lifecycle.EntryPointInstantiationException;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.util.ParamCheck;
import org.eclipse.rwt.lifecycle.IEntryPoint;
import org.eclipse.rwt.service.ISessionStore;

public final class EntryPointManager {
    public static final String DEFAULT = "default";
    private static final String CURRENT_ENTRY_POINT;
    private static final Map registry;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.lifecycle.EntryPointManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CURRENT_ENTRY_POINT = String.valueOf(clazz.getName()) + ".CurrentEntryPointName";
        registry = new HashMap();
    }

    private EntryPointManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(String name, Class clazz) {
        Map map = registry;
        synchronized (map) {
            ParamCheck.notNull(name, "name");
            ParamCheck.notNull(clazz, "clazz");
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.rwt.lifecycle.IEntryPoint");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz2.isAssignableFrom(clazz)) {
                String text = "The argument 'clazz' must implement {0}.";
                Object[] objectArray = new Object[1];
                Class<?> clazz3 = class$1;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$1 = Class.forName("org.eclipse.rwt.lifecycle.IEntryPoint");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                objectArray[0] = clazz3.getName();
                Object[] args = objectArray;
                String mag = MessageFormat.format(text, args);
                throw new IllegalArgumentException(mag);
            }
            if (registry.containsKey(name)) {
                String text = "An entry point named ''{0}'' already exists.";
                String msg = MessageFormat.format(text, name);
                throw new IllegalArgumentException(msg);
            }
            registry.put(name, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregister(String name) {
        Map map = registry;
        synchronized (map) {
            ParamCheck.notNull(name, "name");
            if (!registry.containsKey(name)) {
                String text = "An entry point named ''{0}'' does not exist.";
                String msg = MessageFormat.format(text, name);
                throw new IllegalArgumentException(msg);
            }
            registry.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int createUI(String name) {
        IEntryPoint entryPoint;
        Class clazz;
        ParamCheck.notNull(name, "name");
        Map map = registry;
        synchronized (map) {
            if (!registry.containsKey(name)) {
                String text = "An entry point named ''{0}'' does not exist.";
                String msg = MessageFormat.format(text, name);
                throw new IllegalArgumentException(msg);
            }
            clazz = (Class)registry.get(name);
        }
        try {
            entryPoint = (IEntryPoint)clazz.newInstance();
        }
        catch (Exception e) {
            String text = "Failed to instantiate ''{0}''.";
            Object[] args = new Object[]{clazz.getName()};
            String msg = MessageFormat.format(text, args);
            throw new EntryPointInstantiationException(msg, e);
        }
        ContextProvider.getSession().setAttribute(CURRENT_ENTRY_POINT, name);
        return entryPoint.createUI();
    }

    public static String getCurrentEntryPoint() {
        ISessionStore session = ContextProvider.getSession();
        return (String)session.getAttribute(CURRENT_ENTRY_POINT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getEntryPoints() {
        Map map = registry;
        synchronized (map) {
            String[] result = new String[registry.keySet().size()];
            registry.keySet().toArray(result);
            return result;
        }
    }
}

