/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.lifecycle;

import java.text.MessageFormat;
import org.eclipse.rwt.internal.ConfigurationReader;
import org.eclipse.rwt.internal.IConfiguration;
import org.eclipse.rwt.internal.IInitialization;
import org.eclipse.rwt.internal.lifecycle.LifeCycle;
import org.eclipse.rwt.internal.lifecycle.Scope;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.lifecycle.ILifeCycle;
import org.eclipse.rwt.service.ISessionStore;

public final class LifeCycleFactory {
    private static LifeCycle globalLifeCycle;
    static /* synthetic */ Class class$0;

    private LifeCycleFactory() {
    }

    public static ILifeCycle getLifeCycle() {
        String id;
        ILifeCycle result;
        ISessionStore session = ContextProvider.getSession();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.lifecycle.LifeCycle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((result = (ILifeCycle)session.getAttribute(id = clazz.getName())) == null) {
            result = LifeCycleFactory.loadLifeCycle();
            session.setAttribute(id, result);
        }
        return result;
    }

    public static void destroy() {
        globalLifeCycle = null;
    }

    public static ILifeCycle loadLifeCycle() {
        LifeCycle result = globalLifeCycle;
        if (result == null) {
            String lifeCycleClassName = null;
            try {
                IConfiguration configuration = ConfigurationReader.getConfiguration();
                IInitialization initialization = configuration.getInitialization();
                lifeCycleClassName = initialization.getLifeCycle();
                Class<?> lifeCycleClass = Class.forName(lifeCycleClassName);
                result = (LifeCycle)lifeCycleClass.newInstance();
                if (result.getScope().equals(Scope.APPLICATION)) {
                    globalLifeCycle = result;
                }
            }
            catch (Exception ex) {
                String text = "Could not load life cycle implementation {0}: {1}";
                Object[] args = new Object[]{lifeCycleClassName, ex.toString()};
                String msg = MessageFormat.format(text, args);
                throw new IllegalStateException(msg);
            }
        }
        return result;
    }
}

