/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.lifecycle;

import org.eclipse.rwt.internal.lifecycle.DisplayUtil;
import org.eclipse.rwt.internal.lifecycle.IDisplayLifeCycleAdapter;
import org.eclipse.rwt.internal.lifecycle.RWTLifeCycle;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.PhaseEvent;
import org.eclipse.rwt.lifecycle.PhaseId;
import org.eclipse.rwt.lifecycle.PhaseListener;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.internal.widgets.WidgetAdapter;
import org.eclipse.swt.internal.widgets.WidgetTreeVisitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public final class PreserveWidgetsPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;
    static /* synthetic */ Class class$0;

    public void beforePhase(PhaseEvent event) {
    }

    public void afterPhase(PhaseEvent event) {
        Display display;
        if (PhaseId.READ_DATA.equals(event.getPhaseId())) {
            Display display2 = RWTLifeCycle.getSessionDisplay();
            if (display2 != null) {
                PreserveWidgetsPhaseListener.preserve(display2);
            }
        } else if (PhaseId.RENDER.equals(event.getPhaseId()) && (display = RWTLifeCycle.getSessionDisplay()) != null) {
            PreserveWidgetsPhaseListener.clearPreserved(display);
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY;
    }

    private static void preserve(Display display) {
        IDisplayLifeCycleAdapter displayLCA = DisplayUtil.getLCA(display);
        IWidgetAdapter adapter = DisplayUtil.getAdapter(display);
        if (adapter.isInitialized()) {
            displayLCA.preserveValues(display);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IDisplayAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IDisplayAdapter displayAdapter = (IDisplayAdapter)display.getAdapter(clazz);
            Shell[] shells = displayAdapter.getShells();
            int i = 0;
            while (i < shells.length) {
                WidgetTreeVisitor.accept(shells[i], new WidgetTreeVisitor.AllWidgetTreeVisitor(){

                    public boolean doVisit(Widget widget) {
                        AbstractWidgetLCA widgetLCA = WidgetUtil.getLCA(widget);
                        widgetLCA.preserveValues(widget);
                        return true;
                    }
                });
                ++i;
            }
        }
    }

    static void clearPreserved(Display display) {
        WidgetAdapter widgetAdapter = (WidgetAdapter)DisplayUtil.getAdapter(display);
        widgetAdapter.clearPreserved();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IDisplayAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IDisplayAdapter displayAdapter = (IDisplayAdapter)display.getAdapter(clazz);
        Shell[] shells = displayAdapter.getShells();
        int i = 0;
        while (i < shells.length) {
            WidgetTreeVisitor.accept(shells[i], new WidgetTreeVisitor.AllWidgetTreeVisitor(){

                public boolean doVisit(Widget widget) {
                    WidgetAdapter widgetAdapter = (WidgetAdapter)WidgetUtil.getAdapter(widget);
                    widgetAdapter.clearPreserved();
                    return true;
                }
            });
            ++i;
        }
    }
}

