/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.util;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rwt.internal.util.Entities;

public final class EncodingUtil {
    private static final Pattern DOUBLE_HYPHEN_PATTERN = Pattern.compile("--");
    private static final String UNIX_NEWLINE = "\\n";
    private static final String NBSP = "&nbsp;";

    public static String escapeDoubleQuoted(String input) {
        StringBuffer resultBuffer = new StringBuffer();
        int length = input.length();
        int i = 0;
        while (i < length) {
            char ch = input.charAt(i);
            if (ch == '\"' || ch == '\\') {
                resultBuffer.append('\\');
            }
            resultBuffer.append(ch);
            ++i;
        }
        return resultBuffer.toString();
    }

    public static String escapeLeadingTrailingSpaces(String input) {
        StringBuffer buffer = new StringBuffer();
        int beginIndex = 0;
        int endIndex = input.length();
        while (beginIndex < input.length() && input.charAt(beginIndex) == ' ') {
            ++beginIndex;
            buffer.append(NBSP);
        }
        while (endIndex > beginIndex && input.charAt(endIndex - 1) == ' ') {
            --endIndex;
        }
        buffer.append(input.substring(beginIndex, endIndex));
        int endCount = input.length() - endIndex;
        int i = 0;
        while (i < endCount) {
            buffer.append(NBSP);
            ++i;
        }
        return buffer.toString();
    }

    public static String replaceNewLines(String input) {
        return EncodingUtil.replaceNewLines(input, UNIX_NEWLINE);
    }

    public static String replaceNewLines(String input, String replacement) {
        StringBuffer resultBuffer = new StringBuffer();
        int length = input.length();
        int i = 0;
        while (i < length) {
            char ch = input.charAt(i);
            if (ch == '\n') {
                resultBuffer.append(replacement);
            } else if (ch == '\r') {
                if (i + 1 < length) {
                    char next = input.charAt(i + 1);
                    if (ch == '\r' && next == '\n') {
                        ++i;
                    }
                }
                resultBuffer.append(replacement);
            } else {
                resultBuffer.append(ch);
            }
            ++i;
        }
        return resultBuffer.toString();
    }

    public static String replaceWhiteSpaces(String input) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < input.length()) {
            if (input.charAt(i) == ' ') {
                buffer.append(NBSP);
            } else {
                if (i > 1 && input.charAt(i - 1) == ' ') {
                    int start = buffer.length() - NBSP.length();
                    buffer.replace(start, buffer.length(), " ");
                }
                buffer.append(input.charAt(i));
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String[] splitNewLines(String input) {
        int length = input.length();
        ArrayList<String> resultList = new ArrayList<String>();
        int start = 0;
        int last = 0;
        int i = 0;
        while (i < length) {
            char ch = input.charAt(i);
            if (ch == '\n') {
                if (last != 13) {
                    resultList.add(input.substring(start, i));
                }
                start = i + 1;
            } else if (ch == '\r') {
                resultList.add(input.substring(start, i));
                start = i + 1;
            }
            last = ch;
            ++i;
        }
        resultList.add(input.substring(start, length));
        String[] result = new String[resultList.size()];
        resultList.toArray(result);
        return result;
    }

    public static String encodeHTMLEntities(String text) {
        String result = Entities.HTML40.escape(text);
        Matcher matcher = DOUBLE_HYPHEN_PATTERN.matcher(result);
        result = matcher.replaceAll("&#045;&#045;");
        return result;
    }

    public static String removeNonDisplayableChars(String text) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            if (!EncodingUtil.isNonDisplayableChar(ch)) {
                buffer.append(ch);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static boolean isNonDisplayableChar(char ch) {
        return ch == '\u2028' || ch == '\u2029';
    }

    private EncodingUtil() {
    }
}

