/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.service;

import java.io.File;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.util.ParamCheck;
import org.eclipse.rwt.service.FileSettingStore;
import org.eclipse.rwt.service.ISettingStore;
import org.eclipse.rwt.service.ISettingStoreFactory;
import org.eclipse.rwt.service.SettingStoreException;

public final class RWTFileSettingStoreFactory
implements ISettingStoreFactory {
    static /* synthetic */ Class class$0;

    public ISettingStore createSettingStore(String storeId) {
        ParamCheck.notNullOrEmpty(storeId, "storeId");
        FileSettingStore result = new FileSettingStore(this.getWorkDir());
        try {
            result.loadById(storeId);
        }
        catch (SettingStoreException sse) {
            String msg = String.valueOf(sse.getMessage());
            RWT.getRequest().getSession().getServletContext().log(msg, (Throwable)sse);
        }
        return result;
    }

    private ServletContext getContext() {
        HttpSession Session = ContextProvider.getRequest().getSession();
        ServletContext context = Session.getServletContext();
        return context;
    }

    private File getWorkDir() {
        File result = this.getWorkDirFromWebXml();
        if (result == null && (result = this.getWorkDirFromServletContext()) == null) {
            String parent = System.getProperty("java.io.tmpdir");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rwt.service.FileSettingStore");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            result = new File(parent, clazz.getName());
        }
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    private File getWorkDirFromWebXml() {
        String key = "org.eclipse.rwt.service.FileSettingStore.dir";
        String path = this.getContext().getInitParameter(key);
        return path != null ? new File(path) : null;
    }

    private File getWorkDirFromServletContext() {
        File file;
        String key = "javax.servlet.context.tempdir";
        File parent = (File)this.getContext().getAttribute(key);
        if (parent != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rwt.service.FileSettingStore");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            file = new File(parent, clazz.getName());
        } else {
            file = null;
        }
        return file;
    }
}

