/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.graphics.ResourceFactory;

public final class Font
extends Resource {
    private final FontData[] fontData;

    private Font(FontData data) {
        super(null);
        this.fontData = new FontData[]{data};
    }

    public Font(Device device, FontData fontData) {
        this(device, new FontData[]{fontData});
    }

    public Font(Device device, FontData[] fontData) {
        super(Font.checkDevice(device));
        if (fontData == null) {
            SWT.error(4);
        }
        if (fontData.length == 0) {
            SWT.error(5);
        }
        int i = 0;
        while (i < fontData.length) {
            if (fontData[i] == null) {
                SWT.error(5);
            }
            ++i;
        }
        this.fontData = new FontData[fontData.length];
        System.arraycopy(fontData, 0, this.fontData, 0, fontData.length);
    }

    public Font(Device device, String name, int height, int style) {
        this(device, new FontData(name, height, ResourceFactory.checkFontStyle(style)));
    }

    public FontData[] getFontData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new FontData[]{this.fontData[0]};
    }

    public boolean equals(Object object) {
        boolean result;
        if (object == this) {
            result = true;
        } else if (object instanceof Font) {
            Font font = (Font)object;
            result = font.fontData[0].equals(this.fontData[0]);
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        return this.fontData[0].hashCode();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Font {");
        if (this.fontData.length > 0) {
            buffer.append(this.fontData[0].getName());
            buffer.append(",");
            buffer.append(this.fontData[0].getHeight());
            buffer.append(",");
            int style = this.fontData[0].getStyle();
            String styleName = (style & 1) != 0 && (style & 2) != 0 ? "BOLD|ITALIC" : ((style & 1) != 0 ? "BOLD" : ((style & 2) != 0 ? "ITALIC" : "NORMAL"));
            buffer.append(styleName);
        }
        buffer.append("}");
        return buffer.toString();
    }
}

