/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.rwt.internal.RWTMessages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class FontDialog
extends Dialog {
    private static final int BUTTON_WIDTH = 60;
    private Shell shell;
    private FontData fontData;
    private RGB rgb;
    private boolean committed;
    private Text fontFamilyText;
    private List fontFamilyList;
    private Spinner fontSizeSpinner;
    private Button boldCheckbox;
    private Button italicCheckbox;
    private Label colorLabel;
    private Label previewLabel;

    public FontDialog(Shell parent) {
        this(parent, 65536);
    }

    public FontDialog(Shell parent, int style) {
        super(parent, FontDialog.checkStyle(parent, style));
        this.checkSubclass();
        this.setText(RWTMessages.getMessage("RWT_FontDialogTitle"));
    }

    public FontData[] getFontList() {
        FontData[] result = null;
        if (this.fontData != null) {
            result = new FontData[]{this.fontData};
        }
        return result;
    }

    public void setFontList(FontData[] fontData) {
        this.fontData = fontData != null && fontData.length > 0 ? fontData[0] : null;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public void setRGB(RGB rgb) {
        this.rgb = rgb;
    }

    public FontData open() {
        this.initializeDefaults();
        this.createShell();
        this.createControls();
        this.updateControls();
        this.addChangeListeners();
        this.layoutAndCenterShell();
        this.openShell();
        return this.fontData;
    }

    private void initializeDefaults() {
        if (this.fontData == null) {
            Display display = this.parent.getDisplay();
            FontData systemFontData = display.getSystemFont().getFontData()[0];
            String fontName = FontDialog.getFirstFontName(systemFontData.getName());
            int fontHeight = systemFontData.getHeight();
            int fontStyle = systemFontData.getStyle();
            this.fontData = new FontData(fontName, fontHeight, fontStyle);
        }
        if (this.rgb == null) {
            this.rgb = new RGB(0, 0, 0);
        }
    }

    static String getFirstFontName(String fontName) {
        String result = fontName;
        int index = result.indexOf(44);
        if (index != -1) {
            result = result.substring(0, index);
        }
        if ((result = result.trim()).length() > 2) {
            boolean isQuoted;
            char firstChar = result.charAt(0);
            char lastChar = result.charAt(result.length() - 1);
            boolean bl = isQuoted = firstChar == '\'' && lastChar == '\'' || firstChar == '\"' && lastChar == '\"';
            if (isQuoted) {
                result = result.substring(1, result.length() - 1);
            }
        }
        return result;
    }

    private void createShell() {
        int style = 67616;
        this.shell = new Shell(this.parent, style);
        this.shell.setText(this.getText());
        this.shell.addShellListener(new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                FontDialog.this.handleShellClose();
            }
        });
    }

    private void layoutAndCenterShell() {
        Point prefSize = this.shell.computeSize(-1, -1);
        prefSize.y += 50;
        this.shell.setSize(prefSize);
        Rectangle parentSize = this.parent.getBounds();
        int locationX = (parentSize.width - prefSize.x) / 2 + parentSize.x;
        int locationY = (parentSize.height - prefSize.y) / 2 + parentSize.y;
        this.shell.setLocation(locationX, locationY);
    }

    private void openShell() {
        this.shell.open();
        Display display = this.parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.shell = null;
    }

    private void createControls() {
        GridLayout mainLayout = new GridLayout(2, true);
        mainLayout.marginWidth = 10;
        mainLayout.marginHeight = 10;
        mainLayout.horizontalSpacing = 10;
        mainLayout.verticalSpacing = 10;
        this.shell.setLayout(mainLayout);
        this.createLeftArea(this.shell);
        this.createRightArea(this.shell);
        this.createPreviewArea(this.shell);
        this.createButtonArea(this.shell);
        this.fillAvailableFonts();
    }

    private void createLeftArea(Composite parent) {
        Composite leftArea = this.createVerticalArea(parent);
        this.createFontFamilyGroup(leftArea);
    }

    private void createRightArea(Composite parent) {
        Composite rightArea = this.createVerticalArea(parent);
        this.createFontSizeGroup(rightArea);
        this.createFontStyleGroup(rightArea);
        this.createFontColorGroup(rightArea);
    }

    private Composite createVerticalArea(Composite parent) {
        Composite result = new Composite(parent, 0);
        result.setLayoutData(new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        result.setLayout(layout);
        return result;
    }

    private void createFontFamilyGroup(Composite parent) {
        Group result = new Group(parent, 0);
        result.setLayoutData(new GridData(4, 4, true, true));
        result.setText(RWTMessages.getMessage("RWT_FontDialogFontFamilyTitle"));
        result.setLayout(new GridLayout());
        this.fontFamilyText = new Text(result, 2048);
        GridData textData = new GridData(4, 0x1000000, true, false);
        this.fontFamilyText.setLayoutData(textData);
        this.fontFamilyList = new List(result, 2564);
        GridData listData = new GridData(4, 4, true, true);
        this.fontFamilyList.setLayoutData(listData);
        this.fontFamilyList.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = FontDialog.this.fontFamilyList.getSelectionIndex();
                if (selectionIndex != -1) {
                    FontDialog.this.fontFamilyText.setText(FontDialog.this.fontFamilyList.getItem(selectionIndex));
                }
            }
        });
    }

    private void createFontSizeGroup(Composite parent) {
        Group result = new Group(parent, 0);
        result.setLayoutData(new GridData(4, 4, true, false));
        result.setText(RWTMessages.getMessage("RWT_FontDialogFontSizeTitle"));
        result.setLayout(new GridLayout());
        this.fontSizeSpinner = new Spinner(result, 2048);
        this.fontSizeSpinner.setDigits(0);
        this.fontSizeSpinner.setMinimum(0);
        this.fontSizeSpinner.setMaximum(200);
        GridData spinnerData = new GridData(4, 4, true, true);
        this.fontSizeSpinner.setLayoutData(spinnerData);
    }

    private void createFontStyleGroup(Composite parent) {
        Group result = new Group(parent, 0);
        result.setLayoutData(new GridData(4, 4, true, true));
        result.setText(RWTMessages.getMessage("RWT_FontDialogFontStyleTitle"));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        result.setLayout(layout);
        this.boldCheckbox = new Button(result, 32);
        String bold = RWTMessages.getMessage("RWT_FontDialogFontStyleBold");
        this.boldCheckbox.setText(bold);
        FontData normalFont = this.boldCheckbox.getFont().getFontData()[0];
        this.boldCheckbox.setFont(Graphics.getFont(normalFont.getName(), normalFont.getHeight(), 1));
        this.italicCheckbox = new Button(result, 32);
        String italic = RWTMessages.getMessage("RWT_FontDialogFontStyleItalic");
        this.italicCheckbox.setText(italic);
        this.italicCheckbox.setFont(Graphics.getFont(normalFont.getName(), normalFont.getHeight(), 2));
    }

    private void createFontColorGroup(Composite parent) {
        Group result = new Group(parent, 0);
        result.setLayoutData(new GridData(4, 4, true, false));
        result.setText(RWTMessages.getMessage("RWT_FontDialogFontColorTitle"));
        result.setLayout(new GridLayout(2, false));
        this.colorLabel = new Label(result, 2048);
        this.colorLabel.setLayoutData(new GridData(20, 20));
        Button changeColorButton = new Button(result, 8);
        String text = RWTMessages.getMessage("RWT_FontDialogFontColorSelect");
        changeColorButton.setText(text);
        changeColorButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FontDialog.this.openColorDialog();
            }
        });
    }

    private void openColorDialog() {
        ColorDialog dialog = new ColorDialog(this.shell);
        dialog.setRGB(this.rgb);
        RGB selected = dialog.open();
        if (selected != null) {
            this.rgb = selected;
            this.updateControls();
        }
    }

    private void addChangeListeners() {
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FontDialog.this.updateFontData();
            }
        };
        this.fontSizeSpinner.addSelectionListener(selectionListener);
        this.boldCheckbox.addSelectionListener(selectionListener);
        this.italicCheckbox.addSelectionListener(selectionListener);
        this.fontFamilyText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String text = FontDialog.this.fontFamilyText.getText();
                FontDialog.this.selectFontFamilyInList(text);
                FontDialog.this.updateFontData();
            }
        });
    }

    private void createPreviewArea(Composite parent) {
        Composite previewArea = new Composite(parent, 2048);
        GridData areaData = new GridData(4, 4, true, true);
        areaData.minimumWidth = 300;
        areaData.horizontalSpan = 2;
        previewArea.setLayoutData(areaData);
        previewArea.setLayout(new GridLayout());
        this.previewLabel = new Label(previewArea, 0x1000000);
        GridData labelData = new GridData(4, 0x1000000, true, true);
        this.previewLabel.setLayoutData(labelData);
        String previewText = RWTMessages.getMessage("RWT_FontDialogPreviewText");
        this.previewLabel.setText(previewText);
        Display display = parent.getDisplay();
        Color bgColor = display.getSystemColor(25);
        previewArea.setBackground(bgColor);
        previewArea.setBackgroundMode(1);
    }

    private void createButtonArea(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridData layoutData = new GridData(131072, 0x1000000, false, false);
        layoutData.horizontalSpan = 2;
        buttonComposite.setLayoutData(layoutData);
        GridLayout buttonCompLayout = new GridLayout(2, true);
        buttonCompLayout.marginWidth = 0;
        buttonCompLayout.marginHeight = 0;
        buttonComposite.setLayout(buttonCompLayout);
        String okText = SWT.getMessage("SWT_OK");
        Button okButton = this.createButton(buttonComposite, okText);
        parent.getShell().setDefaultButton(okButton);
        okButton.forceFocus();
        String cancelText = SWT.getMessage("SWT_Cancel");
        Button cancelButton = this.createButton(buttonComposite, cancelText);
        okButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FontDialog.this.committed = true;
                FontDialog.this.shell.close();
            }
        });
        cancelButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FontDialog.this.shell.close();
            }
        });
    }

    private Button createButton(Composite parent, String text) {
        Button result = new Button(parent, 8);
        result.setText(text);
        GridData data = new GridData(256);
        int widthHint = FontDialog.convertHorizontalDLUsToPixels(result, 60);
        Point minSize = result.computeSize(-1, -1);
        data.widthHint = Math.max(widthHint, minSize.x);
        result.setLayoutData(data);
        return result;
    }

    private void handleShellClose() {
        if (!this.committed) {
            this.fontData = null;
            this.rgb = null;
        }
        this.committed = false;
    }

    private void fillAvailableFonts() {
        HashSet<String> fontFamilies = new HashSet<String>();
        FontData[] fontList = this.parent.getDisplay().getFontList(null, true);
        if (fontList != null) {
            int i = 0;
            while (i < fontList.length) {
                fontFamilies.add(fontList[i].getName());
                ++i;
            }
        }
        Object[] availableFontNames = new String[fontFamilies.size()];
        fontFamilies.toArray(availableFontNames);
        Arrays.sort(availableFontNames);
        this.fontFamilyList.setItems((String[])availableFontNames);
    }

    private void updateControls() {
        String fontName = this.fontData.getName();
        if (!this.fontFamilyText.getText().equals(fontName)) {
            this.fontFamilyText.setText(fontName);
        }
        this.selectFontFamilyInList(fontName);
        this.fontSizeSpinner.setSelection(this.fontData.getHeight());
        this.boldCheckbox.setSelection((this.fontData.getStyle() & 1) != 0);
        this.italicCheckbox.setSelection((this.fontData.getStyle() & 2) != 0);
        this.updatePreview();
    }

    private void selectFontFamilyInList(String fontFamily) {
        this.fontFamilyList.deselectAll();
        String[] items = this.fontFamilyList.getItems();
        int i = 0;
        while (i < items.length) {
            String item = items[i];
            if (fontFamily.toLowerCase().equals(item.toLowerCase())) {
                this.fontFamilyList.select(i);
            }
            ++i;
        }
    }

    private void updatePreview() {
        if (this.previewLabel != null) {
            Font font = Graphics.getFont(this.fontData);
            this.previewLabel.setFont(font);
            Color color = Graphics.getColor(this.rgb);
            this.previewLabel.setForeground(color);
            this.colorLabel.setBackground(color);
            this.previewLabel.getParent().layout(true);
        }
    }

    private void updateFontData() {
        String name = this.fontData.getName();
        if (this.fontFamilyText.getText().length() > 0) {
            name = this.fontFamilyText.getText();
        }
        int height = this.fontSizeSpinner.getSelection();
        int style = 0;
        if (this.boldCheckbox.getSelection()) {
            style |= 1;
        }
        if (this.italicCheckbox.getSelection()) {
            style |= 2;
        }
        this.fontData = new FontData(name, height, style);
        this.updateControls();
    }
}

