/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.lifecycle;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.rwt.internal.lifecycle.HtmlResponseWriterUtil;
import org.eclipse.rwt.internal.util.ParamCheck;

public class HtmlResponseWriter
extends Writer {
    public static final String CLASS_PREFIX = "w4tCss";
    private List body = new ArrayList();
    private String elementStarted;
    private boolean closed;
    private boolean avoidEscape;
    private List jsLibraries = new ArrayList();

    public void append(String token) {
        this.body.add(token);
    }

    public void append(HtmlResponseWriter responseWriter) {
        int i = 0;
        while (i < responseWriter.getBodySize()) {
            this.body.add(responseWriter.getBodyToken(i));
            ++i;
        }
    }

    public void clearBody() {
        this.body.clear();
    }

    public int getBodySize() {
        return this.body.size();
    }

    public String getBodyToken(int index) {
        return this.body.get(index).toString();
    }

    public Iterator bodyTokens() {
        return this.body.iterator();
    }

    public String[] getJSLibraries() {
        String[] result = new String[this.jsLibraries.size()];
        this.jsLibraries.toArray(result);
        return result;
    }

    public void useJSLibrary(String libraryName) {
        ParamCheck.notNull(libraryName, "libraryName");
        if (!this.jsLibraries.contains(libraryName)) {
            this.jsLibraries.add(libraryName);
        }
    }

    public void removeJSLibraries(String libraryName) {
        this.jsLibraries.remove(libraryName);
    }

    public int getJSLibrariesCount() {
        return this.jsLibraries.size();
    }

    public void close() throws IOException {
        this.checkIfWriterClosed();
        this.closeElementIfStarted();
        this.closed = true;
    }

    public void flush() throws IOException {
        this.checkIfWriterClosed();
        this.closeElementIfStarted();
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.checkIfWriterClosed();
        this.closeElementIfStarted();
        this.doWrite(cbuf, off, len);
    }

    public void write(char character) throws IOException {
        this.checkIfWriterClosed();
        this.append(new String(new char[]{character}));
    }

    public void write(int c) throws IOException {
        this.checkIfWriterClosed();
        this.append(new String(new char[]{(char)c}));
    }

    public void write(String content) throws IOException {
        this.checkIfWriterClosed();
        this.closeElementIfStarted();
        this.doWrite(content);
    }

    public void write(String str, int off, int len) throws IOException {
        this.checkIfWriterClosed();
        this.append(str.substring(off, off + len));
    }

    public void startElement(String name, Object component) throws IOException {
        this.checkIfWriterClosed();
        ParamCheck.notNull(name, "name");
        this.closeElementIfStarted();
        char firstChar = name.charAt(0);
        if ((firstChar == 's' || firstChar == 'S') && ("script".equalsIgnoreCase(name) || "style".equalsIgnoreCase(name))) {
            this.avoidEscape = true;
        }
        this.doWrite("<");
        this.doWrite(name);
        this.elementStarted = name;
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        this.checkIfWriterClosed();
        ParamCheck.notNull(name, "name");
        if (this.elementStarted == null) {
            String msg = "There is no started element to add an attribute.";
            throw new IllegalStateException(msg);
        }
        if (value == null) {
            this.doWrite(" ");
            this.doWrite(name);
            this.doWrite("=\"");
            this.doWrite(name);
            this.doWrite("\"");
        } else {
            this.doWrite(" ");
            this.doWrite(name);
            this.doWrite("=\"");
            this.doWrite(HtmlResponseWriterUtil.encode(value.toString()));
            this.doWrite("\"");
        }
    }

    public void endElement(String name) throws IOException {
        this.checkIfWriterClosed();
        ParamCheck.notNull(name, "name");
        this.closeElementIfStarted();
        this.avoidEscape = false;
        if (!HtmlResponseWriterUtil.isEmptyTag(name)) {
            this.doWrite("</");
            this.doWrite(name);
            this.doWrite(">");
        }
    }

    public void endDocument() throws IOException {
        this.checkIfWriterClosed();
        this.closeElementIfStarted();
    }

    public void writeText(Object text, String property) throws IOException {
        this.checkIfWriterClosed();
        ParamCheck.notNull(text, "text");
        this.closeElementIfStarted();
        if (this.avoidEscape) {
            this.doWrite(text.toString());
        } else {
            this.doWrite(HtmlResponseWriterUtil.encode(text.toString()));
        }
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        this.checkIfWriterClosed();
        ParamCheck.notNull(text, "text");
        this.closeElementIfStarted();
        if (this.avoidEscape) {
            this.doWrite(text, off, len);
        } else {
            char[] content = new char[len];
            System.arraycopy(text, off, content, 0, len);
            StringBuffer buffer = new StringBuffer();
            buffer.append(HtmlResponseWriterUtil.encode(new String(content)));
            char[] encoded = buffer.toString().toCharArray();
            this.write(encoded);
        }
    }

    public void writeComment(Object comment) throws IOException {
        this.checkIfWriterClosed();
        ParamCheck.notNull(comment, "comment");
        this.closeElementIfStarted();
        this.doWrite("<!-- ");
        this.doWrite(HtmlResponseWriterUtil.encode(comment.toString()));
        this.doWrite(" -->");
    }

    public void writeNBSP() throws IOException {
        this.checkIfWriterClosed();
        this.closeElementIfStarted();
        this.doWrite("&nbsp;");
    }

    public void startDocument() throws IOException {
        this.checkIfWriterClosed();
    }

    public void closeElementIfStarted() {
        if (this.elementStarted != null) {
            if (HtmlResponseWriterUtil.isEmptyTag(this.elementStarted)) {
                this.doWrite(" />");
            } else {
                this.doWrite(">");
            }
            this.elementStarted = null;
        }
    }

    protected void doWrite(String content) {
        this.append(content);
    }

    private void doWrite(char[] cbuf, int off, int len) {
        this.append(String.valueOf(cbuf, off, len));
    }

    private void checkIfWriterClosed() {
        if (this.closed) {
            String msg = "Operation is not allowed since the writer was closed.";
            throw new IllegalStateException(msg);
        }
    }
}

