/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.util;

import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.internal.service.ContextProvider;

public final class URLHelper {
    public static final String EQUAL = "=";
    public static final String AMPERSAND = "&";
    public static final String QUESTION_MARK = "?";
    private static final String ENCODING_DUMMY = "w4t_enc";

    private URLHelper() {
    }

    public static String getSerlvetName() {
        String result = ContextProvider.getRequest().getServletPath();
        if (result.startsWith("/")) {
            result = result.substring(1);
        }
        return result;
    }

    public static String getURLString(boolean addEncodingDummy) {
        HttpServletRequest request = ContextProvider.getRequest();
        StringBuffer result = new StringBuffer();
        result.append(URLHelper.getContextURLString());
        result.append(request.getServletPath());
        if (addEncodingDummy) {
            result.append(QUESTION_MARK);
            result.append(ENCODING_DUMMY);
            result.append("=no");
        }
        return result.toString();
    }

    public static String getContextURLString() {
        HttpServletRequest request = ContextProvider.getRequest();
        StringBuffer result = new StringBuffer();
        result.append(URLHelper.getServerURL());
        result.append(request.getContextPath());
        return result.toString();
    }

    private static String getServerURL() {
        HttpServletRequest request = ContextProvider.getRequest();
        String port = URLHelper.createPortPattern(request);
        StringBuffer result = new StringBuffer();
        String serverName = request.getServerName();
        result.append(request.getScheme());
        result.append("://");
        result.append(serverName);
        result.append(port);
        return result.toString();
    }

    private static String createPortPattern(HttpServletRequest request) {
        String result = String.valueOf(request.getServerPort());
        if (result != null && !result.equals("")) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(":");
            buffer.append(result);
            result = buffer.toString();
        } else {
            result = "";
        }
        return result;
    }

    public static void appendFirstParam(StringBuffer buffer, String key, String value) {
        buffer.append(QUESTION_MARK);
        buffer.append(key);
        buffer.append(EQUAL);
        buffer.append(value);
    }

    public static void appendParam(StringBuffer buffer, String key, String value) {
        buffer.append(AMPERSAND);
        buffer.append(key);
        buffer.append(EQUAL);
        buffer.append(value);
    }
}

