/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.rwt.service.ISessionStore;

public abstract class SessionSingletonBase {
    public static final String LOCK;
    private static final String PREFIX = "com_w4t_session_singleton_";
    private static final String LOCK_POSTFIX = "#typeLock";
    private static final Class[] EMPTY_PARAMS;
    private static final Map instanceKeyMap;
    private static final Map lockKeyMap;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.SessionSingletonBase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOCK = String.valueOf(clazz.getName()) + ".Lock";
        EMPTY_PARAMS = new Class[0];
        instanceKeyMap = new Hashtable();
        lockKeyMap = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getInstance(Class type) {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        Object result = null;
        if (stateInfo != null) {
            result = stateInfo.getAttribute(SessionSingletonBase.getInstanceKey(type));
        }
        if (result == null) {
            Object object = SessionSingletonBase.getInstanceLock(type);
            synchronized (object) {
                result = SessionSingletonBase.getInstanceInternal(type);
            }
            if (stateInfo != null) {
                stateInfo.setAttribute(SessionSingletonBase.getInstanceKey(type), result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getInstanceLock(Class type) {
        ISessionStore session = ContextProvider.getSession();
        Object result = null;
        Object object = session.getAttribute(LOCK);
        synchronized (object) {
            result = session.getAttribute(SessionSingletonBase.getLockKey(type));
            if (result == null) {
                result = new Object();
                session.setAttribute(SessionSingletonBase.getLockKey(type), result);
            }
        }
        return result;
    }

    private static String getInstanceKey(Class type) {
        String name = type.getName();
        String result = (String)instanceKeyMap.get(name);
        if (result == null) {
            StringBuffer key = new StringBuffer(PREFIX);
            key.append(name);
            instanceKeyMap.put(name, key.toString());
        }
        return result;
    }

    private static String getLockKey(Class type) {
        String name = type.getName();
        String result = (String)lockKeyMap.get(name);
        if (result == null) {
            StringBuffer key = new StringBuffer(PREFIX);
            key.append(name);
            key.append(LOCK_POSTFIX);
            lockKeyMap.put(name, key.toString());
        }
        return result;
    }

    private static Object getInstanceInternal(Class type) {
        Object result = SessionSingletonBase.getAttribute(SessionSingletonBase.getInstanceKey(type));
        if (result == null) {
            try {
                Constructor constructor = type.getDeclaredConstructor(EMPTY_PARAMS);
                if (constructor.isAccessible()) {
                    result = type.newInstance();
                } else {
                    constructor.setAccessible(true);
                    result = constructor.newInstance(null);
                }
            }
            catch (SecurityException ex) {
                String msg = "Could not created the session singleton instance of '" + type.getName() + "' due to security restrictions that probably do " + "not allow reflection.";
                throw new RuntimeException(msg, ex);
            }
            catch (IllegalArgumentException iae) {
                String msg = "Could not create the session singleton instance of '" + type.getName() + "'. Probably there is no parameterless constructor.";
                throw new RuntimeException(msg, iae);
            }
            catch (NoSuchMethodException nsme) {
                String msg = "Could not create the session singleton instance of '" + type.getName() + "'. Probably there is no parameterless constructor.";
                throw new RuntimeException(msg, nsme);
            }
            catch (InstantiationException ise) {
                String msg = "Could not create the session singleton instance of '" + type.getName() + "'. Unable to create an instance.";
                throw new RuntimeException(msg, ise);
            }
            catch (IllegalAccessException iae) {
                String msg = "Could not create the session singleton instance of '" + type.getName() + "'. Not allowed to access the constructor " + "for unknown reasons.";
                throw new RuntimeException(msg, iae);
            }
            catch (InvocationTargetException ite) {
                String msg = "Could not create the session singleton instance of '" + type.getName() + "' because an Exception was thrown by the constructor:\n" + ite.getCause().getMessage() + ".";
                throw new RuntimeException(msg, ite);
            }
            SessionSingletonBase.setAttribute(SessionSingletonBase.getInstanceKey(type), result);
        }
        return result;
    }

    private static Object getAttribute(String name) {
        return ContextProvider.getSession().getAttribute(name);
    }

    private static void setAttribute(String name, Object object) {
        ContextProvider.getSession().setAttribute(name, object);
    }
}

