/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.lifecycle;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.SessionSingletonBase;
import org.eclipse.rwt.internal.lifecycle.HtmlResponseWriter;
import org.eclipse.rwt.internal.lifecycle.UICallBackManager;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.rwt.service.IServiceHandler;
import org.eclipse.rwt.service.ISessionStore;

public class UICallBackServiceHandler
implements IServiceHandler {
    public static final String HANDLER_ID;
    static final String JS_SEND_CALLBACK_REQUEST = "org.eclipse.swt.Request.getInstance().enableUICallBack();";
    private static final String JS_SEND_UI_REQUEST = "org.eclipse.swt.Request.getInstance().send();";
    private static final String BUFFERED_SEND_CALLBACK_REQUEST;
    private static final String NEED_UI_CALLBACK_ACTIVATOR;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.lifecycle.UICallBackServiceHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HANDLER_ID = clazz.getName();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.rwt.internal.lifecycle.UICallBackServiceHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BUFFERED_SEND_CALLBACK_REQUEST = String.valueOf(clazz2.getName()) + "#jsUICallback";
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("org.eclipse.rwt.internal.lifecycle.UICallBackServiceHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        NEED_UI_CALLBACK_ACTIVATOR = String.valueOf(clazz3.getName()) + "#needUICallBackActivator";
    }

    public void service() throws IOException, ServletException {
        ISessionStore sessionStore = RWT.getSessionStore();
        if (!UICallBackManager.getInstance().blockCallBackRequest() && ContextProvider.hasContext() && sessionStore.isBound()) {
            UICallBackServiceHandler.writeResponse();
        }
    }

    public static void activateUICallBacksFor(String id) {
        int size = IdManager.getInstance().add(id);
        if (size == 1) {
            UICallBackServiceHandler.registerUICallBackActivator();
        }
    }

    private static void registerUICallBackActivator() {
        ISessionStore session = ContextProvider.getSession();
        session.setAttribute(NEED_UI_CALLBACK_ACTIVATOR, Boolean.TRUE);
    }

    public static void deactivateUICallBacksFor(String id) {
        int size = IdManager.getInstance().remove(id);
        if (size == 0) {
            UICallBackManager instance = UICallBackManager.getInstance();
            instance.setActive(false);
            instance.sendUICallBack();
        }
    }

    public static void writeActivation() throws IOException {
        if (UICallBackServiceHandler.needsActivation()) {
            ISessionStore session = ContextProvider.getSession();
            session.setAttribute(NEED_UI_CALLBACK_ACTIVATOR, Boolean.FALSE);
            UICallBackManager.getInstance().setActive(true);
            IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
            HtmlResponseWriter writer = stateInfo.getResponseWriter();
            writer.write(JS_SEND_CALLBACK_REQUEST);
        }
    }

    private static boolean needsActivation() {
        ISessionStore session = ContextProvider.getSession();
        return UICallBackServiceHandler.isUICallBackActive() && Boolean.TRUE == session.getAttribute(NEED_UI_CALLBACK_ACTIVATOR) && !UICallBackManager.getInstance().isCallBackRequestBlocked();
    }

    static void writeResponse() throws IOException {
        HttpServletResponse response = ContextProvider.getResponse();
        response.setHeader("Content-Type", "text/javascript; charset=UTF-8");
        PrintWriter writer = response.getWriter();
        writer.print(UICallBackServiceHandler.jsUICallBack());
        writer.flush();
    }

    private static String jsUICallBack() {
        String result;
        if (UICallBackServiceHandler.isUICallBackActive() && !UICallBackManager.getInstance().isCallBackRequestBlocked()) {
            ISessionStore session = ContextProvider.getSession();
            String bufferedCode = (String)session.getAttribute(BUFFERED_SEND_CALLBACK_REQUEST);
            if (bufferedCode == null) {
                StringBuffer code = new StringBuffer();
                code.append(JS_SEND_UI_REQUEST);
                code.append(JS_SEND_CALLBACK_REQUEST);
                bufferedCode = code.toString();
                session.setAttribute(BUFFERED_SEND_CALLBACK_REQUEST, bufferedCode);
            }
            result = bufferedCode;
        } else {
            result = JS_SEND_UI_REQUEST;
        }
        return result;
    }

    static boolean isUICallBackActive() {
        boolean result;
        boolean bl = result = !IdManager.getInstance().isEmpty();
        if (!result) {
            result = UICallBackManager.getInstance().hasRunnables();
        }
        return result;
    }

    private static final class IdManager {
        private final Set ids = new HashSet();
        private final Object lock = new Object();

        static IdManager getInstance() {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.rwt.internal.lifecycle.UICallBackServiceHandler$IdManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IdManager)SessionSingletonBase.getInstance(clazz);
        }

        private IdManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int add(String id) {
            Object object = this.lock;
            synchronized (object) {
                this.ids.add(id);
                return this.ids.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int remove(String id) {
            Object object = this.lock;
            synchronized (object) {
                this.ids.remove(id);
                return this.ids.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isEmpty() {
            Object object = this.lock;
            synchronized (object) {
                return this.ids.isEmpty();
            }
        }
    }
}

