/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rwt.internal.lifecycle.LifeCycleAdapterUtil;
import org.eclipse.rwt.internal.theme.IThemeAdapter;
import org.eclipse.rwt.internal.theme.ThemeManagerException;
import org.eclipse.swt.widgets.Widget;

public final class ThemeAdapterUtil {
    private static final Map themeAdapters = new HashMap();
    static /* synthetic */ Class class$0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IThemeAdapter getThemeAdapter(Widget widget) {
        IThemeAdapter result;
        Class<?> widgetClass = widget.getClass();
        Map map = themeAdapters;
        synchronized (map) {
            result = (IThemeAdapter)themeAdapters.get(widgetClass);
            if (result == null) {
                IThemeAdapter adapter = null;
                Class<?> superClass = widgetClass;
                while (true) {
                    Class<?> clazz;
                    if ((clazz = class$0) == null) {
                        try {
                            clazz = Class.forName("java.lang.Object");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz.equals(superClass) || adapter != null) {
                        themeAdapters.put(widgetClass, adapter);
                        result = adapter;
                        break;
                    }
                    adapter = ThemeAdapterUtil.loadThemeAdapter(superClass);
                    if (adapter != null) continue;
                    superClass = superClass.getSuperclass();
                }
            }
        }
        if (result == null) {
            String text = "Failed to obtain theme adapter for class ''{0}''.";
            Object[] params = new Object[]{widgetClass.getName()};
            String msg = MessageFormat.format(text, params);
            throw new ThemeManagerException(msg);
        }
        return result;
    }

    private static IThemeAdapter loadThemeAdapter(Class clazz) {
        IThemeAdapter result = null;
        String packageName = clazz.getPackage().getName();
        String[] variants = LifeCycleAdapterUtil.getPackageVariants(packageName);
        int i = 0;
        while (result == null && i < variants.length) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(variants[i]);
            buffer.append(".");
            String simpleClassName = LifeCycleAdapterUtil.getSimpleClassName(clazz);
            buffer.append(simpleClassName.toLowerCase());
            buffer.append("kit.");
            buffer.append(simpleClassName);
            buffer.append("ThemeAdapter");
            String classToLoad = buffer.toString();
            ClassLoader loader = clazz.getClassLoader();
            result = ThemeAdapterUtil.loadThemeAdapter(classToLoad, loader);
            ++i;
        }
        return result;
    }

    private static IThemeAdapter loadThemeAdapter(String className, ClassLoader classLoader) {
        IThemeAdapter result = null;
        try {
            Class<?> adapterClass = classLoader.loadClass(className);
            result = (IThemeAdapter)adapterClass.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException e) {
            String message = "Failed to instantiate theme adapter class " + className;
            throw new ThemeManagerException(message, e);
        }
        catch (IllegalAccessException e) {
            String message = "Failed to instantiate theme adapter class " + className;
            throw new ThemeManagerException(message, e);
        }
        return result;
    }
}

