/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.rwt.internal.AdapterManagerImpl;
import org.eclipse.rwt.internal.lifecycle.CurrentPhase;
import org.eclipse.rwt.internal.lifecycle.DisplayUtil;
import org.eclipse.rwt.internal.lifecycle.LifeCycleFactory;
import org.eclipse.rwt.internal.lifecycle.RWTLifeCycle;
import org.eclipse.rwt.internal.lifecycle.UICallBackManager;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.ServletLog;
import org.eclipse.rwt.internal.theme.QxColor;
import org.eclipse.rwt.internal.theme.QxImage;
import org.eclipse.rwt.internal.theme.QxType;
import org.eclipse.rwt.internal.theme.SimpleSelector;
import org.eclipse.rwt.internal.theme.ThemeUtil;
import org.eclipse.rwt.lifecycle.PhaseId;
import org.eclipse.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rwt.lifecycle.UICallBack;
import org.eclipse.rwt.service.IServiceStore;
import org.eclipse.rwt.service.ISessionStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.ResourceFactory;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.internal.widgets.WidgetAdapter;
import org.eclipse.swt.internal.widgets.WidgetTreeVisitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.swt.widgets.TimerExecScheduler;
import org.eclipse.swt.widgets.Widget;

public class Display
extends Device
implements Adaptable {
    private static final String AVAILABLE_WIDTH = "w4t_width";
    private static final String AVAILABLE_HEIGHT = "w4t_height";
    private static final String ATTR_INVALIDATE_FOCUS;
    private static final String APP_NAME;
    private static final String APP_VERSION;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.widgets.";
    private static final int DOUBLE_CLICK_TIME = 500;
    private static final int GROW_SIZE = 1024;
    private static WeakReference[] displays;
    private final List shells;
    private final Thread thread;
    private final ISessionStore session;
    private final Rectangle bounds;
    private final Point cursorLocation;
    private int scrollBarSize;
    private Shell activeShell;
    private List filters;
    private Control focusControl;
    private final Monitor monitor;
    private IDisplayAdapter displayAdapter;
    private WidgetAdapter widgetAdapter;
    private Set closeListeners;
    private Set disposeListeners;
    private Runnable[] disposeList;
    private Composite[] layoutDeferred;
    private int layoutDeferredCount;
    private Widget[] skinList;
    private int skinCount;
    private Set skinListeners;
    private Object data;
    private String[] keys;
    private Object[] values;
    private Synchronizer synchronizer;
    private TimerExecScheduler scheduler;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.widgets.Display$DisplayAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ATTR_INVALIDATE_FOCUS = String.valueOf(clazz.getName()) + "#invalidateFocus";
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.swt.widgets.Display");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        APP_NAME = String.valueOf(clazz2.getName()) + "#appName";
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.swt.widgets.Display");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        APP_VERSION = String.valueOf(clazz3.getName()) + "#appVersion";
        displays = new WeakReference[4];
    }

    public static Display getCurrent() {
        Display result = RWTLifeCycle.getSessionDisplay();
        if (result != null && (result.isDisposed() || result.getThread() != Thread.currentThread())) {
            result = null;
        }
        return result;
    }

    public static Display getDefault() {
        Display result = RWTLifeCycle.getSessionDisplay();
        if (result == null && Display.isUIThread()) {
            result = new Display();
        }
        return result;
    }

    private static boolean isUIThread() {
        return ContextProvider.hasContext() && RWTLifeCycle.getUIThreadHolder() != null && RWTLifeCycle.getUIThreadHolder().getThread() != null && Thread.currentThread() == RWTLifeCycle.getUIThreadHolder().getThread();
    }

    public Display() {
        if (Display.getCurrent() != null) {
            SWT.error(20, null, " [multiple displays]");
        }
        RWTLifeCycle.setSessionDisplay(this);
        this.thread = Thread.currentThread();
        this.session = ContextProvider.getSession();
        this.shells = new ArrayList();
        this.monitor = new Monitor(this);
        this.cursorLocation = new Point(0, 0);
        this.bounds = this.readInitialBounds();
        this.readScrollBarSize();
        this.register();
        this.synchronizer = new Synchronizer(this);
        this.scheduler = new TimerExecScheduler(this);
    }

    public Rectangle getBounds() {
        this.checkDevice();
        return new Rectangle(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
    }

    public Control getFocusControl() {
        this.checkDevice();
        return this.focusControl;
    }

    private void setFocusControl(Control focusControl) {
        if (this.focusControl != focusControl) {
            FocusEvent event;
            if (this.focusControl != null && !this.focusControl.isInDispose()) {
                event = new FocusEvent(this.focusControl, 16);
                event.processEvent();
            }
            this.focusControl = focusControl;
            if (this.focusControl != null) {
                event = new FocusEvent(this.focusControl, 15);
                event.processEvent();
            }
        }
    }

    public Point map(Control from, Control to, Point point) {
        this.checkDevice();
        if (point == null) {
            SWT.error(4);
        }
        return this.map(from, to, point.x, point.y);
    }

    public Point map(Control from, Control to, int x, int y) {
        this.checkDevice();
        Rectangle rectangle = this.map(from, to, x, y, 0, 0);
        return new Point(rectangle.x, rectangle.y);
    }

    public Rectangle map(Control from, Control to, Rectangle rectangle) {
        this.checkDevice();
        if (rectangle == null) {
            SWT.error(4);
        }
        return this.map(from, to, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle map(Control from, Control to, int x, int y, int width, int height) {
        this.checkDevice();
        int newX = x;
        int newY = y;
        if (from != null) {
            Point fromOrigin = Display.getAbsoluteOrigin(from);
            newX += fromOrigin.x;
            newY += fromOrigin.y;
        }
        if (to != null) {
            Point toOrigin = Display.getAbsoluteOrigin(to);
            newX -= toOrigin.x;
            newY -= toOrigin.y;
        }
        return new Rectangle(newX, newY, width, height);
    }

    private static Point getAbsoluteOrigin(Control control) {
        Control currentControl = control;
        Point absolute = new Point(0, 0);
        while (currentControl != null) {
            Point origin = Display.getOrigin(currentControl);
            absolute.x += origin.x;
            absolute.y += origin.y;
            currentControl = currentControl instanceof Shell ? null : currentControl.getParent();
        }
        return new Point(absolute.x, absolute.y);
    }

    private static Point getOrigin(Control control) {
        Point result = control.getLocation();
        if (control instanceof Composite) {
            int borderWidth = control.getBorderWidth();
            result.x += borderWidth;
            result.y += borderWidth;
        }
        return result;
    }

    public void addListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (eventType == 21) {
            if (this.closeListeners == null) {
                this.closeListeners = new HashSet();
            }
            this.closeListeners.add(listener);
        } else if (eventType == 12) {
            if (this.disposeListeners == null) {
                this.disposeListeners = new HashSet();
            }
            this.disposeListeners.add(listener);
        } else if (eventType == 45) {
            if (this.skinListeners == null) {
                this.skinListeners = new HashSet();
            }
            this.skinListeners.add(listener);
        }
    }

    public void removeListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (eventType == 21 && this.closeListeners != null) {
            this.closeListeners.remove(listener);
            if (this.closeListeners.size() == 0) {
                this.closeListeners = null;
            }
        } else if (eventType == 12 && this.disposeListeners != null) {
            this.disposeListeners.remove(listener);
            if (this.disposeListeners.size() == 0) {
                this.disposeListeners = null;
            }
        } else if (eventType == 45 && this.skinListeners != null) {
            this.skinListeners.remove(listener);
            if (this.skinListeners.size() == 0) {
                this.skinListeners = null;
            }
        }
    }

    public void disposeExec(Runnable runnable) {
        this.checkDevice();
        if (this.disposeList == null) {
            this.disposeList = new Runnable[4];
        }
        int i = 0;
        while (i < this.disposeList.length) {
            if (this.disposeList[i] == null) {
                this.disposeList[i] = runnable;
                return;
            }
            ++i;
        }
        Runnable[] newDisposeList = new Runnable[this.disposeList.length + 4];
        System.arraycopy(this.disposeList, 0, newDisposeList, 0, this.disposeList.length);
        newDisposeList[this.disposeList.length] = runnable;
        this.disposeList = newDisposeList;
    }

    public void close() {
        this.checkDevice();
        Event event = new Event();
        event.display = this;
        event.type = 21;
        this.notifyFilters(event);
        if (this.closeListeners != null) {
            Listener[] listeners = new Listener[this.closeListeners.size()];
            this.closeListeners.toArray(listeners);
            int i = 0;
            while (i < listeners.length) {
                listeners[i].handleEvent(event);
                ++i;
            }
        }
        if (event.doit) {
            this.dispose();
        }
    }

    protected void release() {
        this.sendDisposeEvent();
        this.disposeShells();
        this.runDisposeExecs();
        this.synchronizer.releaseSynchronizer();
        this.scheduler.dispose();
    }

    protected void destroy() {
        this.deregister();
    }

    private void sendDisposeEvent() {
        Event event = new Event();
        event.display = this;
        event.type = 12;
        this.notifyFilters(event);
        if (this.disposeListeners != null) {
            Listener[] listeners = new Listener[this.disposeListeners.size()];
            this.disposeListeners.toArray(listeners);
            int i = 0;
            while (i < listeners.length) {
                try {
                    listeners[i].handleEvent(event);
                }
                catch (Throwable thr) {
                    String msg = "Exception while executing dispose-listener.";
                    ServletLog.log(msg, thr);
                }
                ++i;
            }
        }
    }

    private void disposeShells() {
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            try {
                shell.dispose();
            }
            catch (Throwable thr) {
                ServletLog.log("Exception while disposing shell: " + shell, thr);
            }
            ++i;
        }
    }

    private void runDisposeExecs() {
        if (this.disposeList != null) {
            int i = 0;
            while (i < this.disposeList.length) {
                if (this.disposeList[i] != null) {
                    try {
                        this.disposeList[i].run();
                    }
                    catch (Throwable thr) {
                        String msg = "Exception while executing dispose-runnable.";
                        ServletLog.log(msg, thr);
                    }
                }
                ++i;
            }
        }
    }

    public Object getAdapter(Class adapter) {
        Object result = null;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.swt.internal.widgets.IDisplayAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            if (this.displayAdapter == null) {
                this.displayAdapter = new DisplayAdapter(this.session);
            }
            result = this.displayAdapter;
        } else {
            Class<?> clazz2 = class$3;
            if (clazz2 == null) {
                try {
                    clazz2 = class$3 = Class.forName("org.eclipse.rwt.lifecycle.IWidgetAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter == clazz2) {
                if (this.widgetAdapter == null) {
                    this.widgetAdapter = new WidgetAdapter("w1");
                }
                result = this.widgetAdapter;
            } else {
                result = AdapterManagerImpl.getInstance().getAdapter(this, adapter);
            }
        }
        return result;
    }

    public Shell[] getShells() {
        this.checkDevice();
        Shell[] result = new Shell[this.shells.size()];
        this.shells.toArray(result);
        return result;
    }

    public Shell getActiveShell() {
        this.checkDevice();
        return this.activeShell;
    }

    final void setActiveShell(Shell activeShell) {
        this.checkDevice();
        if (this.activeShell != activeShell) {
            ShellEvent shellEvent;
            Shell lastActiveShell = this.activeShell;
            if (this.activeShell != null) {
                this.activeShell.saveFocus();
            }
            if (activeShell != null) {
                this.shells.remove(activeShell);
                this.shells.add(activeShell);
            }
            if (lastActiveShell != null && (lastActiveShell.state & 0x1000) == 0) {
                shellEvent = new ShellEvent(lastActiveShell, 27);
                shellEvent.processEvent();
            }
            this.activeShell = activeShell;
            if (activeShell != null) {
                shellEvent = new ShellEvent(activeShell, 26);
                shellEvent.processEvent();
            }
            if (this.activeShell != null) {
                this.activeShell.restoreFocus();
            }
        }
    }

    final void addShell(Shell shell) {
        this.shells.add(shell);
    }

    final void removeShell(Shell shell) {
        this.shells.remove(shell);
        if (shell == this.activeShell) {
            if (this.shells.size() > 0) {
                this.setActiveShell((Shell)this.shells.get(this.shells.size() - 1));
            } else {
                this.setActiveShell(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getThread() {
        Object object = this.deviceLock;
        synchronized (object) {
            if (this.isDisposed()) {
                this.error(45);
            }
            return this.thread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSynchronizer(Synchronizer synchronizer) {
        Synchronizer oldSynchronizer;
        this.checkDevice();
        if (synchronizer == null) {
            this.error(4);
        }
        if (synchronizer == this.synchronizer) {
            return;
        }
        Object object = this.deviceLock;
        synchronized (object) {
            oldSynchronizer = this.synchronizer;
            this.synchronizer = synchronizer;
        }
        if (oldSynchronizer != null) {
            oldSynchronizer.runAsyncMessages(true);
        }
    }

    public Synchronizer getSynchronizer() {
        this.checkDevice();
        return this.synchronizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getSyncThread() {
        Object object = this.deviceLock;
        synchronized (object) {
            if (this.isDisposed()) {
                this.error(45);
            }
            return this.synchronizer.syncThread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncExec(Runnable runnable) {
        Object object = this.deviceLock;
        synchronized (object) {
            if (this.isDisposed()) {
                this.error(45);
            }
            this.synchronizer.asyncExec(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncExec(Runnable runnable) {
        Synchronizer synchronizer;
        Object object = this.deviceLock;
        synchronized (object) {
            if (this.isDisposed()) {
                this.error(45);
            }
            synchronizer = this.synchronizer;
        }
        synchronizer.syncExec(runnable);
    }

    public void timerExec(int milliseconds, Runnable runnable) {
        this.checkDevice();
        if (runnable == null) {
            this.error(4);
        }
        if (milliseconds < 0) {
            this.scheduler.cancel(runnable);
        } else {
            this.scheduler.schedule(milliseconds, runnable);
        }
    }

    public boolean readAndDispatch() {
        this.checkDevice();
        this.runSkin();
        this.runDeferredLayouts();
        return this.runPendingMessages();
    }

    private boolean runPendingMessages() {
        boolean result = false;
        if (PhaseId.PREPARE_UI_ROOT.equals(CurrentPhase.get()) || PhaseId.PROCESS_ACTION.equals(CurrentPhase.get())) {
            result = ProcessActionRunner.executeNext();
            if (!result) {
                result = TypedEvent.executeNext();
            }
            if (!result) {
                result = this.synchronizer.runAsyncMessages(false);
            }
        }
        return result;
    }

    public boolean sleep() {
        this.checkDevice();
        RWTLifeCycle lifeCycle = (RWTLifeCycle)LifeCycleFactory.getLifeCycle();
        lifeCycle.sleep();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wake() {
        Object object = this.deviceLock;
        synchronized (object) {
            if (this.isDisposed()) {
                this.error(45);
            }
            if (this.thread != Thread.currentThread()) {
                UICallBack.runNonUIThreadWithFakeContext(this, new Runnable(){

                    public void run() {
                        UICallBackManager.getInstance().sendImmediately();
                    }
                });
            }
        }
    }

    void wakeThread() {
        UICallBack.runNonUIThreadWithFakeContext(this, new Runnable(){

            public void run() {
                UICallBackManager.getInstance().sendUICallBack();
            }
        });
    }

    Object getDeviceLock() {
        return this.deviceLock;
    }

    public Color getSystemColor(int id) {
        this.checkDevice();
        Color result = null;
        QxType value = null;
        switch (id) {
            case 17: {
                value = ThemeUtil.getCssValue("Display", "rwt-darkshadow-color", SimpleSelector.DEFAULT);
                break;
            }
            case 18: {
                value = ThemeUtil.getCssValue("Display", "rwt-shadow-color", SimpleSelector.DEFAULT);
                break;
            }
            case 19: {
                value = ThemeUtil.getCssValue("Display", "rwt-lightshadow-color", SimpleSelector.DEFAULT);
                break;
            }
            case 20: {
                value = ThemeUtil.getCssValue("Display", "rwt-highlight-color", SimpleSelector.DEFAULT);
                break;
            }
            case 23: {
                value = ThemeUtil.getCssValue("Display", "rwt-thinborder-color", SimpleSelector.DEFAULT);
                break;
            }
            case 22: {
                value = ThemeUtil.getCssValue("NONE", "background-color", SimpleSelector.DEFAULT);
                break;
            }
            case 21: {
                value = ThemeUtil.getCssValue("NONE", "color", SimpleSelector.DEFAULT);
                break;
            }
            case 24: {
                value = ThemeUtil.getCssValue("List", "color", SimpleSelector.DEFAULT);
                break;
            }
            case 25: {
                value = ThemeUtil.getCssValue("List", "background-color", SimpleSelector.DEFAULT);
                break;
            }
            case 26: {
                value = ThemeUtil.getCssValue("List-Item", "background-color", SimpleSelector.SELECTED);
                break;
            }
            case 27: {
                value = ThemeUtil.getCssValue("List-Item", "color", SimpleSelector.SELECTED);
                break;
            }
            case 28: {
                value = ThemeUtil.getCssValue("ToolTip", "color", SimpleSelector.DEFAULT);
                break;
            }
            case 29: {
                value = ThemeUtil.getCssValue("Display", "rwt-infobackground-color", SimpleSelector.DEFAULT);
                break;
            }
            case 30: {
                value = ThemeUtil.getCssValue("Shell-Titlebar", "color", SimpleSelector.DEFAULT);
                break;
            }
            case 33: {
                value = ThemeUtil.getCssValue("Shell-Titlebar", "color", SimpleSelector.INACTIVE);
                break;
            }
            case 31: {
                value = ThemeUtil.getCssValue("Shell-Titlebar", "background-color", SimpleSelector.DEFAULT);
                break;
            }
            case 34: {
                value = ThemeUtil.getCssValue("Shell-Titlebar", "background-color", SimpleSelector.INACTIVE);
                break;
            }
            case 32: {
                value = ThemeUtil.getCssValue("Shell-Titlebar", "background-gradient-color", SimpleSelector.DEFAULT);
                break;
            }
            case 35: {
                value = ThemeUtil.getCssValue("Shell-Titlebar", "background-gradient-color", SimpleSelector.INACTIVE);
                break;
            }
            default: {
                result = super.getSystemColor(id);
            }
        }
        if (value != null && (result = QxColor.createColor((QxColor)value)) == null) {
            throw new IllegalArgumentException("Transparent system color");
        }
        return result;
    }

    public Image getSystemImage(int id) {
        this.checkDevice();
        Image result = null;
        QxType value = null;
        switch (id) {
            case 1: {
                value = ThemeUtil.getCssValue("Display", "rwt-error-image", SimpleSelector.DEFAULT);
                break;
            }
            case 2: 
            case 16: {
                value = ThemeUtil.getCssValue("Display", "rwt-information-image", SimpleSelector.DEFAULT);
                break;
            }
            case 4: {
                value = ThemeUtil.getCssValue("Display", "rwt-question-image", SimpleSelector.DEFAULT);
                break;
            }
            case 8: {
                value = ThemeUtil.getCssValue("Display", "rwt-warning-image", SimpleSelector.DEFAULT);
            }
        }
        if (value != null) {
            QxImage image = (QxImage)value;
            try {
                InputStream inStream = image.loader.getResourceAsStream(image.path);
                result = Graphics.getImage(image.path, inStream);
                inStream.close();
            }
            catch (IOException shouldNotHappen) {
                String txt = "Could not read system image from ''{0}''.";
                String msg = MessageFormat.format(txt, image.path);
                throw new RuntimeException(msg, shouldNotHappen);
            }
        }
        return result;
    }

    public Cursor getSystemCursor(int id) {
        this.checkDevice();
        return ResourceFactory.getCursor(id);
    }

    public int getDoubleClickTime() {
        this.checkDevice();
        return 500;
    }

    public Control getCursorControl() {
        this.checkDevice();
        ControlFinder finder = new ControlFinder(this, this.getCursorLocation());
        return finder.getControl();
    }

    public int getDismissalAlignment() {
        this.checkDevice();
        return 16384;
    }

    public boolean getHighContrast() {
        this.checkDevice();
        return false;
    }

    public Point getCursorLocation() {
        this.checkDevice();
        return new Point(this.cursorLocation.x, this.cursorLocation.y);
    }

    public void addFilter(final int eventType, final Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        this.filters.add(new IDisplayAdapter.IFilterEntry(){

            public Listener getListener() {
                return listener;
            }

            public int getType() {
                return eventType;
            }
        });
    }

    public void removeFilter(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        IDisplayAdapter.IFilterEntry[] entries = this.getFilterEntries();
        boolean found = false;
        int i = 0;
        while (!found && i < entries.length) {
            boolean bl = found = entries[i].getListener() == listener && entries[i].getType() == eventType;
            if (found) {
                this.filters.remove(entries[i]);
            }
            ++i;
        }
        if (this.filters != null && this.filters.isEmpty()) {
            this.filters = null;
        }
    }

    void error(int code) {
        SWT.error(code);
    }

    void addLayoutDeferred(Composite comp) {
        if (this.layoutDeferred == null) {
            this.layoutDeferred = new Composite[64];
        }
        if (this.layoutDeferredCount == this.layoutDeferred.length) {
            Composite[] temp = new Composite[this.layoutDeferred.length + 64];
            System.arraycopy(this.layoutDeferred, 0, temp, 0, this.layoutDeferred.length);
            this.layoutDeferred = temp;
        }
        this.layoutDeferred[this.layoutDeferredCount++] = comp;
    }

    boolean runDeferredLayouts() {
        boolean result = false;
        if (this.layoutDeferredCount != 0) {
            Composite[] temp = this.layoutDeferred;
            int count = this.layoutDeferredCount;
            this.layoutDeferred = null;
            this.layoutDeferredCount = 0;
            int i = 0;
            while (i < count) {
                Composite comp = temp[i];
                if (!comp.isDisposed()) {
                    comp.setLayoutDeferred(false);
                }
                ++i;
            }
            result = true;
        }
        return result;
    }

    void addSkinnableWidget(Widget widget) {
        if (this.skinList == null) {
            this.skinList = new Widget[1024];
        }
        if (this.skinCount >= this.skinList.length) {
            Widget[] newSkinWidgets = new Widget[this.skinList.length + 1024];
            System.arraycopy(this.skinList, 0, newSkinWidgets, 0, this.skinList.length);
            this.skinList = newSkinWidgets;
        }
        this.skinList[this.skinCount++] = widget;
    }

    boolean runSkin() {
        boolean result = false;
        if (this.skinCount > 0) {
            Widget[] oldSkinWidgets = this.skinList;
            int count = this.skinCount;
            this.skinList = new Widget[1024];
            this.skinCount = 0;
            int i = 0;
            while (i < count) {
                Widget widget = oldSkinWidgets[i];
                if (widget != null && !widget.isDisposed()) {
                    widget.state &= 0xFFDFFFFF;
                    oldSkinWidgets[i] = null;
                    this.sendSkinEvent(widget);
                }
                ++i;
            }
            result = true;
        }
        return result;
    }

    private void sendSkinEvent(Widget widget) {
        Event event = new Event();
        event.widget = widget;
        event.display = this;
        event.type = 45;
        this.notifyFilters(event);
        if (this.skinListeners != null) {
            Listener[] listeners = new Listener[this.skinListeners.size()];
            this.skinListeners.toArray(listeners);
            int i = 0;
            while (i < listeners.length) {
                listeners[i].handleEvent(event);
                ++i;
            }
        }
    }

    public Object getData() {
        this.checkDevice();
        return this.data;
    }

    public void setData(Object data) {
        this.checkDevice();
        this.data = data;
    }

    public void setData(String key, Object value) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (value == null) {
            if (this.keys == null) {
                return;
            }
            int index = 0;
            while (index < this.keys.length && !this.keys[index].equals(key)) {
                ++index;
            }
            if (index == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] newKeys = new String[this.keys.length - 1];
                Object[] newValues = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, newKeys, 0, index);
                System.arraycopy(this.keys, index + 1, newKeys, index, newKeys.length - index);
                System.arraycopy(this.values, 0, newValues, 0, index);
                System.arraycopy(this.values, index + 1, newValues, index, newValues.length - index);
                this.keys = newKeys;
                this.values = newValues;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{key};
            this.values = new Object[]{value};
            return;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                this.values[i] = value;
                return;
            }
            ++i;
        }
        String[] newKeys = new String[this.keys.length + 1];
        Object[] newValues = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, newKeys, 0, this.keys.length);
        System.arraycopy(this.values, 0, newValues, 0, this.values.length);
        newKeys[this.keys.length] = key;
        newValues[this.values.length] = value;
        this.keys = newKeys;
        this.values = newValues;
    }

    public Object getData(String key) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (this.keys == null) {
            return null;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                return this.values[i];
            }
            ++i;
        }
        return null;
    }

    public Monitor[] getMonitors() {
        this.checkDevice();
        Monitor[] result = new Monitor[]{this.monitor};
        return result;
    }

    public Monitor getPrimaryMonitor() {
        this.checkDevice();
        return this.monitor;
    }

    public void update() {
        this.checkDevice();
    }

    public void beep() {
        this.checkDevice();
    }

    public static String getAppName() {
        ISessionStore session = ContextProvider.getSession();
        return (String)session.getAttribute(APP_NAME);
    }

    public static String getAppVersion() {
        ISessionStore session = ContextProvider.getSession();
        return (String)session.getAttribute(APP_VERSION);
    }

    public static void setAppName(String name) {
        ISessionStore session = ContextProvider.getSession();
        session.setAttribute(APP_NAME, name);
    }

    public static void setAppVersion(String version) {
        ISessionStore session = ContextProvider.getSession();
        session.setAttribute(APP_VERSION, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display findDisplay(Thread thread) {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            Display result = null;
            int i = 0;
            while (result == null && i < displays.length) {
                Display display;
                WeakReference current = displays[i];
                if (current != null && (display = (Display)current.get()) != null && !display.isDisposed() && display.thread == thread) {
                    result = display;
                }
                ++i;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register() {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            boolean registered = false;
            int i = 0;
            while (i < displays.length && !registered) {
                if (this.canDisplayRefBeReplaced(displays[i])) {
                    Display.displays[i] = new WeakReference<Display>(this);
                    registered = true;
                }
                ++i;
            }
            if (!registered) {
                WeakReference[] newDisplays = new WeakReference[displays.length + 4];
                System.arraycopy(displays, 0, newDisplays, 0, displays.length);
                newDisplays[Display.displays.length] = new WeakReference<Display>(this);
                displays = newDisplays;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private boolean canDisplayRefBeReplaced(WeakReference displayRef) {
        boolean result = false;
        if (displayRef == null) {
            result = true;
        } else {
            Display display = (Display)displayRef.get();
            if (display == null || display.thread == this.thread) {
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregister() {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            int i = 0;
            while (i < displays.length) {
                WeakReference current = displays[i];
                if (current != null && this == current.get()) {
                    Display.displays[i] = null;
                }
                ++i;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static boolean isValidClass(Class clazz) {
        return true;
    }

    boolean isValidThread() {
        return this.thread == Thread.currentThread();
    }

    protected void checkDevice() {
        if (!this.isValidThread()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    private Rectangle readInitialBounds() {
        HttpServletRequest request = ContextProvider.getRequest();
        String widthVal = request.getParameter(AVAILABLE_WIDTH);
        int width = 1024;
        if (widthVal != null) {
            width = Integer.parseInt(widthVal);
        }
        String heightVal = request.getParameter(AVAILABLE_HEIGHT);
        int height = 768;
        if (heightVal != null) {
            height = Integer.parseInt(heightVal);
        }
        return new Rectangle(0, 0, width, height);
    }

    private void readScrollBarSize() {
        String parameterName;
        this.scrollBarSize = 16;
        HttpServletRequest request = ContextProvider.getRequest();
        String value = request.getParameter(parameterName = String.valueOf(DisplayUtil.getId(this)) + ".scrollbar.size");
        if (value != null) {
            this.scrollBarSize = Integer.parseInt(value);
        }
    }

    private void notifyFilters(Event event) {
        IDisplayAdapter.IFilterEntry[] filterEntries = this.getFilterEntries();
        int i = 0;
        while (i < filterEntries.length) {
            if (filterEntries[i].getType() == event.type) {
                try {
                    filterEntries[i].getListener().handleEvent(event);
                }
                catch (Throwable thr) {
                    String msg = "Exception while executing filter.";
                    ServletLog.log(msg, thr);
                }
            }
            ++i;
        }
    }

    private IDisplayAdapter.IFilterEntry[] getFilterEntries() {
        IDisplayAdapter.IFilterEntry[] result = IDisplayAdapter.EMPTY_FILTERS;
        if (this.filters != null) {
            result = new IDisplayAdapter.IFilterEntry[this.filters.size()];
            this.filters.toArray(result);
        }
        return result;
    }

    private static final class ControlFinder {
        private final Display display;
        private final Point location;
        private final Set foundComponentInParent;
        private Control control;

        ControlFinder(Display display, Point location) {
            this.display = display;
            this.location = new Point(location.x, location.y);
            this.foundComponentInParent = new HashSet();
            this.find();
        }

        Control getControl() {
            return this.control;
        }

        private void find() {
            Shell[] shells = this.display.getShells();
            int i = 0;
            while (this.control == null && i < shells.length) {
                WidgetTreeVisitor.accept(shells[i], new WidgetTreeVisitor.AllWidgetTreeVisitor(this){
                    final /* synthetic */ ControlFinder this$1;
                    {
                        this.this$1 = controlFinder;
                    }

                    public boolean doVisit(Widget widget) {
                        boolean result = true;
                        if (widget instanceof Control) {
                            result = ControlFinder.access$0(this.this$1, (Control)widget);
                        }
                        return result;
                    }
                });
                ++i;
            }
        }

        private boolean visitControl(Control control) {
            Rectangle bounds = this.getAbsoluteBounds(control);
            boolean result = false;
            if (control.isVisible() && bounds.contains(this.location) && (result = this.foundComponentInParent.add(control.getParent()))) {
                this.control = control;
            }
            return result;
        }

        private Rectangle getAbsoluteBounds(Control control) {
            Rectangle bounds = control.getBounds();
            Point origin = Display.getAbsoluteOrigin(control);
            return new Rectangle(origin.x, origin.y, bounds.width, bounds.height);
        }

        static /* synthetic */ boolean access$0(ControlFinder controlFinder, Control control) {
            return controlFinder.visitControl(control);
        }
    }

    private final class DisplayAdapter
    implements IDisplayAdapter {
        private final ISessionStore session;

        private DisplayAdapter(ISessionStore session) {
            this.session = session;
        }

        public void setBounds(Rectangle bounds) {
            ((Display)Display.this).bounds.x = bounds.x;
            ((Display)Display.this).bounds.y = bounds.y;
            ((Display)Display.this).bounds.width = bounds.width;
            ((Display)Display.this).bounds.height = bounds.height;
        }

        public void setCursorLocation(int x, int y) {
            ((Display)Display.this).cursorLocation.x = x;
            ((Display)Display.this).cursorLocation.y = y;
        }

        public void setActiveShell(Shell activeShell) {
            Display.this.setActiveShell(activeShell);
        }

        public void setFocusControl(Control focusControl) {
            Display.this.setFocusControl(focusControl);
        }

        public void invalidateFocus() {
            RWT.getServiceStore().setAttribute(ATTR_INVALIDATE_FOCUS, Boolean.TRUE);
        }

        public boolean isFocusInvalidated() {
            IServiceStore serviceStore = RWT.getServiceStore();
            Object value = serviceStore.getAttribute(ATTR_INVALIDATE_FOCUS);
            return value != null;
        }

        public Shell[] getShells() {
            Shell[] result = new Shell[Display.this.shells.size()];
            Display.this.shells.toArray(result);
            return result;
        }

        public ISessionStore getSession() {
            return this.session;
        }

        public IDisplayAdapter.IFilterEntry[] getFilters() {
            return Display.this.getFilterEntries();
        }

        public void setScrollBarSize(int size) {
            Display.this.scrollBarSize = size;
        }

        public int getScrollBarSize() {
            return Display.this.scrollBarSize;
        }

        public int getAsyncRunnablesCount() {
            return Display.this.synchronizer.getMessageCount();
        }

        public void runAsyncRunnables() {
            Display.this.synchronizer.runAsyncMessages(true);
        }

        public Object getDeviceLock() {
            return Display.this.deviceLock;
        }
    }
}

