/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.views;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.CheatSheetStopWatch;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.actions.IMenuContributor;
import org.eclipse.ui.internal.cheatsheets.data.CheatSheet;
import org.eclipse.ui.internal.cheatsheets.data.Item;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetViewer;
import org.eclipse.ui.internal.cheatsheets.views.CoreItem;
import org.eclipse.ui.internal.cheatsheets.views.IntroItem;
import org.eclipse.ui.internal.cheatsheets.views.Page;
import org.eclipse.ui.internal.cheatsheets.views.ViewItem;

public class CheatSheetPage
extends Page
implements IMenuContributor {
    private Color introColor;
    private Color activeColor;
    private Color inactiveColor1;
    private Color inactiveColor2;
    private CheatSheet cheatSheet;
    private ArrayList viewItemList;
    private CheatSheetViewer viewer;

    public CheatSheetPage(CheatSheet cheatSheet, ArrayList viewItemList, CheatSheetViewer cheatSheetViewer) {
        this.cheatSheet = cheatSheet;
        this.viewItemList = viewItemList;
        this.viewer = cheatSheetViewer;
    }

    public void createPart(Composite parent) {
        CheatSheetStopWatch.startStopWatch("CheatSheetPage.createPart()");
        super.createPart(parent);
        HyperlinkGroup hyperlinkGroup = this.toolkit.getHyperlinkGroup();
        hyperlinkGroup.setHyperlinkUnderlineMode(2);
        CheatSheetStopWatch.printLapTime("CheatSheetPage.createPart()", "Time in CheatSheetPage.createInfoArea() after super.createInfoArea(): ");
        IntroItem intro = new IntroItem(this, this.cheatSheet.getIntroItem(), this.introColor, this.viewer);
        CheatSheetStopWatch.printLapTime("CheatSheetPage.createPart()", "Time in CheatSheetPage.createInfoArea() after new IntroItem(): ");
        intro.setBold(true);
        this.viewItemList.add(intro);
        CheatSheetStopWatch.printLapTime("CheatSheetPage.createInfoArea()", "Time in CheatSheetPage.createPart() before add loop: ");
        ArrayList items = this.cheatSheet.getItems();
        int i = 0;
        while (i < items.size()) {
            Color color = i % 2 == 0 ? this.getInactiveColor1() : this.getInactiveColor2();
            CoreItem coreItem = new CoreItem(this, (Item)items.get(i), color, this.viewer);
            this.viewItemList.add(coreItem);
            ++i;
        }
        CheatSheetStopWatch.printLapTime("CheatSheetPage.createInfoArea()", "Time in CheatSheetPage.createPart(): ");
    }

    private Color getInactiveColor2() {
        return this.inactiveColor2;
    }

    private Color getInactiveColor1() {
        return this.inactiveColor1;
    }

    protected String getTitle() {
        if (this.cheatSheet != null && this.cheatSheet.getTitle() != null) {
            return this.cheatSheet.getTitle();
        }
        return "";
    }

    public void dispose() {
        super.dispose();
        this.inactiveColor1 = null;
        this.inactiveColor2 = null;
        this.activeColor = null;
        this.introColor = null;
    }

    protected void init(Display display) {
        super.init(display);
        this.computeColors(display);
    }

    private void computeColors(Display display) {
        RGB rgb;
        RGB white = new RGB(255, 255, 255);
        RGB black = new RGB(0, 0, 0);
        if (this.isReverseVideo()) {
            this.computeReverseVideoColors(display);
            return;
        }
        if (this.toolkit.getColors().isWhiteBackground()) {
            rgb = this.toolkit.getColors().getSystemColor(26);
            if (FormColors.testTwoPrimaryColors((RGB)(rgb = FormColors.blend((RGB)rgb, (RGB)white, (int)20)), (int)245, (int)256)) {
                rgb = FormColors.blend((RGB)rgb, (RGB)black, (int)80);
            } else if (FormColors.testAnyPrimaryColor((RGB)rgb, (int)170, (int)191)) {
                rgb = FormColors.blend((RGB)rgb, (RGB)white, (int)85);
            } else if (FormColors.testAnyPrimaryColor((RGB)rgb, (int)190, (int)215)) {
                rgb = FormColors.blend((RGB)rgb, (RGB)white, (int)90);
            }
            if (Math.abs(rgb.blue - rgb.green) < 5 && Math.abs(rgb.blue - rgb.red) < 5 && Math.abs(rgb.green - rgb.red) < 5) {
                rgb = FormColors.blend((RGB)rgb, (RGB)new RGB(100, 100, 255), (int)90);
            }
            this.introColor = Graphics.getColor((RGB)rgb);
            this.inactiveColor2 = Graphics.getColor((RGB)rgb);
        } else {
            rgb = this.toolkit.getColors().getSystemColor(26);
            if (FormColors.testTwoPrimaryColors((RGB)(rgb = FormColors.blend((RGB)rgb, (RGB)white, (int)30)), (int)200, (int)221)) {
                rgb = FormColors.blend((RGB)rgb, (RGB)black, (int)80);
            } else if (FormColors.testTwoPrimaryColors((RGB)rgb, (int)222, (int)241)) {
                rgb = FormColors.blend((RGB)rgb, (RGB)black, (int)60);
            } else if (FormColors.testTwoPrimaryColors((RGB)rgb, (int)240, (int)256)) {
                rgb = FormColors.blend((RGB)rgb, (RGB)black, (int)30);
            }
            this.introColor = Graphics.getColor((RGB)rgb);
            this.inactiveColor2 = Graphics.getColor((RGB)rgb);
        }
        rgb = this.inactiveColor2.getRGB();
        rgb = FormColors.blend((RGB)rgb, (RGB)this.backgroundColor.getRGB(), (int)40);
        this.inactiveColor1 = Graphics.getColor((RGB)rgb);
        this.activeColor = Graphics.getColor((RGB)this.backgroundColor.getRGB());
    }

    private void computeReverseVideoColors(Display display) {
        Color background = this.toolkit.getColors().getBackground();
        RGB white = new RGB(255, 255, 255);
        RGB rgb = background.getRGB();
        this.activeColor = Graphics.getColor((RGB)rgb);
        rgb = FormColors.blend((RGB)rgb, (RGB)white, (int)85);
        this.inactiveColor1 = Graphics.getColor((RGB)rgb);
        rgb = FormColors.blend((RGB)rgb, (RGB)white, (int)85);
        this.inactiveColor2 = Graphics.getColor((RGB)rgb);
        this.introColor = Graphics.getColor((RGB)rgb);
    }

    private boolean isReverseVideo() {
        Color bg = this.toolkit.getColors().getBackground();
        return bg.getBlue() + bg.getRed() + bg.getGreen() < 380;
    }

    public void initialized() {
        Iterator iter = this.viewItemList.iterator();
        while (iter.hasNext()) {
            ViewItem item = (ViewItem)iter.next();
            item.initialized();
        }
    }

    public Color getActiveColor() {
        return this.activeColor;
    }

    public ScrolledForm getForm() {
        return this.form;
    }

    public FormToolkit getToolkit() {
        return this.toolkit;
    }

    private int contributeRestartItem(Menu menu, int index) {
        MenuItem item = new MenuItem(menu, 8, index++);
        item.setText(Messages.get().RESTART_MENU);
        item.setImage(CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_RETURN"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheatSheetPage.this.viewer.restart();
            }
        });
        return index;
    }

    public int contributeToViewMenu(Menu menu, int index) {
        return this.contributeRestartItem(menu, index);
    }
}

