/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.WorkbenchPage;

public abstract class CycleBaseHandler
extends AbstractHandler
implements IExecutableExtension {
    private Object selection;
    protected IWorkbenchWindow window;
    protected boolean gotoDirection;
    private TriggerSequence[] backwardTriggerSequences = null;
    protected ParameterizedCommand commandBackward = null;
    protected ParameterizedCommand commandForward = null;
    private TriggerSequence[] forwardTriggerSequences = null;
    static /* synthetic */ Class class$0;

    protected abstract void addItems(Table var1, WorkbenchPage var2);

    protected int getCurrentItemIndex() {
        return 0;
    }

    protected abstract ParameterizedCommand getBackwardCommand();

    protected abstract ParameterizedCommand getForwardCommand();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.window = HandlerUtil.getActiveWorkbenchWindowChecked(event);
        IWorkbenchPage page = this.window.getActivePage();
        IWorkbenchPart activePart = page.getActivePart();
        this.getTriggers();
        this.openDialog((WorkbenchPage)page, activePart);
        this.clearTriggers();
        this.activate(page, this.selection);
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void openDialog(WorkbenchPage page, IWorkbenchPart activePart) {
        this.selection = null;
        final Shell dialog = new Shell(this.window.getShell(), 0);
        Display display = dialog.getDisplay();
        dialog.setLayout((Layout)new FillLayout());
        Table table = new Table((Composite)dialog, 65540);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn tc = new TableColumn(table, 0);
        tc.setResizable(false);
        tc.setText(this.getTableHeader(activePart));
        this.addItems(table, page);
        int tableItemCount = table.getItemCount();
        switch (tableItemCount) {
            case 0: {
                this.cancel(dialog);
                return;
            }
            case 1: {
                table.setSelection(0);
                break;
            }
            default: {
                int i;
                if (this.gotoDirection) {
                    i = this.getCurrentItemIndex() + 1;
                    if (i >= tableItemCount) {
                        i = 0;
                    }
                } else {
                    i = this.getCurrentItemIndex() - 1;
                    if (i < 0) {
                        i = tableItemCount - 1;
                    }
                }
                table.setSelection(i);
            }
        }
        tc.pack();
        table.pack();
        dialog.pack();
        Rectangle tableBounds = table.getBounds();
        tableBounds.height = Math.min(tableBounds.height, table.getItemHeight() * 22);
        tableBounds.height += 20;
        tableBounds.width += 20;
        table.setBounds(tableBounds);
        dialog.setBounds(dialog.computeTrim(tableBounds.x, tableBounds.y, tableBounds.width, tableBounds.height));
        tc.setWidth(table.getClientArea().width);
        table.setFocus();
        table.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                CycleBaseHandler.this.cancel(dialog);
            }
        });
        this.setDialogLocation(dialog, activePart);
        IWorkbench iWorkbench = this.window.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.ui.contexts.IContextService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        IContextService contextService = (IContextService)iWorkbench.getService(clazz);
        try {
            dialog.open();
            this.addMouseListener(table, dialog);
            contextService.registerShell(dialog, 1);
            this.addKeyListener(table, dialog);
            this.addTraverseListener(table);
            while (!dialog.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (!dialog.isDisposed()) {
                this.cancel(dialog);
            }
            contextService.unregisterShell(dialog);
            throw throwable;
        }
        {
            Object var10_13 = null;
        }
        if (!dialog.isDisposed()) {
            this.cancel(dialog);
        }
        contextService.unregisterShell(dialog);
    }

    protected void setDialogLocation(Shell dialog, IWorkbenchPart activePart) {
        Display display = dialog.getDisplay();
        Rectangle dialogBounds = dialog.getBounds();
        Rectangle parentBounds = dialog.getParent().getBounds();
        Rectangle monitorBounds = activePart == null ? display.getPrimaryMonitor().getBounds() : ((PartSite)activePart.getSite()).getPane().getControl().getMonitor().getBounds();
        dialogBounds.x = parentBounds.x + (parentBounds.width - dialogBounds.width) / 2;
        dialogBounds.y = parentBounds.y + (parentBounds.height - dialogBounds.height) / 2;
        if (!monitorBounds.contains(dialogBounds.x, dialogBounds.y) || !monitorBounds.contains(dialogBounds.x + dialogBounds.width, dialogBounds.y + dialogBounds.height)) {
            dialogBounds.x = monitorBounds.x + (monitorBounds.width - dialogBounds.width) / 2;
            dialogBounds.y = monitorBounds.y + (monitorBounds.height - dialogBounds.height) / 2;
        }
        dialog.setLocation(dialogBounds.x, dialogBounds.y);
    }

    protected void clearTriggers() {
        this.forwardTriggerSequences = null;
        this.backwardTriggerSequences = null;
    }

    protected void getTriggers() {
        this.commandForward = this.getForwardCommand();
        this.commandBackward = this.getBackwardCommand();
    }

    protected void addKeyListener(Table table, Shell dialog) {
    }

    protected final void addTraverseListener(Table table) {
    }

    protected void activate(IWorkbenchPage page, Object selectedItem) {
        if (selectedItem != null) {
            IWorkbenchPart part;
            if (selectedItem instanceof IEditorReference) {
                page.setEditorAreaVisible(true);
            }
            if (selectedItem instanceof IWorkbenchPartReference && (part = ((IWorkbenchPartReference)selectedItem).getPart(true)) != null) {
                page.activate(part);
            }
            if (selectedItem instanceof IPerspectiveDescriptor) {
                IPerspectiveDescriptor persp = (IPerspectiveDescriptor)selectedItem;
                page.setPerspective(persp);
            }
        }
    }

    protected void cancel(Shell dialog) {
        this.selection = null;
        dialog.close();
    }

    protected void ok(Shell dialog, Table table) {
        TableItem[] items = table.getSelection();
        if (items != null && items.length == 1) {
            this.selection = items[0].getData();
        }
        dialog.close();
    }

    protected void addMouseListener(final Table table, final Shell dialog) {
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CycleBaseHandler.this.ok(dialog, table);
            }
        });
    }

    protected abstract String getTableHeader(IWorkbenchPart var1);

    public Object getSelection() {
        return this.selection;
    }

    public IWorkbenchWindow getWindow() {
        return this.window;
    }

    public TriggerSequence[] getBackwardTriggerSequences() {
        return this.backwardTriggerSequences;
    }

    public TriggerSequence[] getForwardTriggerSequences() {
        return this.forwardTriggerSequences;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.gotoDirection = "true".equals(data);
    }
}

