/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.branding;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rap.ui.branding.IExitConfirmation;
import org.eclipse.rap.ui.internal.branding.Branding;
import org.eclipse.rap.ui.internal.servlet.HttpServiceTracker;
import org.eclipse.rwt.branding.AbstractBranding;
import org.eclipse.rwt.internal.branding.BrandingManager;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.osgi.framework.Bundle;

public final class BrandingExtension {
    private static final String EP_BRANDING = "org.eclipse.rap.ui.branding";
    private static final String ATT_ID = "id";
    private static final String ATT_DEFAULT_ENTRYPOINT_ID = "defaultEntrypointId";
    private static final String ATT_EXIT_CONFIRMATION_CLASS = "exitConfirmationClass";
    private static final String ATT_THEME_ID = "themeId";
    private static final String ATT_FAVICON = "favicon";
    private static final String ATT_SERVLET_NAME = "servletName";
    private static final String ATT_TITLE = "title";
    private static final String ATT_BODY = "body";
    private static final String ELEM_ADITIONAL_HEADERS = "additionalHeaders";
    private static final String ELEM_ENTRYPOINTS = "associatedEntrypoints";
    private static final String TAG_META = "meta";
    private static final String TAG_LINK = "link";
    private static final String ELEM_ATTRIBUTE = "attribute";
    private static final String ATT_NAME = "name";
    private static final String ATT_CONTENT = "content";
    private static final String ATT_REL = "rel";
    private static final String ATT_VALUE = "value";
    static /* synthetic */ Class class$0;

    public static void read() throws IOException {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(EP_BRANDING);
        IConfigurationElement[] brandings = ep.getConfigurationElements();
        int i = 0;
        while (i < brandings.length) {
            IConfigurationElement configElement = brandings[i];
            BrandingExtension.readBranding(configElement);
            ++i;
        }
        BrandingExtension.registerDefaultServletName();
    }

    private static void readBranding(IConfigurationElement element) throws IOException {
        IConfigurationElement[] entryPoints;
        String contributor = element.getContributor().getName();
        String defEntryPointId = element.getAttribute(ATT_DEFAULT_ENTRYPOINT_ID);
        String id = element.getAttribute(ATT_ID);
        String body = element.getAttribute(ATT_BODY);
        String title = element.getAttribute(ATT_TITLE);
        String servletName = element.getAttribute(ATT_SERVLET_NAME);
        String favIcon = element.getAttribute(ATT_FAVICON);
        String themeId = element.getAttribute(ATT_THEME_ID);
        IExitConfirmation exitConfirmation = BrandingExtension.findExitConfirmationImpl(element);
        Branding branding = new Branding(contributor);
        branding.setId(id);
        branding.setBody(BrandingExtension.readBody(contributor, body));
        branding.setTitle(title);
        branding.setThemeId(themeId);
        branding.setFavIcon(favIcon);
        branding.setServletName(servletName);
        branding.setExitConfirmation(exitConfirmation);
        branding.setDefaultEntryPointId(defEntryPointId);
        IConfigurationElement[] additionalHeaders = element.getChildren(ELEM_ADITIONAL_HEADERS);
        if (additionalHeaders.length > 0) {
            IConfigurationElement additionalHeader = additionalHeaders[0];
            BrandingExtension.readAdditionalHeader(branding, additionalHeader);
        }
        if ((entryPoints = element.getChildren(ELEM_ENTRYPOINTS)).length > 0) {
            entryPoints = entryPoints[0].getChildren();
            int i = 0;
            while (i < entryPoints.length) {
                String entryPointId = entryPoints[i].getAttribute(ATT_ID);
                branding.addEntryPointId(entryPointId);
                ++i;
            }
        }
        BrandingExtension.registerServletName(servletName);
        BrandingManager.register((AbstractBranding)branding);
    }

    private static IExitConfirmation findExitConfirmationImpl(IConfigurationElement element) {
        IExitConfirmation result = null;
        String className = element.getAttribute(ATT_EXIT_CONFIRMATION_CLASS);
        if (className != null) {
            try {
                String contributorName = element.getContributor().getName();
                Bundle bundle = Platform.getBundle((String)contributorName);
                Class clazz = bundle.loadClass(className);
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.rap.ui.branding.IExitConfirmation");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz2.isAssignableFrom(clazz)) {
                    String text = "The argument ''{0}'' must implement {1}.";
                    Object[] objectArray = new Object[2];
                    objectArray[0] = ATT_EXIT_CONFIRMATION_CLASS;
                    Class<?> clazz3 = class$0;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$0 = Class.forName("org.eclipse.rap.ui.branding.IExitConfirmation");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    objectArray[1] = clazz3.getName();
                    Object[] args = objectArray;
                    String msg = MessageFormat.format(text, args);
                    throw new IllegalArgumentException(msg);
                }
                try {
                    result = (IExitConfirmation)clazz.newInstance();
                }
                catch (Exception exception) {
                    String pattern = "Can not instantiate class {0}.";
                    Object[] args = new Object[]{clazz.getName()};
                    String msg = MessageFormat.format(pattern, args);
                    throw new IllegalArgumentException(msg);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                String pattern = "Class ''{0}'' not found.";
                Object[] args = new Object[]{className};
                String msg = MessageFormat.format(pattern, args);
                throw new IllegalArgumentException(msg);
            }
        }
        return result;
    }

    private static void registerServletName(String servletName) {
        WorkbenchPlugin workbench = WorkbenchPlugin.getDefault();
        HttpServiceTracker httpServiceTracker = workbench.getHttpServiceTracker();
        httpServiceTracker.addServletAlias(servletName);
    }

    private static void registerDefaultServletName() {
        boolean found = false;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(EP_BRANDING);
        IConfigurationElement[] brandings = ep.getConfigurationElements();
        int i = 0;
        while (!found && i < brandings.length) {
            String servletName = brandings[i].getAttribute(ATT_SERVLET_NAME);
            if ("rap".equals(servletName)) {
                found = true;
            }
            ++i;
        }
        if (!found) {
            BrandingExtension.registerServletName("rap");
        }
    }

    private static void readAdditionalHeader(Branding branding, IConfigurationElement elem) {
        IConfigurationElement[] headers = elem.getChildren();
        int i = 0;
        while (i < headers.length) {
            IConfigurationElement header = headers[i];
            HashMap<String, String> attributes = new HashMap<String, String>();
            String tagName = header.getName();
            if (TAG_META.equals(tagName)) {
                attributes.put(ATT_NAME, header.getAttribute(ATT_NAME));
                attributes.put(ATT_CONTENT, header.getAttribute(ATT_CONTENT));
            } else if (TAG_LINK.equals(tagName)) {
                attributes.put(ATT_REL, header.getAttribute(ATT_REL));
            }
            IConfigurationElement[] addAttrs = header.getChildren(ELEM_ATTRIBUTE);
            int k = 0;
            while (k < addAttrs.length) {
                String name = addAttrs[k].getAttribute(ATT_NAME);
                String value = addAttrs[k].getAttribute(ATT_VALUE);
                attributes.put(name, value);
                ++k;
            }
            branding.addHeader(tagName, attributes);
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readBody(String contributor, String path) throws IOException {
        String result = null;
        if (path == null) return result;
        URL url = Platform.getBundle((String)contributor).getResource(path);
        InputStream inputStream = url.openStream();
        if (inputStream == null) return result;
        try {
            StringBuffer buffer = new StringBuffer();
            byte[] bytes = new byte[512];
            int bytesRead = inputStream.read(bytes);
            while (true) {
                block4: {
                    if (bytesRead != -1) break block4;
                    result = buffer.toString();
                    break;
                }
                buffer.append(new String(bytes, 0, bytesRead));
                bytesRead = inputStream.read(bytes);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            inputStream.close();
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        inputStream.close();
        return result;
    }

    private BrandingExtension() {
    }
}

