/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rap.ui.internal.progress.IJobMarker;
import org.eclipse.rap.ui.internal.progress.JobCanceler;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.SessionSingletonBase;
import org.eclipse.rwt.lifecycle.UICallBack;
import org.eclipse.rwt.service.ISessionStore;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.progress.AnimationItem;
import org.eclipse.ui.internal.progress.GroupInfo;
import org.eclipse.ui.internal.progress.IAnimationProcessor;
import org.eclipse.ui.internal.progress.IJobProgressManagerListener;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.ProgressAnimationProcessor;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.progress.WorkbenchJob;

public class AnimationManager
extends SessionSingletonBase {
    boolean animated = false;
    private IJobProgressManagerListener listener;
    IAnimationProcessor animationProcessor;
    WorkbenchJob animationUpdateJob;
    Display display;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static AnimationManager getInstance() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.progress.AnimationManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AnimationManager instance = (AnimationManager)((Object)AnimationManager.getInstance((Class)clazz));
        if (instance.display == null) {
            instance.display = Display.getCurrent();
        }
        return instance;
    }

    static Color getItemBackgroundColor(Control control) {
        return control.getDisplay().getSystemColor(29);
    }

    AnimationManager() {
        final boolean[] done = new boolean[1];
        this.animationProcessor = new ProgressAnimationProcessor(this);
        this.animationUpdateJob = new WorkbenchJob(ProgressMessages.get().AnimationManager_AnimationStart){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (AnimationManager.this.animated) {
                    AnimationManager.this.animationProcessor.animationStarted();
                } else {
                    AnimationManager.this.animationProcessor.animationFinished();
                }
                return Status.OK_STATUS;
            }

            public Object getAdapter(Class adapter) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.rap.ui.internal.progress.IJobMarker");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Object result = adapter == clazz ? new IJobMarker(this, done){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ boolean[] val$done;
                    {
                        this.this$1 = var1_1;
                        this.val$done = blArray;
                    }

                    public boolean canBeRemoved() {
                        return this.val$done[0];
                    }
                } : super.getAdapter(adapter);
                return result;
            }
        };
        this.animationUpdateJob.setSystem(true);
        this.listener = this.getProgressListener();
        ProgressManager.getInstance().addListener(this.listener);
        ISessionStore session = RWT.getSessionStore();
        String watchDogKey = String.valueOf(((Object)((Object)this)).getClass().getName()) + ".watchDog";
        if (session.getAttribute(watchDogKey) == null) {
            session.setAttribute(watchDogKey, (Object)new HttpSessionBindingListener(){

                public void valueBound(HttpSessionBindingEvent event) {
                }

                public void valueUnbound(HttpSessionBindingEvent event) {
                    if (AnimationManager.this.animationUpdateJob != null) {
                        AnimationManager.this.animationUpdateJob.cancel();
                        AnimationManager.this.animationUpdateJob.addJobChangeListener(new JobCanceler());
                        done[0] = true;
                    }
                }
            });
        }
    }

    void addItem(AnimationItem item) {
        this.animationProcessor.addItem(item);
    }

    void removeItem(AnimationItem item) {
        this.animationProcessor.removeItem(item);
    }

    boolean isAnimated() {
        return this.animated;
    }

    void setAnimated(boolean bool) {
        this.animated = bool;
        Runnable scheduler = new Runnable(){

            public void run() {
                AnimationManager.this.animationUpdateJob.schedule(100L);
            }
        };
        UICallBack.runNonUIThreadWithFakeContext((Display)this.display, (Runnable)scheduler);
    }

    void dispose() {
        this.setAnimated(false);
        ProgressManager.getInstance().removeListener(this.listener);
    }

    private IJobProgressManagerListener getProgressListener() {
        return new IJobProgressManagerListener(){
            Set jobs = Collections.synchronizedSet(new HashSet());

            public void addJob(JobInfo info) {
                this.incrementJobCount(info);
            }

            public void refreshJobInfo(JobInfo info) {
                int state = info.getJob().getState();
                if (state == 4) {
                    this.addJob(info);
                } else {
                    this.removeJob(info);
                }
            }

            public void refreshAll() {
                ProgressManager manager = ProgressManager.getInstance();
                this.jobs.clear();
                AnimationManager.this.setAnimated(false);
                JobInfo[] currentInfos = manager.getJobInfos(this.showsDebug());
                int i = 0;
                while (i < currentInfos.length) {
                    this.addJob(currentInfos[i]);
                    ++i;
                }
            }

            public void removeJob(JobInfo info) {
                this.decrementJobCount(info.getJob());
            }

            public boolean showsDebug() {
                return false;
            }

            private void incrementJobCount(JobInfo info) {
                if (this.isNotTracked(info)) {
                    return;
                }
                if (this.jobs.isEmpty()) {
                    AnimationManager.this.setAnimated(true);
                }
                this.jobs.add(info.getJob());
            }

            private void decrementJobCount(Job job) {
                this.jobs.remove(job);
                if (this.jobs.isEmpty()) {
                    AnimationManager.this.setAnimated(false);
                }
            }

            private boolean isNotTracked(JobInfo info) {
                Job job = info.getJob();
                return job.getState() != 4 || AnimationManager.this.animationProcessor.isProcessorJob(job);
            }

            public void addGroup(GroupInfo info) {
            }

            public void removeGroup(GroupInfo group) {
            }

            public void refreshGroup(GroupInfo info) {
            }
        };
    }

    int getPreferredWidth() {
        return this.animationProcessor.getPreferredWidth();
    }
}

