/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import com.ibm.icu.text.MessageFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.window.Window;
import org.eclipse.rap.ui.internal.SessionLocaleProvider;
import org.eclipse.rap.ui.internal.application.ApplicationRegistry;
import org.eclipse.rap.ui.internal.branding.BrandingExtension;
import org.eclipse.rap.ui.internal.progress.JobManagerAdapter;
import org.eclipse.rap.ui.internal.servlet.EntryPointExtension;
import org.eclipse.rap.ui.internal.servlet.HttpServiceTracker;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.SessionSingletonBase;
import org.eclipse.rwt.service.ISessionStore;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.JFaceUtil;
import org.eclipse.ui.internal.ProductInfo;
import org.eclipse.ui.internal.SharedImages;
import org.eclipse.ui.internal.StartupThreading;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkingSetManager;
import org.eclipse.ui.internal.decorators.DecoratorManager;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceManager;
import org.eclipse.ui.internal.intro.IIntroRegistry;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.operations.WorkbenchOperationSupport;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;
import org.eclipse.ui.internal.registry.PreferencePageRegistryReader;
import org.eclipse.ui.internal.registry.ViewRegistry;
import org.eclipse.ui.internal.registry.WorkingSetRegistry;
import org.eclipse.ui.internal.themes.IThemeRegistry;
import org.eclipse.ui.internal.themes.ThemeRegistry;
import org.eclipse.ui.internal.themes.ThemeRegistryReader;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.internal.wizards.ExportWizardRegistry;
import org.eclipse.ui.internal.wizards.ImportWizardRegistry;
import org.eclipse.ui.internal.wizards.NewWizardRegistry;
import org.eclipse.ui.operations.IWorkbenchOperationSupport;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.presentations.AbstractPresentationFactory;
import org.eclipse.ui.views.IViewRegistry;
import org.eclipse.ui.wizards.IWizardRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.util.tracker.ServiceTracker;

public class WorkbenchPlugin
extends AbstractUIPlugin {
    private static final String PERSP_REGISTRY_INITIALIZED;
    private static WorkbenchPlugin inst;
    private DecoratorManager decoratorManager;
    private BundleContext bundleContext;
    private Collection startingBundles = new HashSet();
    private ServiceRegistration localeProviderService;
    public static boolean DEBUG;
    public static String PI_WORKBENCH;
    public static char PREFERENCE_PAGE_CATEGORY_SEPARATOR;
    private ActionSetRegistry actionSetRegistry;
    private SharedImages sharedImages;
    private ProductInfo productInfo = null;
    private WorkbenchOperationSupport operationSupport;
    private BundleListener bundleListener;
    private HttpServiceTracker httpServiceTracker;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;

    static {
        StringBuffer stringBuffer = new StringBuffer();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.registry.PerspectiveRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PERSP_REGISTRY_INITIALIZED = stringBuffer.append(clazz).append("#initialized").toString();
        DEBUG = false;
        PI_WORKBENCH = "org.eclipse.rap.ui";
        PREFERENCE_PAGE_CATEGORY_SEPARATOR = (char)47;
    }

    public WorkbenchPlugin() {
        inst = this;
    }

    void reset() {
        if (this.decoratorManager != null) {
            this.decoratorManager.dispose();
            this.decoratorManager = null;
        }
        ProgressManager.shutdownProgressManager();
        this.actionSetRegistry = null;
        this.sharedImages = null;
        this.productInfo = null;
        if (this.operationSupport != null) {
            this.operationSupport.dispose();
            this.operationSupport = null;
        }
        DEBUG = false;
    }

    public static Object createExtension(final IConfigurationElement element, final String classAttribute) throws CoreException {
        try {
            if (BundleUtility.isActivated(element.getDeclaringExtension().getNamespace())) {
                return element.createExecutableExtension(classAttribute);
            }
            final Object[] ret = new Object[1];
            final CoreException[] exc = new CoreException[1];
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                public void run() {
                    try {
                        ret[0] = element.createExecutableExtension(classAttribute);
                    }
                    catch (CoreException e) {
                        exc[0] = e;
                    }
                }
            });
            if (exc[0] != null) {
                throw exc[0];
            }
            return ret[0];
        }
        catch (CoreException core) {
            throw core;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, PI_WORKBENCH, 4, WorkbenchMessages.get().WorkbenchPlugin_extension, (Throwable)e));
        }
    }

    public static boolean hasExecutableExtension(IConfigurationElement element, String extensionName) {
        if (element.getAttribute(extensionName) != null) {
            return true;
        }
        String elementText = element.getValue();
        if (elementText != null && !elementText.equals("")) {
            return true;
        }
        IConfigurationElement[] children = element.getChildren(extensionName);
        return children.length == 1 && children[0].getAttribute("class") != null;
    }

    public static boolean isBundleLoadedForExecutableExtension(IConfigurationElement element, String extensionName) {
        Bundle bundle = WorkbenchPlugin.getBundleForExecutableExtension(element, extensionName);
        if (bundle == null) {
            return true;
        }
        return bundle.getState() == 32;
    }

    public static Bundle getBundleForExecutableExtension(IConfigurationElement element, String extensionName) {
        String prop = null;
        String contributorName = null;
        if (extensionName != null) {
            prop = element.getAttribute(extensionName);
        } else {
            prop = element.getValue();
            if (prop != null && (prop = prop.trim()).equals("")) {
                prop = null;
            }
        }
        if (prop == null) {
            IConfigurationElement[] exec = element.getChildren(extensionName);
            if (exec.length != 0) {
                contributorName = exec[0].getAttribute("plugin");
            }
        } else {
            int i = prop.indexOf(58);
            String executable = i != -1 ? prop.substring(0, i).trim() : prop;
            i = executable.indexOf(47);
            if (i != -1) {
                contributorName = executable.substring(0, i).trim();
            }
        }
        if (contributorName == null) {
            contributorName = element.getContributor().getName();
        }
        return Platform.getBundle(contributorName);
    }

    protected ImageRegistry createImageRegistry() {
        return WorkbenchImages.getImageRegistry();
    }

    public ActionSetRegistry getActionSetRegistry() {
        if (this.actionSetRegistry == null) {
            this.actionSetRegistry = new ActionSetRegistry();
        }
        return this.actionSetRegistry;
    }

    public static WorkbenchPlugin getDefault() {
        return inst;
    }

    public IEditorRegistry getEditorRegistry() {
        return EditorRegistry.getInstance();
    }

    public IElementFactory getElementFactory(String targetID) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "elementFactories");
        if (extensionPoint == null) {
            WorkbenchPlugin.log("Unable to find element factory. Extension point: elementFactories not found");
            return null;
        }
        IConfigurationElement targetElement = null;
        IConfigurationElement[] configElements = extensionPoint.getConfigurationElements();
        int j = 0;
        while (j < configElements.length) {
            String strID = configElements[j].getAttribute("id");
            if (targetID.equals(strID)) {
                targetElement = configElements[j];
                break;
            }
            ++j;
        }
        if (targetElement == null) {
            WorkbenchPlugin.log("Unable to find element factory: " + targetID);
            return null;
        }
        IElementFactory factory = null;
        try {
            factory = (IElementFactory)WorkbenchPlugin.createExtension(targetElement, "class");
        }
        catch (CoreException e) {
            WorkbenchPlugin.log("Unable to create element factory.", e.getStatus());
            factory = null;
        }
        return factory;
    }

    public AbstractPresentationFactory getPresentationFactory(String targetID) {
        Object o = this.createExtension("presentationFactories", "factory", targetID);
        if (o instanceof AbstractPresentationFactory) {
            return (AbstractPresentationFactory)o;
        }
        WorkbenchPlugin.log("Error creating presentation factory: " + targetID + " -- class is not an AbstractPresentationFactory");
        return null;
    }

    private Object createExtension(String extensionPointId, String elementName, String targetID) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", extensionPointId);
        if (extensionPoint == null) {
            WorkbenchPlugin.log("Unable to find extension. Extension point: " + extensionPointId + " not found");
            return null;
        }
        IConfigurationElement targetElement = null;
        IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
        int j = 0;
        while (j < elements.length) {
            String strID;
            IConfigurationElement element = elements[j];
            if ((elementName == null || elementName.equals(element.getName())) && targetID.equals(strID = element.getAttribute("id"))) {
                targetElement = element;
                break;
            }
            ++j;
        }
        if (targetElement == null) {
            WorkbenchPlugin.log("Unable to find extension: " + targetID + " in extension point: " + extensionPointId);
            return null;
        }
        try {
            return WorkbenchPlugin.createExtension(targetElement, "class");
        }
        catch (CoreException e) {
            WorkbenchPlugin.log("Unable to create extension: " + targetID + " in extension point: " + extensionPointId + ", status: ", e.getStatus());
            return null;
        }
    }

    public IPerspectiveRegistry getPerspectiveRegistry() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.registry.PerspectiveRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        final PerspectiveRegistry result = (PerspectiveRegistry)SessionSingletonBase.getInstance((Class)clazz);
        ISessionStore sessionStore = RWT.getSessionStore();
        Boolean initialized = (Boolean)sessionStore.getAttribute(PERSP_REGISTRY_INITIALIZED);
        if (initialized == null) {
            sessionStore.setAttribute(PERSP_REGISTRY_INITIALIZED, (Object)Boolean.TRUE);
            StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                public void runWithException() throws Throwable {
                    result.load();
                }
            });
        }
        return result;
    }

    public IWorkingSetManager getWorkingSetManager() {
        return WorkingSetManagerStore.getInstance().getWorkingSetManager(this.bundleContext);
    }

    public WorkingSetRegistry getWorkingSetRegistry() {
        return WorkingSetRegistryStore.getInstance().getWorkingSetRegistry();
    }

    public IIntroRegistry getIntroRegistry() {
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("org.eclipse.ui.internal.intro.IntroRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IIntroRegistry)SessionSingletonBase.getInstance((Class)clazz);
    }

    public IWorkbenchOperationSupport getOperationSupport() {
        if (this.operationSupport == null) {
            this.operationSupport = new WorkbenchOperationSupport();
        }
        return this.operationSupport;
    }

    public PreferenceManager getPreferenceManager() {
        return PreferenceManagerStore.getInstance().getPreferenceManager();
    }

    public ISharedImages getSharedImages() {
        if (this.sharedImages == null) {
            this.sharedImages = new SharedImages();
        }
        return this.sharedImages;
    }

    public IThemeRegistry getThemeRegistry() {
        return ThemeRegistryStore.getInstance().getThemeRegistry();
    }

    public IViewRegistry getViewRegistry() {
        return ViewRegistry.getInstance();
    }

    public IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
    }

    public static void log(String message) {
        WorkbenchPlugin.getDefault().getLog().log(StatusUtil.newStatus(4, message, null));
    }

    public static void log(Throwable t) {
        WorkbenchPlugin.getDefault().getLog().log(WorkbenchPlugin.getStatus(t));
    }

    public static IStatus getStatus(Throwable t) {
        String message = StatusUtil.getLocalizedMessage(t);
        return WorkbenchPlugin.newError(message, t);
    }

    public static IStatus newError(String message, Throwable t) {
        String pluginId = "org.eclipse.ui.workbench";
        int errorCode = 0;
        if (t instanceof CoreException) {
            CoreException ce = (CoreException)t;
            pluginId = ce.getStatus().getPlugin();
            errorCode = ce.getStatus().getCode();
        }
        return new Status(4, pluginId, errorCode, message, StatusUtil.getCause(t));
    }

    public static void log(String message, Throwable t) {
        IStatus status = StatusUtil.newStatus(4, message, t);
        WorkbenchPlugin.log(message, status);
    }

    public static void log(Class clazz, String methodName, Throwable t) {
        String msg = MessageFormat.format((String)"Exception in {0}.{1}: {2}", (Object[])new Object[]{clazz.getName(), methodName, t});
        WorkbenchPlugin.log(msg, t);
    }

    public static void log(String message, IStatus status) {
        if (message != null) {
            WorkbenchPlugin.getDefault().getLog().log(StatusUtil.newStatus(4, message, null));
        }
        WorkbenchPlugin.getDefault().getLog().log(status);
    }

    public static void log(IStatus status) {
        WorkbenchPlugin.getDefault().getLog().log(status);
    }

    public DecoratorManager getDecoratorManager() {
        return DecoratorManagerStore.getInstance().getDecoratorManager();
    }

    public HttpServiceTracker getHttpServiceTracker() {
        return this.httpServiceTracker;
    }

    public void start(BundleContext context) throws Exception {
        context.addBundleListener(this.getBundleListener());
        super.start(context);
        this.bundleContext = context;
        Window.setDefaultOrientation((int)this.getDefaultOrientation());
        JFaceUtil.initializeJFace();
        SessionLocaleProvider localeProvider = new SessionLocaleProvider();
        Class<?> clazz = class$7;
        if (clazz == null) {
            try {
                clazz = class$7 = Class.forName("org.eclipse.osgi.service.localization.LocaleProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String localeProviderName = clazz.getName();
        this.localeProviderService = context.registerService(localeProviderName, (Object)localeProvider, new Hashtable());
        JobManagerAdapter.getInstance();
        Class<?> clazz2 = class$8;
        if (clazz2 == null) {
            try {
                clazz2 = class$8 = Class.forName("org.eclipse.equinox.http.registry.HttpContextExtensionService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String serviceName = clazz2.getName();
        ServiceTracker httpContextExtensionServiceTracker = new ServiceTracker(context, serviceName, null){

            public Object addingService(ServiceReference reference) {
                Object result = super.addingService(reference);
                WorkbenchPlugin.this.httpServiceTracker = new HttpServiceTracker(this.context);
                ApplicationRegistry.registerApplicationEntryPoints();
                try {
                    BrandingExtension.read();
                }
                catch (IOException ioe) {
                    WorkbenchPlugin.log("Unable to read branding extension", ioe);
                }
                WorkbenchPlugin.this.httpServiceTracker.open();
                return result;
            }
        };
        httpContextExtensionServiceTracker.open();
    }

    private int getDefaultOrientation() {
        String[] commandLineArgs = Platform.getCommandLineArgs();
        int orientation = this.getCommandLineOrientation(commandLineArgs);
        if (orientation != 0) {
            return orientation;
        }
        orientation = this.getSystemPropertyOrientation();
        if (orientation != 0) {
            return orientation;
        }
        return 0;
    }

    private int getSystemPropertyOrientation() {
        return 0;
    }

    private int getCommandLineOrientation(String[] commandLineArgs) {
        return 0;
    }

    public Bundle[] getBundles() {
        return this.bundleContext == null ? new Bundle[]{} : this.bundleContext.getBundles();
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public String getProductName() {
        return this.getProductInfo().getProductName();
    }

    public ImageDescriptor[] getWindowImages() {
        return this.getProductInfo().getWindowImages();
    }

    private ProductInfo getProductInfo() {
        if (this.productInfo == null) {
            this.productInfo = new ProductInfo(Platform.getProduct());
        }
        return this.productInfo;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.bundleListener != null) {
            context.removeBundleListener(this.bundleListener);
            this.bundleListener = null;
        }
        if (this.httpServiceTracker != null) {
            this.httpServiceTracker.close();
            this.httpServiceTracker = null;
        }
        EntryPointExtension.unbindAll();
        this.localeProviderService.unregister();
        super.stop(context);
    }

    public IWizardRegistry getNewWizardRegistry() {
        return NewWizardRegistry.getInstance();
    }

    public IWizardRegistry getImportWizardRegistry() {
        return ImportWizardRegistry.getInstance();
    }

    public IWizardRegistry getExportWizardRegistry() {
        return ExportWizardRegistry.getInstance();
    }

    public IPath getDataLocation() {
        try {
            return this.getStateLocation();
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    void addBundleListener(BundleListener bundleListener) {
        this.bundleContext.addBundleListener(bundleListener);
    }

    void removeBundleListener(BundleListener bundleListener) {
        this.bundleContext.removeBundleListener(bundleListener);
    }

    int getBundleCount() {
        return this.bundleContext.getBundles().length;
    }

    OutputStream getSplashStream() {
        ServiceReference[] ref;
        try {
            Class<?> clazz = class$9;
            if (clazz == null) {
                try {
                    clazz = class$9 = Class.forName("java.io.OutputStream");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ref = this.bundleContext.getServiceReferences(clazz.getName(), null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return null;
        }
        if (ref == null) {
            return null;
        }
        int i = 0;
        while (i < ref.length) {
            String name = (String)ref[i].getProperty("name");
            if (name != null && name.equals("splashstream")) {
                Object result = this.bundleContext.getService(ref[i]);
                this.bundleContext.ungetService(ref[i]);
                return (OutputStream)result;
            }
            ++i;
        }
        return null;
    }

    private BundleListener getBundleListener() {
        if (this.bundleListener == null) {
            this.bundleListener = new SynchronousBundleListener(){

                public void bundleChanged(BundleEvent event) {
                    WorkbenchPlugin.this.bundleChanged(event);
                }
            };
        }
        return this.bundleListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bundleChanged(BundleEvent event) {
        Collection collection = this.startingBundles;
        synchronized (collection) {
            switch (event.getType()) {
                case 128: {
                    this.startingBundles.add(event.getBundle());
                    break;
                }
                case 2: 
                case 4: {
                    this.startingBundles.remove(event.getBundle());
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarting(Bundle bundle) {
        Collection collection = this.startingBundles;
        synchronized (collection) {
            return this.startingBundles.contains(bundle);
        }
    }

    public static boolean isSplashHandleSpecified() {
        return false;
    }

    private static final class DecoratorManagerStore
    extends SessionSingletonBase {
        private final DecoratorManager decoratorManager = new DecoratorManager();

        private DecoratorManagerStore() {
        }

        public static DecoratorManagerStore getInstance() {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ui.internal.WorkbenchPlugin$DecoratorManagerStore");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            return (DecoratorManagerStore)((Object)DecoratorManagerStore.getInstance((Class)clazz2));
        }

        public DecoratorManager getDecoratorManager() {
            return this.decoratorManager;
        }
    }

    private static final class PreferenceManagerStore
    extends SessionSingletonBase {
        private final WorkbenchPreferenceManager preferenceManager = new WorkbenchPreferenceManager(PREFERENCE_PAGE_CATEGORY_SEPARATOR);

        static PreferenceManagerStore getInstance() {
            Class<?> clazz = class$5;
            if (clazz == null) {
                try {
                    clazz = class$5 = Class.forName("org.eclipse.ui.internal.WorkbenchPlugin$PreferenceManagerStore");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            return (PreferenceManagerStore)((Object)PreferenceManagerStore.getInstance((Class)clazz2));
        }

        public PreferenceManagerStore() {
            PreferencePageRegistryReader registryReader = new PreferencePageRegistryReader(PlatformUI.getWorkbench());
            registryReader.loadFromRegistry(Platform.getExtensionRegistry());
            this.preferenceManager.addPages(registryReader.getTopLevelNodes());
        }

        public PreferenceManager getPreferenceManager() {
            return this.preferenceManager;
        }
    }

    private static final class ThemeRegistryStore
    extends SessionSingletonBase {
        private final ThemeRegistry themeRegistry = new ThemeRegistry();

        static ThemeRegistryStore getInstance() {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.ui.internal.WorkbenchPlugin$ThemeRegistryStore");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            return (ThemeRegistryStore)((Object)ThemeRegistryStore.getInstance((Class)clazz2));
        }

        public ThemeRegistryStore() {
            ThemeRegistryReader reader = new ThemeRegistryReader();
            reader.readThemes(Platform.getExtensionRegistry(), this.themeRegistry);
        }

        public IThemeRegistry getThemeRegistry() {
            return this.themeRegistry;
        }
    }

    private static final class WorkingSetManagerStore
    extends SessionSingletonBase {
        private WorkingSetManager workingSetManager;

        private WorkingSetManagerStore() {
        }

        static WorkingSetManagerStore getInstance() {
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.ui.internal.WorkbenchPlugin$WorkingSetManagerStore");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            return (WorkingSetManagerStore)((Object)WorkingSetManagerStore.getInstance((Class)clazz2));
        }

        public IWorkingSetManager getWorkingSetManager(BundleContext context) {
            if (this.workingSetManager == null) {
                this.workingSetManager = new WorkingSetManager(context);
                this.workingSetManager.restoreState();
            }
            return this.workingSetManager;
        }
    }

    private static final class WorkingSetRegistryStore
    extends SessionSingletonBase {
        private WorkingSetRegistry workingSetRegistry = new WorkingSetRegistry();

        static WorkingSetRegistryStore getInstance() {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.ui.internal.WorkbenchPlugin$WorkingSetRegistryStore");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            return (WorkingSetRegistryStore)((Object)WorkingSetRegistryStore.getInstance((Class)clazz2));
        }

        public WorkingSetRegistryStore() {
            this.workingSetRegistry.load();
        }

        public WorkingSetRegistry getWorkingSetRegistry() {
            return this.workingSetRegistry;
        }
    }
}

