/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.statushandlers;

import com.ibm.icu.text.DateFormat;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ErrorSupportProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.statushandlers.DefaultDetailsArea;
import org.eclipse.ui.internal.statushandlers.StackTraceSupportArea;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.statushandlers.AbstractStatusAreaProvider;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.WorkbenchStatusDialogManager;

public class WorkbenchStatusDialogManager {
    private static final String PREF_SKIP_GOTO_ACTION_PROMPT = "pref_skip_goto_action_prompt";
    private static final int GOTO_ACTION_ID = 1025;
    private Collection errors = Collections.synchronizedSet(new HashSet());
    private HashMap modals = new HashMap();
    private InternalDialog dialog;
    private Composite dialogArea;
    private Composite listArea;
    private Composite singleStatusDisplayArea;
    private Label singleStatusLabel;
    private TableViewer statusListViewer;
    private ITableLabelProvider statusListLabelProvider = new ITableLabelProvider(){
        Map imageTable = new HashMap();

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element != null) {
                Job job;
                StatusAdapter statusAdapter = (StatusAdapter)element;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.runtime.jobs.Job");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((job = (Job)statusAdapter.getAdapter(clazz)) != null) {
                    return this.getIcon(job);
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Job job;
            StatusAdapter statusAdapter = (StatusAdapter)element;
            String text = WorkbenchMessages.get().WorkbenchStatusDialog_ProblemOccurred;
            if (WorkbenchStatusDialogManager.this.getStatusAdapters().size() == 1) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.runtime.jobs.Job");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                text = (job = (Job)statusAdapter.getAdapter(clazz)) != null ? WorkbenchStatusDialogManager.this.getPrimaryMessage(statusAdapter) : WorkbenchStatusDialogManager.this.getSecondaryMessage(statusAdapter);
            } else {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.runtime.jobs.Job");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                text = (job = (Job)statusAdapter.getAdapter(clazz)) != null ? job.getName() : WorkbenchStatusDialogManager.this.getPrimaryMessage(statusAdapter);
            }
            Long timestamp = (Long)statusAdapter.getProperty(IStatusAdapterConstants.TIMESTAMP_PROPERTY);
            if (timestamp != null && WorkbenchStatusDialogManager.this.getStatusAdapters().size() > 1) {
                String date = DateFormat.getDateTimeInstance((int)1, (int)1).format(new Date(timestamp));
                return NLS.bind((String)ProgressMessages.get().JobInfo_Error, (Object[])new Object[]{text, date});
            }
            return text;
        }

        private Image getIcon(Job job) {
            if (job != null) {
                Object property = job.getProperty(IProgressConstants.ICON_PROPERTY);
                Image im = (Image)this.imageTable.get(property);
                if (im != null) {
                    return im;
                }
                Display display = WorkbenchStatusDialogManager.this.getShell().getDisplay();
                if (property instanceof ImageDescriptor) {
                    im = ((ImageDescriptor)property).createImage((Device)display);
                    this.imageTable.put(property, im);
                } else if (property instanceof URL) {
                    im = ImageDescriptor.createFromURL((URL)((URL)property)).createImage((Device)display);
                    this.imageTable.put(property, im);
                } else {
                    im = ProgressManager.getInstance().getIconFor(job);
                }
                return im;
            }
            return null;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    };
    private Button detailsButton;
    private DetailsAreaManager detailsManager = new DetailsAreaManager();
    private DisposeListener disposeListener = new StatusDialogDisposeListener();
    private String title;
    private int displayMask = 65535;
    private StatusAdapter statusAdapter;
    private SupportTray supportTray = new SupportTray();
    private ToolItem launchTrayButton;
    private boolean modalitySwitch = false;
    private Rectangle shellBounds;
    private boolean detailsOpened = false;
    private boolean trayOpened = false;
    private AbstractStatusAreaProvider userSupportProvider;
    private Label titleImageLabel;
    private Label mainMessageLabel;
    private Composite titleArea;
    private Shell parentShell;
    static /* synthetic */ Class class$0;

    private static boolean shouldDisplay(StatusAdapter statusAdapter, int mask) {
        IStatus status = statusAdapter.getStatus();
        IStatus[] children = status.getChildren();
        if (children == null || children.length == 0) {
            return status.matches(mask);
        }
        int i = 0;
        while (i < children.length) {
            if (children[i].matches(mask)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public WorkbenchStatusDialogManager(Shell parentShell, int displayMask, String dialogTitle) {
        this.parentShell = parentShell;
        this.displayMask = displayMask;
        this.title = dialogTitle == null ? JFaceResources.getString((String)"Problem_Occurred") : dialogTitle;
    }

    public WorkbenchStatusDialogManager(Shell parentShell, String dialogTitle) {
        this(parentShell, 7, dialogTitle);
    }

    public void addStatusAdapter(final StatusAdapter statusAdapter, final boolean modal) {
        if (ErrorDialog.AUTOMATED_MODE) {
            return;
        }
        if (!PlatformUI.isWorkbenchRunning()) {
            WorkbenchPlugin.log(statusAdapter.getStatus());
            return;
        }
        if (this.dialog == null || this.dialog.getShell().isDisposed()) {
            this.errors.add(statusAdapter);
            this.modals.put(statusAdapter, new Boolean(modal));
            if (this.shouldPrompt(statusAdapter)) {
                this.executeAsync(new Runnable(){

                    public void run() {
                        if (WorkbenchStatusDialogManager.this.dialog == null) {
                            WorkbenchStatusDialogManager.this.dialog = new InternalDialog(WorkbenchStatusDialogManager.this.getParentShell(), WorkbenchStatusDialogManager.this, WorkbenchStatusDialogManager.this.shouldBeModal());
                            WorkbenchStatusDialogManager.this.setSelectedStatusAdapter(statusAdapter);
                            WorkbenchStatusDialogManager.this.dialog.open();
                            WorkbenchStatusDialogManager.this.dialog.getShell().addDisposeListener(WorkbenchStatusDialogManager.this.disposeListener);
                        }
                        WorkbenchStatusDialogManager.this.refresh();
                        WorkbenchStatusDialogManager.this.refreshDialogSize();
                    }
                });
            }
        } else {
            if (statusAdapter.getProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY) != null) {
                statusAdapter.setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, Boolean.FALSE);
            }
            this.executeAsync(new Runnable(){

                public void run() {
                    WorkbenchStatusDialogManager.this.openStatusDialog(modal, statusAdapter);
                }
            });
        }
    }

    private boolean close() {
        if (this.detailsOpened) {
            this.toggleDetailsArea();
        }
        if (this.trayOpened) {
            this.closeTray();
        }
        this.shellBounds = this.getShell().getBounds();
        this.statusListViewer = null;
        boolean result = this.dialog.close();
        if (!this.modalitySwitch) {
            ProgressManagerUtil.animateDown(this.shellBounds);
        }
        return result;
    }

    private void closeTray() throws IllegalStateException {
        this.dialog.closeTray();
    }

    private Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        composite.setFont(parent.getFont());
        if (this.dialog.isHelpAvailable()) {
            Control reportControl = this.createSupportControl(composite);
            ((GridData)reportControl.getLayoutData()).horizontalIndent = this.dialog.convertHorizontalDLUsToPixels(7);
        }
        Composite buttonSection = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 0;
        layout.marginWidth = this.dialog.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.dialog.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.dialog.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.dialog.convertVerticalDLUsToPixels(4);
        buttonSection.setLayout((Layout)layout);
        GridData data = new GridData(132);
        buttonSection.setLayoutData((Object)data);
        buttonSection.setFont(composite.getFont());
        this.createButtonsForButtonBar(buttonSection);
        ((GridData)buttonSection.getLayoutData()).grabExcessHorizontalSpace = true;
        return composite;
    }

    private void createButtonsForButtonBar(Composite parent) {
        IAction gotoAction = this.getGotoAction();
        String text = null;
        if (gotoAction != null) {
            text = gotoAction.getText();
        }
        Button button = this.dialog.createButton(parent, 1025, text == null ? "" : text, false);
        if (text == null) {
            this.hideButton(button, true);
        }
        this.dialog.createButton(parent, 0, IDialogConstants.get().OK_LABEL, true);
        this.createDetailsButton(parent);
    }

    private void createDetailsButton(Composite parent) {
        if (this.shouldShowDetailsButton()) {
            this.detailsButton = this.dialog.createButton(parent, 13, IDialogConstants.get().SHOW_DETAILS_LABEL, false);
        }
    }

    private Control createDialogArea(Composite parent) {
        this.createTitleArea(parent);
        this.createListArea(parent);
        this.dialogArea = parent;
        return parent;
    }

    private void createListArea(Composite parent) {
        this.listArea = new Composite(parent, 0);
        GridData layoutData = new GridData(4, 4, true, false);
        layoutData.heightHint = 0;
        layoutData.widthHint = 0;
        this.listArea.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout();
        this.listArea.setLayout((Layout)layout);
    }

    private Composite createSingleStatusDisplayArea(Composite parent) {
        Composite singleStatusParent = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        singleStatusParent.setLayout((Layout)gridLayout);
        GridData gd = new GridData(4, 4, true, true);
        singleStatusParent.setLayoutData((Object)gd);
        this.singleStatusLabel = new Label(singleStatusParent, 64);
        GridData labelLayoutData = new GridData(4, 4, true, true);
        labelLayoutData.widthHint = this.dialog.convertWidthInCharsToPixels(50);
        this.singleStatusLabel.setLayoutData((Object)labelLayoutData);
        this.singleStatusLabel.setText(this.statusListLabelProvider.getColumnText((Object)this.statusAdapter, 0));
        this.singleStatusLabel.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                WorkbenchStatusDialogManager.this.showDetailsArea();
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        return singleStatusParent;
    }

    private Control createSupportControl(Composite parent) {
        return this.createSupportImageButton(parent);
    }

    private ToolBar createSupportImageButton(Composite parent) {
        ToolBar toolBar = new ToolBar(parent, 0x880000);
        ++((GridLayout)parent.getLayout()).numColumns;
        toolBar.setLayoutData((Object)new GridData(64));
        Cursor cursor = Graphics.getCursor((int)21);
        toolBar.setCursor(cursor);
        this.launchTrayButton = new ToolItem(toolBar, 0);
        this.launchTrayButton.setImage(WorkbenchImages.getImage("IMG_DTOOL_SHOW_SUPPORT"));
        this.launchTrayButton.setToolTipText(WorkbenchMessages.get().WorkbenchStatusDialog_Support);
        this.launchTrayButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkbenchStatusDialogManager.this.openTray(WorkbenchStatusDialogManager.this.supportTray);
            }
        });
        return toolBar;
    }

    private void createTitleArea(Composite parent) {
        this.titleArea = new Composite(parent, 0);
        this.titleArea.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        layout.marginLeft = 10;
        layout.marginTop = 10;
        layout.marginBottom = 0;
        this.titleArea.setLayout((Layout)layout);
        this.titleImageLabel = new Label(this.titleArea, 0);
        this.titleImageLabel.setImage(this.getErrorImage());
        GridData layoutData = new GridData();
        layoutData.verticalSpan = 2;
        layoutData.verticalAlignment = 128;
        this.titleImageLabel.setLayoutData((Object)layoutData);
        GridData messageData = new GridData(4, 4, true, true);
        messageData.widthHint = this.dialog.convertWidthInCharsToPixels(50);
        this.mainMessageLabel = new Label(this.titleArea, 64);
        this.mainMessageLabel.setLayoutData((Object)messageData);
        this.mainMessageLabel.setText(this.getMainMessage(this.statusAdapter));
        if (this.errors.size() == 1) {
            this.singleStatusDisplayArea = this.createSingleStatusDisplayArea(this.titleArea);
        }
    }

    public void enableDefaultSupportArea(boolean enable) {
        this.supportTray.enableDefaultSupportArea(enable);
    }

    private void executeAsync(Runnable runnable) {
        Display.getDefault().asyncExec(runnable);
    }

    private void executeSync(Runnable runnable) {
        Display.getDefault().syncExec(runnable);
    }

    private void fillListArea(Composite parent) {
        GridData titleAreaGD = (GridData)this.titleArea.getLayoutData();
        titleAreaGD.grabExcessVerticalSpace = false;
        GridData listAreaGD = (GridData)parent.getLayoutData();
        listAreaGD.grabExcessHorizontalSpace = true;
        listAreaGD.grabExcessVerticalSpace = true;
        listAreaGD.heightHint = -1;
        this.statusListViewer = new TableViewer(parent, 2820);
        this.statusListViewer.setComparator(this.getViewerComparator());
        Control control = this.statusListViewer.getControl();
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = this.dialog.convertHeightInCharsToPixels(5);
        this.statusListViewer.addSelectionChangedListener((ISelectionChangedListener)this.supportTray);
        control.setLayoutData((Object)data);
        this.initContentProvider();
        this.initLabelProvider();
        this.statusListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WorkbenchStatusDialogManager.this.handleSelectionChange();
            }
        });
        Dialog.applyDialogFont((Control)parent);
    }

    private Image getErrorImage() {
        return this.getSWTImage(1);
    }

    private IAction getGotoAction() {
        Job job;
        Object property = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.runtime.jobs.Job");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((job = (Job)this.statusAdapter.getAdapter(clazz)) != null) {
            property = job.getProperty(IProgressConstants.ACTION_PROPERTY);
        }
        if (property instanceof IAction) {
            return (IAction)property;
        }
        return null;
    }

    private Image getImage() {
        IStatus status;
        if (this.statusAdapter != null && (status = this.statusAdapter.getStatus()) != null) {
            if (status.getSeverity() == 2) {
                return this.getWarningImage();
            }
            if (status.getSeverity() == 1) {
                return this.getInfoImage();
            }
        }
        return this.getErrorImage();
    }

    private Image getInfoImage() {
        return this.getSWTImage(2);
    }

    private String getMainMessage(StatusAdapter statusAdapter) {
        if (this.errors.size() == 1) {
            Job job;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.runtime.jobs.Job");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((job = (Job)statusAdapter.getAdapter(clazz)) != null) {
                return NLS.bind((String)WorkbenchMessages.get().WorkbenchStatusDialog_ProblemOccurredInJob, (Object)job.getName());
            }
            return this.getPrimaryMessage(statusAdapter);
        }
        if (this.errors.size() > 1) {
            Job job;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.runtime.jobs.Job");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((job = (Job)statusAdapter.getAdapter(clazz)) != null) {
                return this.getPrimaryMessage(statusAdapter);
            }
            return this.getSecondaryMessage(statusAdapter);
        }
        return WorkbenchMessages.get().WorkbenchStatusDialog_ProblemOccurred;
    }

    private Shell getParentShell() {
        if (this.parentShell == null) {
            this.parentShell = ProgressManagerUtil.getDefaultParent();
        }
        return this.parentShell;
    }

    private String getPrimaryMessage(StatusAdapter statusAdapter) {
        String header;
        Object property = statusAdapter.getProperty(IStatusAdapterConstants.TITLE_PROPERTY);
        if (property instanceof String && (header = (String)property).trim().length() > 0) {
            return header;
        }
        IStatus status = statusAdapter.getStatus();
        if (status.getMessage() != null && status.getMessage().trim().length() > 0) {
            return status.getMessage();
        }
        if (status.getChildren().length > 0) {
            return WorkbenchMessages.get().WorkbenchStatusDialog_StatusWithChildren;
        }
        Throwable t = status.getException();
        if (t != null) {
            if (t.getMessage() != null && t.getMessage().trim().length() > 0) {
                return t.getMessage();
            }
            return t.getClass().getName();
        }
        return WorkbenchMessages.get().WorkbenchStatusDialog_ProblemOccurred;
    }

    private String getSecondaryMessage(StatusAdapter statusAdapter) {
        String primary = this.getPrimaryMessage(statusAdapter);
        IStatus status = statusAdapter.getStatus();
        if (status.getMessage() != null && status.getMessage().trim().length() > 0 && !primary.equals(status.getMessage())) {
            return status.getMessage();
        }
        if (status.getChildren().length > 0 && !primary.equals(status.getMessage())) {
            return WorkbenchMessages.get().WorkbenchStatusDialog_StatusWithChildren;
        }
        Throwable t = status.getException();
        if (t != null) {
            if (t.getMessage() != null && t.getMessage().trim().length() > 0 && !primary.equals(status.getMessage())) {
                return t.getMessage();
            }
            return t.getClass().getName();
        }
        return WorkbenchMessages.get().WorkbenchStatusDialog_SeeDetails;
    }

    private Shell getShell() {
        return this.dialog.getShell();
    }

    private StatusAdapter getSingleSelection() {
        IStructuredSelection selection;
        ISelection rawSelection = this.statusListViewer.getSelection();
        if (rawSelection != null && rawSelection instanceof IStructuredSelection && (selection = (IStructuredSelection)rawSelection).size() == 1) {
            return (StatusAdapter)selection.getFirstElement();
        }
        return null;
    }

    public Collection getStatusAdapters() {
        return Collections.unmodifiableCollection(this.errors);
    }

    private Image getSWTImage(final int imageID) {
        Shell shell = this.getShell();
        if (shell == null) {
            shell = this.getParentShell();
        }
        final Display display = shell == null ? Display.getCurrent() : shell.getDisplay();
        final Image[] image = new Image[1];
        this.executeSync(new Runnable(){

            public void run() {
                image[0] = display.getSystemImage(imageID);
            }
        });
        return image[0];
    }

    private ViewerComparator getViewerComparator() {
        return new ViewerComparator(){

            private int compare(StatusAdapter s1, StatusAdapter s2) {
                Long timestamp1 = (Long)s1.getProperty(IStatusAdapterConstants.TIMESTAMP_PROPERTY);
                Long timestamp2 = (Long)s2.getProperty(IStatusAdapterConstants.TIMESTAMP_PROPERTY);
                if (timestamp1 == null || timestamp2 == null || timestamp1.equals(timestamp2)) {
                    String text1 = WorkbenchStatusDialogManager.this.statusListLabelProvider.getColumnText((Object)s1, 0);
                    String text2 = WorkbenchStatusDialogManager.this.statusListLabelProvider.getColumnText((Object)s2, 0);
                    return text1.compareTo(text2);
                }
                if (timestamp1 < timestamp2) {
                    return -1;
                }
                if (timestamp1 > timestamp2) {
                    return 1;
                }
                return 0;
            }

            public int compare(Viewer testViewer, Object o1, Object o2) {
                if (o1 instanceof StatusAdapter && o2 instanceof StatusAdapter) {
                    return this.compare((StatusAdapter)o1, (StatusAdapter)o2);
                }
                if (o1.hashCode() < o2.hashCode()) {
                    return -1;
                }
                if (o2.hashCode() > o2.hashCode()) {
                    return 1;
                }
                return 0;
            }
        };
    }

    private Image getWarningImage() {
        return this.getSWTImage(8);
    }

    private void handleSelectionChange() {
        StatusAdapter newSelection = this.getSingleSelection();
        if (newSelection != null) {
            this.setSelectedStatusAdapter(newSelection);
            this.refresh();
            this.showDetailsArea();
        }
    }

    private void initContentProvider() {
        IStructuredContentProvider provider = new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return WorkbenchStatusDialogManager.this.getStatusAdapters().toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (newInput != null) {
                    WorkbenchStatusDialogManager.this.refreshStatusListArea();
                }
            }
        };
        this.statusListViewer.setContentProvider((IContentProvider)provider);
        this.statusListViewer.setInput((Object)this);
        this.statusListViewer.setSelection((ISelection)new StructuredSelection((Object)this.statusAdapter));
    }

    private void initializeBounds() {
        this.refreshDialogSize();
        if (!this.modalitySwitch) {
            Rectangle shellPosition = this.getShell().getBounds();
            ProgressManagerUtil.animateUp(shellPosition);
        } else {
            this.getShell().setBounds(this.shellBounds);
        }
    }

    private void initLabelProvider() {
        this.statusListViewer.setLabelProvider((IBaseLabelProvider)this.statusListLabelProvider);
    }

    private boolean isPromptToClose() {
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        if (!store.contains(PREF_SKIP_GOTO_ACTION_PROMPT) || !store.getString(PREF_SKIP_GOTO_ACTION_PROMPT).equals("always")) {
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)this.getShell(), (String)ProgressMessages.get().JobErrorDialog_CloseDialogTitle, (String)ProgressMessages.get().JobErrorDialog_CloseDialogMessage, (String)ProgressMessages.get().JobErrorDialog_DoNotShowAgainMessage, (boolean)false, (IPreferenceStore)store, (String)PREF_SKIP_GOTO_ACTION_PROMPT);
            return dialog.getReturnCode() == 0;
        }
        return true;
    }

    private void openStatusDialog(boolean modal, StatusAdapter statusAdapter) {
        this.errors.add(statusAdapter);
        this.modals.put(statusAdapter, new Boolean(modal));
        boolean shouldBeModal = this.shouldBeModal();
        if (shouldBeModal ^ this.dialog.isModal()) {
            this.dialog.getShell().removeDisposeListener(this.disposeListener);
            this.modalitySwitch = true;
            this.close();
            this.setSelectedStatusAdapter(statusAdapter);
            this.dialog = new InternalDialog(this.getParentShell(), this, modal);
            this.dialog.open();
            this.dialog.getShell().addDisposeListener(this.disposeListener);
            this.modalitySwitch = false;
        }
        this.refresh();
    }

    private void openTray(DialogTray tray) throws IllegalStateException, UnsupportedOperationException {
        this.dialog.openTray(tray);
        this.trayOpened = true;
    }

    private void refresh() {
        if (this.dialog == null) {
            return;
        }
        if (this.dialogArea == null || this.dialogArea.isDisposed()) {
            return;
        }
        this.updateTitleArea();
        this.updateListArea();
        this.updateEnablements();
        this.getShell().layout();
    }

    private void refreshDialogSize() {
        Point newSize = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(newSize);
    }

    private void refreshSingleStatusArea() {
        Image image = this.statusListLabelProvider.getColumnImage((Object)this.statusAdapter, 0);
        this.singleStatusLabel.setImage(image);
        String description = this.statusListLabelProvider.getColumnText((Object)this.statusAdapter, 0);
        if (description.equals(this.singleStatusLabel.getText())) {
            this.singleStatusLabel.setText(" ");
        }
        this.singleStatusLabel.setText(description);
        this.singleStatusDisplayArea.layout();
        this.getShell().setText(this.title);
    }

    private void refreshStatusListArea() {
        if (this.statusListViewer != null && !this.statusListViewer.getControl().isDisposed()) {
            this.statusListViewer.refresh();
            if (this.statusListViewer.getTable().getItemCount() > 1) {
                this.getShell().setText(WorkbenchMessages.get().WorkbenchStatusDialog_MultipleProblemsHaveOccured);
            } else {
                this.getShell().setText(this.title);
            }
        }
    }

    public void setDetailsAreaProvider(AbstractStatusAreaProvider provider) {
        this.detailsManager.setDetailsAreaProvider(provider);
    }

    private void setSelectedStatusAdapter(StatusAdapter statusAdapter) {
        if (this.statusAdapter != statusAdapter) {
            this.statusAdapter = statusAdapter;
        }
    }

    public void setStatusListLabelProvider(ITableLabelProvider labelProvider) {
        if (this.statusListLabelProvider != null) {
            throw new NullPointerException("Label provider cannot be null");
        }
        this.statusListLabelProvider = labelProvider;
    }

    public void setSupportAreaProvider(AbstractStatusAreaProvider provider) {
        this.userSupportProvider = provider;
    }

    private boolean shouldBeModal() {
        Iterator it = this.modals.keySet().iterator();
        while (it.hasNext()) {
            Boolean b;
            Object o = it.next();
            Object value = this.modals.get(o);
            if (!(value instanceof Boolean) || !(b = (Boolean)value).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean shouldPrompt(StatusAdapter statusAdapter) {
        Object noPromptProperty = statusAdapter.getProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY);
        boolean prompt = true;
        if (noPromptProperty instanceof Boolean) {
            prompt = (Boolean)noPromptProperty == false;
        }
        return prompt;
    }

    private boolean shouldShowDetailsButton() {
        return true;
    }

    private void showDetailsArea() {
        if (this.dialogArea != null && !this.dialogArea.isDisposed()) {
            if (this.detailsManager.isOpen()) {
                Point windowSize = this.getShell().getSize();
                this.detailsManager.close();
                this.detailsManager.createDetailsArea(this.dialogArea, this.statusAdapter);
                this.getShell().setSize(windowSize);
                this.dialogArea.layout();
            } else {
                this.toggleDetailsArea();
                this.detailsOpened = true;
            }
        }
    }

    private boolean toggleDetailsArea() {
        boolean opened = false;
        Point windowSize = this.getShell().getSize();
        Point oldSize = this.getShell().computeSize(-1, -1);
        if (this.detailsManager.isOpen()) {
            this.detailsManager.close();
            this.detailsButton.setText(IDialogConstants.get().SHOW_DETAILS_LABEL);
            opened = false;
        } else {
            this.detailsManager.createDetailsArea(this.dialogArea, this.statusAdapter);
            this.detailsButton.setText(IDialogConstants.get().HIDE_DETAILS_LABEL);
            opened = true;
        }
        Point newSize = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(new Point(windowSize.x, windowSize.y + (newSize.y - oldSize.y)));
        return opened;
    }

    private void updateEnablements() {
        Button gotoButton;
        Button details = this.dialog.getButton(13);
        if (details != null) {
            details.setEnabled(true);
        }
        if ((gotoButton = this.dialog.getButton(1025)) != null) {
            boolean hasValidGotoAction;
            IAction gotoAction = this.getGotoAction();
            boolean bl = hasValidGotoAction = gotoAction != null && gotoAction.getText() != null;
            if (hasValidGotoAction) {
                this.hideButton(gotoButton, false);
                gotoButton.setText(gotoAction.getText());
                ((GridData)gotoButton.getLayoutData()).widthHint = gotoButton.computeSize((int)-1, (int)-1).x;
            } else {
                this.hideButton(gotoButton, true);
            }
        }
        if (this.launchTrayButton != null) {
            this.launchTrayButton.setEnabled(this.supportTray.providesSupport());
        }
    }

    private void hideButton(Button button, boolean hide) {
        ((GridData)button.getLayoutData()).exclude = hide;
        button.setVisible(!hide);
        button.setEnabled(!hide);
    }

    private void updateListArea() {
        if (this.errors.size() > 1) {
            if (this.singleStatusDisplayArea != null) {
                this.singleStatusDisplayArea.dispose();
            }
            if (this.statusListViewer == null || this.statusListViewer.getControl().isDisposed()) {
                this.fillListArea(this.listArea);
                this.getShell().setSize(this.getShell().computeSize(-1, -1));
            }
            this.refreshStatusListArea();
        }
    }

    private void updateTitleArea() {
        Image image = this.getImage();
        this.titleImageLabel.setImage(image);
        if (this.statusAdapter != null) {
            this.mainMessageLabel.setText(this.getMainMessage(this.statusAdapter));
        }
        if (this.singleStatusDisplayArea != null) {
            if (this.getStatusAdapters().size() > 1) {
                this.singleStatusDisplayArea.dispose();
            } else {
                this.refreshSingleStatusArea();
            }
        }
        this.titleArea.layout();
    }

    static /* synthetic */ void access$24(WorkbenchStatusDialogManager workbenchStatusDialogManager, boolean bl) {
        workbenchStatusDialogManager.trayOpened = bl;
    }

    static /* synthetic */ void access$25(WorkbenchStatusDialogManager workbenchStatusDialogManager) throws IllegalStateException {
        workbenchStatusDialogManager.closeTray();
    }

    private final class DetailsAreaManager {
        private AbstractStatusAreaProvider provider = null;
        private Control control = null;

        private DetailsAreaManager() {
        }

        public void close() {
            if (this.control != null && !this.control.isDisposed()) {
                this.control.dispose();
            }
        }

        public void createDetailsArea(Composite parent, StatusAdapter statusAdapter) {
            this.control = this.getProvider().createSupportArea(parent, statusAdapter);
        }

        private AbstractStatusAreaProvider getProvider() {
            if (this.provider == null) {
                this.provider = new DefaultDetailsArea(WorkbenchStatusDialogManager.this);
            }
            return this.provider;
        }

        public boolean isOpen() {
            return this.control != null && !this.control.isDisposed();
        }

        public void setDetailsAreaProvider(AbstractStatusAreaProvider provider) {
            this.provider = provider;
        }
    }

    private class InternalDialog
    extends TrayDialog {
        private WorkbenchStatusDialogManager statusDialog;

        public InternalDialog(Shell parentShell, WorkbenchStatusDialogManager statusDialog, boolean modal) {
            super(parentShell);
            this.statusDialog = statusDialog;
            this.setShellStyle(0x490 | this.getShellStyle());
            this.setBlockOnOpen(false);
            if (!modal) {
                this.setShellStyle(0xFFFEFFFF & this.getShellStyle());
            }
        }

        protected void buttonPressed(int id) {
            IAction gotoAction;
            if (id == 1025 && (gotoAction = WorkbenchStatusDialogManager.this.getGotoAction()) != null && WorkbenchStatusDialogManager.this.isPromptToClose()) {
                this.okPressed();
                gotoAction.run();
            }
            if (id == 13) {
                WorkbenchStatusDialogManager.this.detailsOpened = WorkbenchStatusDialogManager.this.toggleDetailsArea();
            } else {
                super.buttonPressed(id);
            }
        }

        protected final void configureShell(Shell shell) {
            super.configureShell(shell);
            if (WorkbenchStatusDialogManager.this.title != null) {
                shell.setText(WorkbenchStatusDialogManager.this.title);
            }
        }

        public int convertHeightInCharsToPixels(int chars) {
            return super.convertHeightInCharsToPixels(chars);
        }

        public int convertHorizontalDLUsToPixels(int dlus) {
            return super.convertHorizontalDLUsToPixels(dlus);
        }

        public int convertVerticalDLUsToPixels(int dlus) {
            return super.convertVerticalDLUsToPixels(dlus);
        }

        public int convertWidthInCharsToPixels(int chars) {
            return super.convertWidthInCharsToPixels(chars);
        }

        public Button createButton(Composite parent, int id, String label, boolean defaultButton) {
            return super.createButton(parent, id, label, defaultButton);
        }

        protected Control createButtonBar(Composite parent) {
            return this.statusDialog.createButtonBar(parent);
        }

        protected Control createDialogArea(Composite parent) {
            return this.statusDialog.createDialogArea(parent);
        }

        public Button getButton(int id) {
            return super.getButton(id);
        }

        protected void initializeBounds() {
            super.initializeBounds();
            this.statusDialog.initializeBounds();
        }

        public boolean isModal() {
            return (this.getShellStyle() & 0x10000) == 65536;
        }

        protected boolean isResizable() {
            return true;
        }

        public int open() {
            if (WorkbenchStatusDialogManager.shouldDisplay(WorkbenchStatusDialogManager.this.statusAdapter, WorkbenchStatusDialogManager.this.displayMask)) {
                int result = super.open();
                if (WorkbenchStatusDialogManager.this.modalitySwitch) {
                    if (WorkbenchStatusDialogManager.this.detailsOpened) {
                        WorkbenchStatusDialogManager.this.showDetailsArea();
                    }
                    if (WorkbenchStatusDialogManager.this.trayOpened) {
                        this.openTray(WorkbenchStatusDialogManager.this.supportTray);
                    }
                }
                return result;
            }
            this.setReturnCode(0);
            return 0;
        }
    }

    private final class StatusDialogDisposeListener
    implements DisposeListener {
        private StatusDialogDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent e) {
            WorkbenchStatusDialogManager.this.dialog = null;
            WorkbenchStatusDialogManager.this.statusListViewer = null;
            WorkbenchStatusDialogManager.this.statusAdapter = null;
            WorkbenchStatusDialogManager.this.errors.clear();
            WorkbenchStatusDialogManager.this.modals.clear();
        }
    }

    private class SupportTray
    extends DialogTray
    implements ISelectionChangedListener {
        private IContributionItem closeAction;
        private Image normal;
        private Image hover;
        private Composite supportArea;
        private Composite supportAreaContent;
        private StatusAdapter lastSelectedStatus;
        private boolean defaultSupportAreaEnabled;

        private SupportTray() {
        }

        private void createActions() {
            this.createImages();
            this.closeAction = new ContributionItem(this){
                final /* synthetic */ SupportTray this$1;
                {
                    this.this$1 = supportTray;
                }

                public void fill(ToolBar parent, int index) {
                    ToolItem item = new ToolItem(parent, 8);
                    item.setImage(SupportTray.access$1(this.this$1));
                    item.setHotImage(SupportTray.access$2(this.this$1));
                    item.setToolTipText(JFaceResources.getString((String)"close"));
                    item.addListener(13, new Listener(this){
                        final /* synthetic */ 2 this$2;
                        {
                            this.this$2 = var1_1;
                        }

                        public void handleEvent(Event event) {
                            WorkbenchStatusDialogManager.access$24(SupportTray.access$4(2.access$0(this.this$2)), false);
                            WorkbenchStatusDialogManager.access$25(SupportTray.access$4(2.access$0(this.this$2)));
                            WorkbenchStatusDialogManager.access$2(SupportTray.access$4(2.access$0(this.this$2))).setFocus();
                        }
                    });
                }

                static /* synthetic */ SupportTray access$0(2 var0) {
                    return var0.this$1;
                }
            };
        }

        protected Control createContents(Composite parent) {
            Composite container = new Composite(parent, 0);
            if (!this.providesSupport()) {
                return container;
            }
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.verticalSpacing = 0;
            container.setLayout((Layout)layout);
            container.addListener(12, new Listener(this){
                final /* synthetic */ SupportTray this$1;
                {
                    this.this$1 = supportTray;
                }

                public void handleEvent(Event event) {
                }
            });
            ToolBarManager toolBarManager = new ToolBarManager(0x800000);
            toolBarManager.createControl(container);
            GridData gd = new GridData(128);
            gd.grabExcessHorizontalSpace = true;
            toolBarManager.getControl().setLayoutData((Object)gd);
            Label separator = new Label(container, 258);
            gd = new GridData(256);
            gd.heightHint = 1;
            separator.setLayoutData((Object)gd);
            this.createActions();
            toolBarManager.add(this.closeAction);
            toolBarManager.update(true);
            this.supportArea = new Composite(container, 0);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.verticalSpacing = 0;
            this.supportArea.setLayout((Layout)layout);
            gd = new GridData(272);
            gd.horizontalSpan = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.grabExcessVerticalSpace = true;
            this.supportArea.setLayoutData((Object)gd);
            if (this.lastSelectedStatus != null) {
                this.createSupportArea(this.supportArea, this.lastSelectedStatus);
            }
            Dialog.applyDialogFont((Control)container);
            return container;
        }

        private void createImages() {
        }

        private void createSupportArea(Composite parent, StatusAdapter statusAdapter) {
            ErrorSupportProvider provider = Policy.getErrorSupportProvider();
            if (WorkbenchStatusDialogManager.this.userSupportProvider != null) {
                provider = WorkbenchStatusDialogManager.this.userSupportProvider;
            }
            if (this.defaultSupportAreaEnabled && provider == null) {
                provider = new StackTraceSupportArea();
            }
            if (provider == null) {
                return;
            }
            if (this.supportAreaContent != null) {
                this.supportAreaContent.dispose();
            }
            this.supportAreaContent = new Composite(parent, 4);
            GridData supportData = new GridData(4, 4, true, true);
            this.supportAreaContent.setLayoutData((Object)supportData);
            if (this.supportAreaContent.getLayout() == null) {
                GridLayout layout = new GridLayout();
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                this.supportAreaContent.setLayout((Layout)layout);
            }
            if (provider instanceof AbstractStatusAreaProvider) {
                ((AbstractStatusAreaProvider)provider).createSupportArea(this.supportAreaContent, statusAdapter);
            } else {
                provider.createSupportArea(this.supportAreaContent, statusAdapter.getStatus());
            }
        }

        public void enableDefaultSupportArea(boolean enable) {
            this.defaultSupportAreaEnabled = enable;
        }

        private StatusAdapter getStatusAdapterFromEvent(SelectionChangedEvent event) {
            StructuredSelection structuredSelection;
            Object element;
            ISelection selection = event.getSelection();
            if (selection instanceof StructuredSelection && (element = (structuredSelection = (StructuredSelection)selection).getFirstElement()) instanceof StatusAdapter) {
                return (StatusAdapter)element;
            }
            return null;
        }

        private boolean providesSupport() {
            if (Policy.getErrorSupportProvider() != null) {
                return true;
            }
            if (WorkbenchStatusDialogManager.this.userSupportProvider != null) {
                return true;
            }
            return this.defaultSupportAreaEnabled;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.lastSelectedStatus = this.getStatusAdapterFromEvent(event);
            if (this.supportArea != null && !this.supportArea.isDisposed() && this.lastSelectedStatus != null) {
                this.createSupportArea(this.supportArea, this.lastSelectedStatus);
                this.supportArea.layout(true);
            }
        }

        static /* synthetic */ Image access$1(SupportTray supportTray) {
            return supportTray.normal;
        }

        static /* synthetic */ Image access$2(SupportTray supportTray) {
            return supportTray.hover;
        }

        static /* synthetic */ WorkbenchStatusDialogManager access$4(SupportTray supportTray) {
            return supportTray.WorkbenchStatusDialogManager.this;
        }
    }
}

