/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.supplemental.fileupload;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.rap.rwt.supplemental.fileupload.FileUploadReceiver;
import org.eclipse.rap.rwt.supplemental.fileupload.IFileUploadDetails;

public class DiskFileUploadReceiver
extends FileUploadReceiver {
    private static final String DEFAULT_TARGET_FILE_NAME = "upload.tmp";
    private File targetFile;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void receive(InputStream dataStream, IFileUploadDetails details) throws IOException {
        File targetFile = this.createTargetFile(details);
        FileOutputStream outputStream = new FileOutputStream(targetFile);
        try {
            DiskFileUploadReceiver.copy(dataStream, outputStream);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            outputStream.close();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        outputStream.close();
        this.targetFile = targetFile;
    }

    public File getTargetFile() {
        return this.targetFile;
    }

    protected File createTargetFile(IFileUploadDetails details) throws IOException {
        String fileName = DEFAULT_TARGET_FILE_NAME;
        if (details != null && details.getFileName() != null) {
            fileName = details.getFileName();
        }
        return File.createTempFile(this.createPrefix(fileName), this.createSuffix(fileName));
    }

    private String createPrefix(String fileName) {
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? fileName : fileName.substring(0, dotIndex + 1);
    }

    private String createSuffix(String fileName) {
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? null : fileName.substring(dotIndex);
    }

    private static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] buffer = new byte[8192];
        boolean finished = false;
        while (!finished) {
            int bytesRead = inputStream.read(buffer);
            if (bytesRead != -1) {
                outputStream.write(buffer, 0, bytesRead);
                continue;
            }
            finished = true;
        }
    }
}

