/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.supplemental.fileupload.internal;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.eclipse.rap.rwt.supplemental.fileupload.FileUploadDetails;
import org.eclipse.rap.rwt.supplemental.fileupload.FileUploadHandler;
import org.eclipse.rap.rwt.supplemental.fileupload.FileUploadReceiver;
import org.eclipse.rap.rwt.supplemental.fileupload.internal.FileUploadTracker;

final class FileUploadProcessor {
    private final FileUploadHandler handler;
    private final FileUploadTracker tracker;
    static /* synthetic */ Class class$0;

    FileUploadProcessor(FileUploadHandler handler) {
        this.handler = handler;
        this.tracker = new FileUploadTracker(handler);
    }

    void handleFileUpload(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            DiskFileItem fileItem = this.readUploadedFileItem(request);
            if (fileItem != null) {
                String fileName = FileUploadProcessor.stripFileName(fileItem.getName());
                String contentType = fileItem.getContentType();
                long contentLength = fileItem.getSize();
                this.tracker.setFileName(fileName);
                this.tracker.setContentType(contentType);
                FileUploadReceiver receiver = this.handler.getReceiver();
                FileUploadDetails details = new FileUploadDetails(fileName, contentType, contentLength);
                receiver.receive(fileItem.getInputStream(), details);
                this.tracker.handleFinished();
            } else {
                String errorMessage = "No file upload data found in request";
                this.tracker.setException(new Exception(errorMessage));
                this.tracker.handleFailed();
                response.sendError(400, errorMessage);
            }
        }
        catch (Exception exception) {
            Class<?> clazz = exception.getClass();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.apache.commons.fileupload.FileUploadBase$FileSizeLimitExceededException");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz != clazz2) {
                this.tracker.setException(exception);
                this.tracker.handleFailed();
            }
            response.sendError(500, exception.getMessage());
        }
    }

    private DiskFileItem readUploadedFileItem(HttpServletRequest request) throws FileUploadException {
        DiskFileItem fileItem;
        ServletFileUpload upload = this.createUpload();
        DiskFileItem result = null;
        List uploadedItems = upload.parseRequest(request);
        if (uploadedItems.size() > 0 && !(fileItem = (DiskFileItem)uploadedItems.get(0)).isFormField()) {
            result = fileItem;
        }
        return result;
    }

    private ServletFileUpload createUpload() {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload result = new ServletFileUpload((FileItemFactory)factory);
        long maxFileSize = this.getMaxFileSize();
        result.setFileSizeMax(maxFileSize);
        result.setSizeMax(maxFileSize == -1L ? -1L : maxFileSize + 1000L);
        ProgressListener listener = this.createProgressListener(maxFileSize);
        result.setProgressListener(listener);
        return result;
    }

    private ProgressListener createProgressListener(final long maxFileSize) {
        ProgressListener result = new ProgressListener(){

            public void update(long bytesRead, long contentLength, int item) {
                if (maxFileSize != -1L && contentLength > maxFileSize) {
                    FileUploadProcessor.this.tracker.setException(new Exception("File exceeds maximum allowed size."));
                    FileUploadProcessor.this.tracker.handleFailed();
                } else {
                    FileUploadProcessor.this.tracker.setContentLength(contentLength);
                    FileUploadProcessor.this.tracker.setBytesRead(bytesRead);
                    FileUploadProcessor.this.tracker.handleProgress();
                }
            }
        };
        return result;
    }

    private long getMaxFileSize() {
        return this.handler.getMaxFileSize();
    }

    private static String stripFileName(String name) {
        String result = name;
        int lastSlash = result.lastIndexOf(47);
        if (lastSlash != -1) {
            result = result.substring(lastSlash + 1);
        } else {
            int lastBackslash = result.lastIndexOf(92);
            if (lastBackslash != -1) {
                result = result.substring(lastBackslash + 1);
            }
        }
        return result;
    }
}

