/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rap.rwt.supplemental.fileupload.FileUploadHandler;
import org.eclipse.swt.internal.widgets.ValidationHandler;
import org.eclipse.swt.widgets.ProgressBar;

public class ProgressCollector {
    private Map metrics;
    private ProgressBar totalProgressBar;
    private final ValidationHandler validationHandler;

    public ProgressCollector(ValidationHandler validationHandler) {
        this.validationHandler = validationHandler;
        this.reset();
    }

    public synchronized void updateProgress(FileUploadHandler handler, int progressPercent) {
        this.metrics.put(handler, new Integer(progressPercent));
        this.updateTotalProgress();
    }

    public void updateTotalProgress() {
        if (this.validationHandler != null) {
            double maxProgress = this.validationHandler.getNumUploads() * 100;
            int totalProgress = this.calculateTotalProgress();
            if (this.totalProgressBar != null && !this.totalProgressBar.isDisposed()) {
                int percent = (int)Math.floor((double)totalProgress / maxProgress * 100.0);
                this.totalProgressBar.setSelection(percent);
                this.totalProgressBar.setToolTipText("Total upload progress: " + percent + "%");
            }
            if (maxProgress == (double)totalProgress) {
                this.validationHandler.updateEnablement();
            }
        }
    }

    private int calculateTotalProgress() {
        Object[] progressTallies = this.metrics.values().toArray();
        int totalProgress = 0;
        int i = 0;
        while (i < this.metrics.size()) {
            totalProgress += ((Integer)progressTallies[i]).intValue();
            ++i;
        }
        return totalProgress;
    }

    public boolean isFinished() {
        int maxProgress;
        int totalProgress = this.calculateTotalProgress();
        return totalProgress == (maxProgress = this.validationHandler.getNumUploads() * 100);
    }

    public void reset() {
        this.metrics = new HashMap();
        if (this.totalProgressBar != null && !this.totalProgressBar.isDisposed()) {
            this.totalProgressBar.setMinimum(0);
        }
    }

    public void setProgressBar(ProgressBar progressBar) {
        this.totalProgressBar = progressBar;
    }
}

