/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.rwt.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TemplateParser {
    private final String template;
    private final Map variables;

    public TemplateParser(String template) {
        TemplateParser.checkNotNull(template, "template");
        this.template = template;
        this.variables = new HashMap();
    }

    public void registerVariable(String variableName, String variableValue) {
        TemplateParser.checkNotNull(variableName, "variableName");
        TemplateParser.checkNotNull(variableValue, "variableValue");
        this.variables.put(variableName, variableValue);
    }

    public String parse() {
        StringBuffer result = new StringBuffer(this.template);
        Iterator iter = this.variables.keySet().iterator();
        while (iter.hasNext()) {
            String variableName = (String)iter.next();
            String variableValue = this.getVariableValue(variableName);
            String variableToken = TemplateParser.variableToken(variableName);
            TemplateParser.replaceAll(result, variableToken, variableValue);
        }
        return result.toString();
    }

    private static void replaceAll(StringBuffer buffer, String occurence, String replacement) {
        int index = buffer.indexOf(occurence, 0);
        while (index != -1) {
            buffer.replace(index, index + occurence.length(), replacement);
            index = buffer.indexOf(occurence, index + replacement.length());
        }
    }

    private String getVariableValue(String variableName) {
        String result = "";
        if (this.variables.containsKey(variableName)) {
            result = (String)this.variables.get(variableName);
        }
        return result;
    }

    private static String variableToken(String variableName) {
        return "${" + variableName + "}";
    }

    private static void checkNotNull(String argument, String argumentName) {
        if (argument == null) {
            throw new NullPointerException(argumentName);
        }
    }
}

