/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.container;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.container.ModuleRevision;
import org.osgi.framework.wiring.BundleCapability;

public final class ModuleCapability
implements BundleCapability {
    private final String namespace;
    private final Map<String, String> directives;
    private final Map<String, Object> attributes;
    private final Map<String, Object> transientAttrs;
    private final ModuleRevision revision;

    ModuleCapability(String namespace, Map<String, String> directives, Map<String, Object> attributes, ModuleRevision revision) {
        this.namespace = namespace;
        this.directives = directives;
        this.attributes = attributes;
        this.transientAttrs = "osgi.native".equals(namespace) ? new HashMap(0) : null;
        this.revision = revision;
    }

    @Override
    public ModuleRevision getRevision() {
        return this.revision;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public Map<String, String> getDirectives() {
        return this.directives;
    }

    @Override
    public Map<String, Object> getAttributes() {
        if (this.transientAttrs == null) {
            return this.attributes;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(this.transientAttrs);
        result.putAll(this.attributes);
        return Collections.unmodifiableMap(result);
    }

    Map<String, Object> getPersistentAttributes() {
        return this.attributes;
    }

    public void setTransientAttrs(Map<String, ?> transientAttrs) {
        if (this.transientAttrs == null) {
            throw new UnsupportedOperationException(String.valueOf(this.namespace) + ": namespace does not support transient attributes.");
        }
        this.transientAttrs.clear();
        this.transientAttrs.putAll(transientAttrs);
    }

    @Override
    public ModuleRevision getResource() {
        return this.revision;
    }

    public String toString() {
        return String.valueOf(this.namespace) + ModuleRevision.toString(this.attributes, false) + ModuleRevision.toString(this.directives, true);
    }
}

