/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.protocol.ClientMessage;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServiceStore;
import org.eclipse.rap.rwt.internal.util.SharedInstanceBuffer;
import org.eclipse.rap.rwt.remote.OperationHandler;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.FontUtil;
import org.eclipse.swt.internal.graphics.ImageFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProtocolUtil {
    private static final Pattern FONT_NAME_FILTER_PATTERN = Pattern.compile("\"|\\\\");
    private static final String CLIENT_MESSAGE = String.valueOf(ProtocolUtil.class.getName()) + "#clientMessage";
    private static final SharedInstanceBuffer<String, String[]> parsedFonts = new SharedInstanceBuffer();

    private ProtocolUtil() {
    }

    public static ClientMessage getClientMessage() {
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        ClientMessage clientMessage = (ClientMessage)serviceStore.getAttribute(CLIENT_MESSAGE);
        if (clientMessage == null) {
            HttpServletRequest request = ContextProvider.getRequest();
            try {
                JsonObject json = JsonObject.readFrom(ProtocolUtil.getReader(request));
                clientMessage = new ClientMessage(json);
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Unable to read the json message", ioe);
            }
            serviceStore.setAttribute(CLIENT_MESSAGE, clientMessage);
        }
        return clientMessage;
    }

    private static Reader getReader(HttpServletRequest request) throws IOException {
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return new InputStreamReader((InputStream)request.getInputStream(), encoding);
    }

    public static void setClientMessage(ClientMessage clientMessage) {
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        serviceStore.setAttribute(CLIENT_MESSAGE, clientMessage);
    }

    public static boolean isClientMessageProcessed() {
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        return serviceStore.getAttribute(CLIENT_MESSAGE) != null;
    }

    public static void handleOperation(OperationHandler handler, ClientMessage.Operation operation) {
        if (operation instanceof ClientMessage.SetOperation) {
            ClientMessage.SetOperation setOperation = (ClientMessage.SetOperation)operation;
            handler.handleSet(setOperation.getProperties());
        } else if (operation instanceof ClientMessage.CallOperation) {
            ClientMessage.CallOperation callOperation = (ClientMessage.CallOperation)operation;
            handler.handleCall(callOperation.getMethodName(), callOperation.getProperties());
        } else if (operation instanceof ClientMessage.NotifyOperation) {
            ClientMessage.NotifyOperation notifyOperation = (ClientMessage.NotifyOperation)operation;
            handler.handleNotify(notifyOperation.getEventName(), notifyOperation.getProperties());
        }
    }

    public static JsonValue readPropertyValue(String target, String property) {
        JsonValue result = null;
        ClientMessage message = ProtocolUtil.getClientMessage();
        ClientMessage.SetOperation operation = message.getLastSetOperationFor(target, property);
        if (operation != null) {
            result = operation.getProperty(property);
        }
        return result;
    }

    public static String readPropertyValueAsString(String target, String property) {
        return ProtocolUtil.readPropertyValueAs(target, property, String.class);
    }

    public static Point readPropertyValueAsPoint(String target, String property) {
        return ProtocolUtil.readPropertyValueAs(target, property, Point.class);
    }

    public static Rectangle readPropertyValueAsRectangle(String target, String property) {
        return ProtocolUtil.readPropertyValueAs(target, property, Rectangle.class);
    }

    public static int[] readPropertyValueAsIntArray(String target, String property) {
        return ProtocolUtil.readPropertyValueAs(target, property, int[].class);
    }

    public static boolean[] readPropertyValueAsBooleanArray(String target, String property) {
        return ProtocolUtil.readPropertyValueAs(target, property, boolean[].class);
    }

    public static String[] readPropertyValueAsStringArray(String target, String property) {
        return ProtocolUtil.readPropertyValueAs(target, property, String[].class);
    }

    private static <T> T readPropertyValueAs(String target, String property, Class<T> clazz) {
        Object value;
        String[] result = null;
        ClientMessage message = ProtocolUtil.getClientMessage();
        ClientMessage.SetOperation operation = message.getLastSetOperationFor(target, property);
        if (operation != null && (value = JsonUtil.jsonToJava(operation.getProperty(property))) != null) {
            if (String.class.equals(clazz)) {
                result = value.toString();
            } else if (Point.class.equals(clazz)) {
                result = ProtocolUtil.toPoint(value);
            } else if (Rectangle.class.equals(clazz)) {
                result = ProtocolUtil.toRectangle(value);
            } else if (int[].class.equals(clazz)) {
                result = (String[])ProtocolUtil.toIntArray(value);
            } else if (boolean[].class.equals(clazz)) {
                result = (String[])ProtocolUtil.toBooleanArray(value);
            } else if (String[].class.equals(clazz)) {
                result = ProtocolUtil.toStringArray(value);
            } else {
                throw new IllegalStateException("Could not convert property to " + clazz.getName());
            }
        }
        return (T)result;
    }

    public static String readEventPropertyValueAsString(String target, String eventName, String property) {
        Object value;
        String result = null;
        ClientMessage message = ProtocolUtil.getClientMessage();
        ClientMessage.NotifyOperation operation = message.getLastNotifyOperationFor(target, eventName);
        if (operation != null && (value = JsonUtil.jsonToJava(operation.getProperty(property))) != null) {
            result = value.toString();
        }
        return result;
    }

    public static boolean wasEventSent(String target, String eventName) {
        ClientMessage message = ProtocolUtil.getClientMessage();
        ClientMessage.NotifyOperation operation = message.getLastNotifyOperationFor(target, eventName);
        return operation != null;
    }

    public static String readCallPropertyValueAsString(String target, String methodName, String property) {
        ClientMessage.CallOperation operation;
        Object value;
        String result = null;
        ClientMessage message = ProtocolUtil.getClientMessage();
        List<ClientMessage.CallOperation> operations = message.getAllCallOperationsFor(target, methodName);
        if (!operations.isEmpty() && (value = JsonUtil.jsonToJava((operation = operations.get(operations.size() - 1)).getProperty(property))) != null) {
            result = value.toString();
        }
        return result;
    }

    public static boolean wasCallReceived(String target, String methodName) {
        ClientMessage message = ProtocolUtil.getClientMessage();
        List<ClientMessage.CallOperation> operations = message.getAllCallOperationsFor(target, methodName);
        return !operations.isEmpty();
    }

    public static JsonValue getJsonForFont(Font font) {
        FontData fontData = font == null ? null : FontUtil.getData(font);
        return ProtocolUtil.getJsonForFont(fontData);
    }

    public static JsonValue getJsonForFont(FontData fontData) {
        if (fontData != null) {
            return new JsonArray().add(JsonUtil.createJsonArray(ProtocolUtil.parseFontName(fontData.getName()))).add(fontData.getHeight()).add((fontData.getStyle() & 1) != 0).add((fontData.getStyle() & 2) != 0);
        }
        return JsonValue.NULL;
    }

    public static String[] parseFontName(final String name) {
        return parsedFonts.get(name, new SharedInstanceBuffer.IInstanceCreator<String[]>(){

            @Override
            public String[] createInstance() {
                return ProtocolUtil.parseFontNameInternal(name);
            }
        });
    }

    private static String[] parseFontNameInternal(String name) {
        String[] result = name.split(",");
        int i = 0;
        while (i < result.length) {
            result[i] = result[i].trim();
            Matcher matcher = FONT_NAME_FILTER_PATTERN.matcher(result[i]);
            result[i] = matcher.replaceAll("");
            ++i;
        }
        return result;
    }

    public static JsonValue getJsonForImage(Image image) {
        JsonValue result = JsonValue.NULL;
        if (image != null) {
            String imagePath = ImageFactory.getImagePath(image);
            Rectangle bounds = image.getBounds();
            result = new JsonArray().add(imagePath).add(bounds.width).add(bounds.height);
        }
        return result;
    }

    public static JsonValue getJsonForColor(Color color, boolean transparent) {
        RGB rgb = color == null ? null : color.getRGB();
        return ProtocolUtil.getJsonForColor(rgb, transparent);
    }

    public static JsonValue getJsonForColor(RGB rgb, boolean transparent) {
        if (rgb != null) {
            int transparency = transparent ? 0 : 255;
            return new JsonArray().add(rgb.red).add(rgb.green).add(rgb.blue).add(transparency);
        }
        if (transparent) {
            return new JsonArray().add(0).add(0).add(0).add(0);
        }
        return JsonValue.NULL;
    }

    public static JsonValue getJsonForPoint(Point point) {
        return point == null ? JsonValue.NULL : new JsonArray().add(point.x).add(point.y);
    }

    public static JsonValue getJsonForRectangle(Rectangle rect) {
        if (rect == null) {
            return JsonValue.NULL;
        }
        return new JsonArray().add(rect.x).add(rect.y).add(rect.width).add(rect.height);
    }

    public static Point toPoint(JsonValue value) {
        try {
            JsonArray array = value.asArray();
            if (array.size() != 2) {
                throw new IllegalArgumentException("Expected array of size 2");
            }
            return new Point(array.get(0).asInt(), array.get(1).asInt());
        }
        catch (Exception exception) {
            String message = "Could not convert property to Point: " + value;
            throw new IllegalArgumentException(message, exception);
        }
    }

    public static Rectangle toRectangle(JsonValue value) {
        try {
            JsonArray array = value.asArray();
            if (array.size() != 4) {
                throw new IllegalArgumentException("Expected array of size 4");
            }
            return new Rectangle(array.get(0).asInt(), array.get(1).asInt(), array.get(2).asInt(), array.get(3).asInt());
        }
        catch (Exception exception) {
            String message = "Could not convert property to Rectangle: " + value;
            throw new IllegalArgumentException(message, exception);
        }
    }

    public static Rectangle toRectangle(Object value) {
        int[] array = ProtocolUtil.toIntArray(value);
        ProtocolUtil.checkArrayLength(array, 4);
        return new Rectangle(array[0], array[1], array[2], array[3]);
    }

    public static Point toPoint(Object value) {
        int[] array = ProtocolUtil.toIntArray(value);
        ProtocolUtil.checkArrayLength(array, 2);
        return new Point(array[0], array[1]);
    }

    private static int[] toIntArray(Object value) {
        int[] result;
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            result = new int[array.length];
            int i = 0;
            while (i < array.length) {
                try {
                    result[i] = (Integer)array[i];
                }
                catch (ClassCastException classCastException) {
                    String message = "Could not convert to int array: array contains non-int value";
                    throw new IllegalStateException(message);
                }
                ++i;
            }
        } else {
            throw new IllegalStateException("Could not convert to int array: property is not an array");
        }
        return result;
    }

    private static String[] toStringArray(Object value) {
        String[] result;
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            result = new String[array.length];
            int i = 0;
            while (i < array.length) {
                try {
                    result[i] = (String)array[i];
                }
                catch (ClassCastException classCastException) {
                    String message = "Could not convert to string array: array contains non-string value";
                    throw new IllegalStateException(message);
                }
                ++i;
            }
        } else {
            String message = "Could not convert to string array: property is not a string";
            throw new IllegalStateException(message);
        }
        return result;
    }

    private static boolean[] toBooleanArray(Object value) {
        boolean[] result;
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            result = new boolean[array.length];
            int i = 0;
            while (i < array.length) {
                try {
                    result[i] = (Boolean)array[i];
                }
                catch (ClassCastException classCastException) {
                    String message = "Could not convert to boolean array: array contains non-boolean value";
                    throw new IllegalStateException(message);
                }
                ++i;
            }
        } else {
            String message = "Could not convert to boolean array: property is not an array";
            throw new IllegalStateException(message);
        }
        return result;
    }

    private static void checkArrayLength(int[] array, int length) {
        if (array.length != length) {
            String message = "Could not convert property to point: invalid array length";
            throw new IllegalStateException(message);
        }
    }
}

