/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.widgets.fileuploadkit;

import java.io.IOException;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.internal.widgets.IFileUploadAdapter;
import org.eclipse.rap.rwt.internal.widgets.fileuploadkit.FileUploadOperationHandler;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.rap.rwt.widgets.FileUpload;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.widgets.Widget;

public final class FileUploadLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.FileUpload";
    private static final String[] ALLOWED_STYLES = new String[]{"BORDER", "MULTI"};
    private static final String PROP_TEXT = "text";
    private static final String PROP_IMAGE = "image";
    private static final String PROP_SELECTION_LISTENERS = "Selection";

    public void preserveValues(Widget widget) {
        FileUpload fileUpload = (FileUpload)widget;
        ControlLCAUtil.preserveValues(fileUpload);
        WidgetLCAUtil.preserveCustomVariant(fileUpload);
        WidgetLCAUtil.preserveProperty((Widget)fileUpload, PROP_TEXT, fileUpload.getText());
        WidgetLCAUtil.preserveProperty((Widget)fileUpload, PROP_IMAGE, fileUpload.getImage());
        WidgetLCAUtil.preserveListener(fileUpload, PROP_SELECTION_LISTENERS, EventLCAUtil.isListening(fileUpload, 13));
    }

    public void renderInitialization(Widget widget) throws IOException {
        FileUpload fileUpload = (FileUpload)widget;
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(fileUpload, TYPE);
        remoteObject.setHandler(new FileUploadOperationHandler(fileUpload));
        remoteObject.set("parent", WidgetUtil.getId(fileUpload.getParent()));
        remoteObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(fileUpload, ALLOWED_STYLES)));
    }

    public void renderChanges(Widget widget) throws IOException {
        FileUpload fileUpload = (FileUpload)widget;
        ControlLCAUtil.renderChanges(fileUpload);
        WidgetLCAUtil.renderCustomVariant(fileUpload);
        WidgetLCAUtil.renderProperty((Widget)fileUpload, PROP_TEXT, fileUpload.getText(), "");
        WidgetLCAUtil.renderProperty((Widget)fileUpload, PROP_IMAGE, fileUpload.getImage(), null);
        WidgetLCAUtil.renderListener(fileUpload, PROP_SELECTION_LISTENERS, EventLCAUtil.isListening(fileUpload, 13), false);
        FileUploadLCA.renderSubmit(fileUpload);
    }

    private static void renderSubmit(FileUpload fileUpload) {
        String url = fileUpload.getAdapter(IFileUploadAdapter.class).getAndResetUrl();
        if (url != null) {
            RemoteObjectFactory.getRemoteObject(fileUpload).call("submit", new JsonObject().add("url", url));
        }
    }
}

