/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.browser.browserkit;

import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.protocol.ControlOperationHandler;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServiceStore;
import org.eclipse.rap.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.internal.browser.browserkit.BrowserLCA;
import org.eclipse.swt.internal.widgets.IBrowserAdapter;
import org.eclipse.swt.widgets.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserOperationHandler
extends ControlOperationHandler<Browser> {
    private static final String METHOD_EXECUTE_FUNCTION = "executeFunction";
    private static final String PARAM_NAME = "name";
    private static final String PARAM_ARGUMENTS = "arguments";
    private static final String METHOD_EVALUATION_SUCCEEDED = "evaluationSucceeded";
    private static final String METHOD_EVALUATION_FAILED = "evaluationFailed";
    private static final String PARAM_RESULT = "result";
    private static final String EVENT_PROGRESS = "Progress";

    public BrowserOperationHandler(Browser browser) {
        super(browser);
    }

    @Override
    public void handleCall(Browser browser, String method, JsonObject properties) {
        if (METHOD_EXECUTE_FUNCTION.equals(method)) {
            this.handleCallExecuteFunction(browser, properties);
        } else if (METHOD_EVALUATION_SUCCEEDED.equals(method)) {
            this.handleCallEvaluationSucceeded(browser, properties);
        } else if (METHOD_EVALUATION_FAILED.equals(method)) {
            this.handleCallEvaluationFailed(browser, properties);
        }
    }

    @Override
    public void handleNotify(Browser browser, String eventName, JsonObject properties) {
        if (EVENT_PROGRESS.equals(eventName)) {
            this.handleNotifyProgress(browser, properties);
        } else {
            super.handleNotify(browser, eventName, properties);
        }
    }

    public void handleCallExecuteFunction(final Browser browser, JsonObject properties) {
        String name = properties.get(PARAM_NAME).asString();
        final Object[] arguments = BrowserOperationHandler.jsonToJava(properties.get(PARAM_ARGUMENTS).asArray());
        BrowserFunction[] functions = this.getAdapter(browser).getBrowserFunctions();
        boolean found = false;
        int i = 0;
        while (i < functions.length && !found) {
            final BrowserFunction current = functions[i];
            if (current.getName().equals(name)) {
                ProcessActionRunner.add(new Runnable(){

                    public void run() {
                        try {
                            Object executedFunctionResult = current.function(arguments);
                            BrowserOperationHandler.setExecutedFunctionResult(browser, executedFunctionResult);
                        }
                        catch (Exception exception) {
                            BrowserOperationHandler.setExecutedFunctionError(browser, exception.getMessage());
                        }
                        BrowserOperationHandler.setExecutedFunctionName(browser, current.getName());
                    }
                });
                found = true;
            }
            ++i;
        }
    }

    public void handleCallEvaluationSucceeded(Browser browser, JsonObject properties) {
        JsonValue value = properties.get(PARAM_RESULT);
        Object result = null;
        if (value != null && !value.isNull()) {
            result = BrowserOperationHandler.jsonToJava(value.asArray())[0];
        }
        this.getAdapter(browser).setExecuteResult(true, result);
    }

    public void handleCallEvaluationFailed(Browser browser, JsonObject properties) {
        this.getAdapter(browser).setExecuteResult(false, null);
    }

    public void handleNotifyProgress(Browser browser, JsonObject properties) {
        browser.notifyListeners(5021, new Event());
        browser.notifyListeners(5022, new Event());
    }

    private static void setExecutedFunctionResult(Browser browser, Object result) {
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        serviceStore.setAttribute(String.valueOf(BrowserLCA.EXECUTED_FUNCTION_RESULT) + WidgetUtil.getId(browser), result);
    }

    private static void setExecutedFunctionError(Browser browser, String error) {
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        serviceStore.setAttribute(String.valueOf(BrowserLCA.EXECUTED_FUNCTION_ERROR) + WidgetUtil.getId(browser), error);
    }

    private static void setExecutedFunctionName(Browser browser, String name) {
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        serviceStore.setAttribute(String.valueOf(BrowserLCA.EXECUTED_FUNCTION_NAME) + WidgetUtil.getId(browser), name);
    }

    static Object jsonToJava(JsonValue value) {
        Object[] result;
        if (value.isNull()) {
            result = null;
        } else if (value.isBoolean()) {
            result = value.asBoolean();
        } else if (value.isNumber()) {
            result = value.asDouble();
        } else if (value.isString()) {
            result = value.asString();
        } else if (value.isArray()) {
            result = BrowserOperationHandler.jsonToJava(value.asArray());
        } else {
            throw new RuntimeException("Unable to convert JsonValue to Java: " + value);
        }
        return result;
    }

    private static Object[] jsonToJava(JsonArray value) {
        Object[] result = new Object[value.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = BrowserOperationHandler.jsonToJava(value.get(i));
            ++i;
        }
        return result;
    }

    private IBrowserAdapter getAdapter(Browser browser) {
        return browser.getAdapter(IBrowserAdapter.class);
    }
}

