/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.dnd.dragsourcekit;

import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.rwt.internal.protocol.WidgetOperationHandler;
import org.eclipse.rap.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.dnd.DNDEvent;
import org.eclipse.swt.internal.dnd.DNDUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DragSourceOperationHandler
extends WidgetOperationHandler<DragSource> {
    private static final String EVENT_DRAG_START = "DragStart";
    private static final String EVENT_DRAG_END = "DragEnd";

    public DragSourceOperationHandler(DragSource dragSource) {
        super(dragSource);
    }

    @Override
    public void handleNotify(DragSource dragSource, String eventName, JsonObject properties) {
        if (EVENT_DRAG_START.equals(eventName)) {
            this.handleNotifyDragStart(dragSource, properties);
        } else if (EVENT_DRAG_END.equals(eventName)) {
            this.handleNotifyDragEnd(dragSource, properties);
        } else {
            super.handleNotify(dragSource, eventName, properties);
        }
    }

    public void handleNotifyDragStart(final DragSource dragSource, final JsonObject properties) {
        ProcessActionRunner.add(new Runnable(){

            public void run() {
                int x = properties.get("x").asInt();
                int y = properties.get("y").asInt();
                int time = properties.get("time").asInt();
                Control control = dragSource.getControl();
                Point mappedPoint = control.getDisplay().map(null, control, x, y);
                control.notifyListeners(29, DragSourceOperationHandler.createDragDetectEvent(mappedPoint, time));
                DNDEvent event = DragSourceOperationHandler.createDragSourceEvent(mappedPoint, time, 0);
                dragSource.notifyListeners(2008, event);
                if (!event.doit) {
                    DNDUtil.cancel();
                }
            }
        });
    }

    public void handleNotifyDragEnd(final DragSource dragSource, final JsonObject properties) {
        ProcessActionRunner.add(new Runnable(){

            public void run() {
                int x = properties.get("x").asInt();
                int y = properties.get("y").asInt();
                int time = properties.get("time").asInt();
                Control control = dragSource.getControl();
                Point mappedPoint = control.getDisplay().map(null, control, x, y);
                int detail = DNDUtil.hasDetailChanged() ? DNDUtil.getDetailChangedValue() : 0;
                DNDEvent event = DragSourceOperationHandler.createDragSourceEvent(mappedPoint, time, detail);
                dragSource.notifyListeners(2000, event);
                DNDUtil.cancelDetailChanged();
                DNDUtil.cancelFeedbackChanged();
                DNDUtil.cancelDataTypeChanged();
            }
        });
    }

    private static Event createDragDetectEvent(Point point, int time) {
        Event event = new Event();
        event.x = point.x;
        event.y = point.y;
        event.time = time;
        event.button = 1;
        return event;
    }

    private static DNDEvent createDragSourceEvent(Point point, int time, int detail) {
        DNDEvent event = new DNDEvent();
        event.x = point.x;
        event.y = point.y;
        event.time = time;
        event.detail = detail;
        event.doit = true;
        return event;
    }
}

