/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.dnd.droptargetkit;

import java.io.IOException;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.internal.dnd.DNDUtil;
import org.eclipse.swt.internal.dnd.droptargetkit.DropTargetOperationHandler;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.widgets.Widget;

public final class DropTargetLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.DropTarget";
    private static final String PROP_TRANSFER = "transfer";
    private static final String PROP_DRAG_ENTER_LISTENER = "DragEnter";
    private static final String PROP_DRAG_OVER_LISTENER = "DragOver";
    private static final String PROP_DRAG_LEAVE_LISTENER = "DragLeave";
    private static final String PROP_DRAG_OPERATION_CHANGED_LISTENER = "DragOperationChanged";
    private static final String PROP_DROP_ACCEPT_LISTENER = "DropAccept";
    private static final Transfer[] DEFAULT_TRANSFER = new Transfer[0];

    public void preserveValues(Widget widget) {
        DropTarget dropTarget = (DropTarget)widget;
        WidgetLCAUtil.preserveProperty((Widget)dropTarget, PROP_TRANSFER, dropTarget.getTransfer());
        WidgetLCAUtil.preserveListener(dropTarget, PROP_DRAG_ENTER_LISTENER, EventLCAUtil.isListening(dropTarget, 2002));
        WidgetLCAUtil.preserveListener(dropTarget, PROP_DRAG_OVER_LISTENER, EventLCAUtil.isListening(dropTarget, 2004));
        WidgetLCAUtil.preserveListener(dropTarget, PROP_DRAG_LEAVE_LISTENER, EventLCAUtil.isListening(dropTarget, 2003));
        WidgetLCAUtil.preserveListener(dropTarget, PROP_DRAG_OPERATION_CHANGED_LISTENER, EventLCAUtil.isListening(dropTarget, 2005));
        WidgetLCAUtil.preserveListener(dropTarget, PROP_DROP_ACCEPT_LISTENER, EventLCAUtil.isListening(dropTarget, 2007));
    }

    public void readData(Widget widget) {
    }

    public void renderInitialization(Widget widget) throws IOException {
        DropTarget dropTarget = (DropTarget)widget;
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(dropTarget, TYPE);
        remoteObject.setHandler(new DropTargetOperationHandler(dropTarget));
        remoteObject.set("control", WidgetUtil.getId(dropTarget.getControl()));
        remoteObject.set("style", DNDUtil.convertOperations(dropTarget.getStyle()));
    }

    public void renderChanges(Widget widget) throws IOException {
        DropTarget dropTarget = (DropTarget)widget;
        DropTargetLCA.renderTransfer(dropTarget);
        DropTargetLCA.renderDetail(dropTarget);
        DropTargetLCA.renderFeedback(dropTarget);
        DropTargetLCA.renderDataType(dropTarget);
        WidgetLCAUtil.renderListener(dropTarget, PROP_DRAG_ENTER_LISTENER, EventLCAUtil.isListening(dropTarget, 2002), false);
        WidgetLCAUtil.renderListener(dropTarget, PROP_DRAG_OVER_LISTENER, EventLCAUtil.isListening(dropTarget, 2004), false);
        WidgetLCAUtil.renderListener(dropTarget, PROP_DRAG_LEAVE_LISTENER, EventLCAUtil.isListening(dropTarget, 2003), false);
        WidgetLCAUtil.renderListener(dropTarget, PROP_DRAG_OPERATION_CHANGED_LISTENER, EventLCAUtil.isListening(dropTarget, 2005), false);
        WidgetLCAUtil.renderListener(dropTarget, PROP_DROP_ACCEPT_LISTENER, EventLCAUtil.isListening(dropTarget, 2007), false);
    }

    private static void renderTransfer(DropTarget dropTarget) {
        Transfer[] newValue = dropTarget.getTransfer();
        if (WidgetLCAUtil.hasChanged(dropTarget, PROP_TRANSFER, newValue, DEFAULT_TRANSFER)) {
            JsonArray renderValue = DNDUtil.convertTransferTypes(newValue);
            RemoteObjectFactory.getRemoteObject(dropTarget).set(PROP_TRANSFER, renderValue);
        }
    }

    private static void renderDetail(DropTarget dropTarget) {
        if (DNDUtil.hasDetailChanged() && dropTarget.getControl() == DNDUtil.getDetailChangedControl()) {
            JsonArray operations = DNDUtil.convertOperations(DNDUtil.getDetailChangedValue());
            JsonValue detail = JsonValue.valueOf("DROP_NONE");
            if (!operations.isEmpty()) {
                detail = operations.get(0);
            }
            JsonObject parameters = new JsonObject().add("detail", detail);
            RemoteObjectFactory.getRemoteObject(dropTarget).call("changeDetail", parameters);
        }
    }

    private static void renderFeedback(DropTarget dropTarget) {
        if (DNDUtil.hasFeedbackChanged() && dropTarget.getControl() == DNDUtil.getFeedbackChangedControl()) {
            JsonObject parameters = new JsonObject().add("flags", DNDUtil.getFeedbackChangedValue()).add("feedback", DropTargetLCA.convertFeedback(DNDUtil.getFeedbackChangedValue()));
            RemoteObjectFactory.getRemoteObject(dropTarget).call("changeFeedback", parameters);
        }
    }

    private static void renderDataType(DropTarget dropTarget) {
        if (DNDUtil.hasDataTypeChanged() && dropTarget.getControl() == DNDUtil.getDataTypeChangedControl()) {
            JsonObject parameters = new JsonObject().add("dataType", DNDUtil.getDataTypeChangedValue().type);
            RemoteObjectFactory.getRemoteObject(dropTarget).call("changeDataType", parameters);
        }
    }

    private static JsonArray convertFeedback(int feedback) {
        JsonArray feedbackNames = new JsonArray();
        if ((feedback & 0x10) != 0) {
            feedbackNames.add("FEEDBACK_EXPAND");
        }
        if ((feedback & 4) != 0) {
            feedbackNames.add("FEEDBACK_INSERT_AFTER");
        }
        if ((feedback & 2) != 0) {
            feedbackNames.add("FEEDBACK_INSERT_BEFORE");
        }
        if ((feedback & 8) != 0) {
            feedbackNames.add("FEEDBACK_SCROLL");
        }
        if ((feedback & 1) != 0) {
            feedbackNames.add("FEEDBACK_SELECT");
        }
        return feedbackNames;
    }
}

