/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.canvaskit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.internal.graphics.GCOperation;
import org.eclipse.swt.internal.graphics.IGCAdapter;
import org.eclipse.swt.internal.widgets.canvaskit.CanvasOperationHandler;
import org.eclipse.swt.internal.widgets.canvaskit.GCOperationWriter;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public final class CanvasLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.Canvas";
    private static final String TYPE_GC = "rwt.widgets.GC";
    private static final String[] ALLOWED_STYLES = new String[]{"NO_RADIO_GROUP", "BORDER"};
    private static final String PROP_CLIENT_AREA = "clientArea";

    public void preserveValues(Widget widget) {
        ControlLCAUtil.preserveValues((Control)widget);
        WidgetLCAUtil.preserveCustomVariant(widget);
        WidgetLCAUtil.preserveBackgroundGradient(widget);
        WidgetLCAUtil.preserveRoundedBorder(widget);
        Canvas canvas = (Canvas)widget;
        WidgetLCAUtil.preserveProperty((Widget)canvas, PROP_CLIENT_AREA, canvas.getClientArea());
    }

    public void renderInitialization(Widget widget) throws IOException {
        Canvas canvas = (Canvas)widget;
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(canvas, TYPE);
        remoteObject.setHandler(new CanvasOperationHandler(canvas));
        remoteObject.set("parent", WidgetUtil.getId(canvas.getParent()));
        remoteObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(canvas, ALLOWED_STYLES)));
        RemoteObject remoteObjectForGC = RemoteObjectFactory.createRemoteObject(GCOperationWriter.getGcId(canvas), TYPE_GC);
        remoteObjectForGC.set("parent", WidgetUtil.getId(canvas));
    }

    public void renderChanges(Widget widget) throws IOException {
        ControlLCAUtil.renderChanges((Control)widget);
        WidgetLCAUtil.renderBackgroundGradient(widget);
        WidgetLCAUtil.renderRoundedBorder(widget);
        WidgetLCAUtil.renderCustomVariant(widget);
        this.renderClientArea((Canvas)widget);
        CanvasLCA.writeGCOperations((Canvas)widget);
        WidgetLCAUtil.renderClientListeners(widget);
    }

    private static void writeGCOperations(Canvas canvas) {
        IGCAdapter adapter = canvas.getAdapter(IGCAdapter.class);
        GCOperation[] operations = adapter.getTrimmedGCOperations();
        if (operations.length > 0 || adapter.getForceRedraw()) {
            GCOperationWriter operationWriter = new GCOperationWriter(canvas);
            operationWriter.initialize();
            int i = 0;
            while (i < operations.length) {
                operationWriter.write(operations[i]);
                ++i;
            }
            operationWriter.render();
        }
        adapter.clearGCOperations();
        adapter.setForceRedraw(false);
    }

    public void renderClientArea(Canvas canvas) {
        WidgetLCAUtil.renderProperty((Widget)canvas, PROP_CLIENT_AREA, canvas.getClientArea(), null);
    }
}

