/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.displaykit;

import org.eclipse.rap.rwt.internal.protocol.ClientMessage;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.remote.RemoteObjectImpl;
import org.eclipse.rap.rwt.internal.remote.RemoteObjectRegistry;
import org.eclipse.rap.rwt.remote.OperationHandler;
import org.eclipse.swt.internal.dnd.dragsourcekit.DragSourceOperationHandler;
import org.eclipse.swt.internal.dnd.droptargetkit.DropTargetOperationHandler;

public final class DNDSupport {
    private DNDSupport() {
    }

    public static void handleOperations() {
        ClientMessage clientMessage = ProtocolUtil.getClientMessage();
        for (ClientMessage.Operation operation : clientMessage.getAllOperations()) {
            OperationHandler handler = DNDSupport.getOperationHandler(operation.getTarget());
            if (!DNDSupport.isDNDOperationHandler(handler)) continue;
            ProtocolUtil.handleOperation(handler, operation);
        }
    }

    private static OperationHandler getOperationHandler(String id) {
        RemoteObjectImpl remoteObject = RemoteObjectRegistry.getInstance().get(id);
        if (remoteObject != null) {
            return remoteObject.getHandler();
        }
        return null;
    }

    private static boolean isDNDOperationHandler(OperationHandler handler) {
        return handler instanceof DragSourceOperationHandler || handler instanceof DropTargetOperationHandler;
    }
}

