/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.labelkit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.internal.util.MnemonicUtil;
import org.eclipse.rap.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.internal.widgets.MarkupUtil;
import org.eclipse.swt.internal.widgets.labelkit.AbstractLabelLCADelegate;
import org.eclipse.swt.internal.widgets.labelkit.LabelOperationHandler;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;

final class StandardLabelLCA
extends AbstractLabelLCADelegate {
    private static final String TYPE = "rwt.widgets.Label";
    private static final String[] ALLOWED_STYLES = new String[]{"WRAP", "BORDER"};
    private static final String PROP_TEXT = "text";
    private static final String PROP_MNEMONIC_INDEX = "mnemonicIndex";
    private static final String PROP_ALIGNMENT = "alignment";
    private static final String PROP_IMAGE = "image";
    private static final String PROP_MARKUP_ENABLED = "markupEnabled";
    private static final String DEFAULT_ALIGNMENT = "left";

    StandardLabelLCA() {
    }

    void preserveValues(Label label) {
        ControlLCAUtil.preserveValues(label);
        WidgetLCAUtil.preserveCustomVariant(label);
        WidgetLCAUtil.preserveProperty((Widget)label, PROP_TEXT, label.getText());
        WidgetLCAUtil.preserveProperty((Widget)label, PROP_IMAGE, label.getImage());
        WidgetLCAUtil.preserveProperty((Widget)label, PROP_ALIGNMENT, StandardLabelLCA.getAlignment(label));
    }

    void renderInitialization(Label label) throws IOException {
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(label, TYPE);
        remoteObject.setHandler(new LabelOperationHandler(label));
        remoteObject.set("parent", WidgetUtil.getId(label.getParent()));
        remoteObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(label, ALLOWED_STYLES)));
        WidgetLCAUtil.renderProperty((Widget)label, PROP_MARKUP_ENABLED, MarkupUtil.isMarkupEnabledFor(label), false);
    }

    void renderChanges(Label label) throws IOException {
        ControlLCAUtil.renderChanges(label);
        WidgetLCAUtil.renderCustomVariant(label);
        StandardLabelLCA.renderText(label);
        WidgetLCAUtil.renderClientListeners(label);
        StandardLabelLCA.renderMnemonicIndex(label);
        WidgetLCAUtil.renderProperty((Widget)label, PROP_IMAGE, label.getImage(), null);
        WidgetLCAUtil.renderProperty((Widget)label, PROP_ALIGNMENT, StandardLabelLCA.getAlignment(label), DEFAULT_ALIGNMENT);
    }

    private static String getAlignment(Label label) {
        int alignment = label.getAlignment();
        String result = (alignment & 0x4000) != 0 ? DEFAULT_ALIGNMENT : ((alignment & 0x1000000) != 0 ? "center" : ((alignment & 0x20000) != 0 ? "right" : DEFAULT_ALIGNMENT));
        return result;
    }

    private static void renderText(Label label) {
        String newValue = label.getText();
        if (WidgetLCAUtil.hasChanged(label, PROP_TEXT, newValue, "")) {
            String text = newValue;
            if (!MarkupUtil.isMarkupEnabledFor(label)) {
                text = MnemonicUtil.removeAmpersandControlCharacters(newValue);
            }
            RemoteObjectFactory.getRemoteObject(label).set(PROP_TEXT, text);
        }
    }

    private static void renderMnemonicIndex(Label label) {
        int mnemonicIndex;
        String text;
        if (!MarkupUtil.isMarkupEnabledFor(label) && WidgetLCAUtil.hasChanged(label, PROP_TEXT, text = label.getText(), "") && (mnemonicIndex = MnemonicUtil.findMnemonicCharacterIndex(text)) != -1) {
            RemoteObjectFactory.getRemoteObject(label).set(PROP_MNEMONIC_INDEX, mnemonicIndex);
        }
    }
}

