/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.menukit;

import java.io.IOException;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.IMenuAdapter;
import org.eclipse.swt.internal.widgets.IShellAdapter;
import org.eclipse.swt.internal.widgets.menukit.MenuOperationHandler;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public final class MenuLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.Menu";
    private static final String[] ALLOWED_STYLES = new String[]{"BAR", "DROP_DOWN", "POP_UP", "NO_RADIO_GROUP"};
    private static final String PROP_ENABLED = "enabled";
    private static final String PROP_SHOW_LISTENER = "Show";
    private static final String PROP_HIDE_LISTENER = "Hide";
    private static final String METHOD_UNHIDE_ITEMS = "unhideItems";
    private static final String METHOD_SHOW_MENU = "showMenu";
    private static final Rectangle DEFAULT_BOUNDS = new Rectangle(0, 0, 0, 0);

    public void preserveValues(Widget widget) {
        Menu menu = (Menu)widget;
        WidgetLCAUtil.preserveProperty((Widget)menu, PROP_ENABLED, menu.getEnabled());
        WidgetLCAUtil.preserveListener(menu, PROP_SHOW_LISTENER, MenuLCA.hasShowListener(menu));
        WidgetLCAUtil.preserveListener(menu, PROP_HIDE_LISTENER, MenuLCA.hasHideListener(menu));
        WidgetLCAUtil.preserveCustomVariant(menu);
        WidgetLCAUtil.preserveHelpListener(menu);
    }

    public void renderInitialization(Widget widget) throws IOException {
        Menu menu = (Menu)widget;
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(menu, TYPE);
        remoteObject.setHandler(new MenuOperationHandler(menu));
        remoteObject.set("parent", WidgetUtil.getId(menu.getParent()));
        remoteObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(menu, ALLOWED_STYLES)));
    }

    public void renderChanges(Widget widget) throws IOException {
        Menu menu = (Menu)widget;
        WidgetLCAUtil.renderProperty((Widget)menu, PROP_ENABLED, menu.getEnabled(), true);
        WidgetLCAUtil.renderListener(menu, PROP_SHOW_LISTENER, MenuLCA.hasShowListener(menu), false);
        WidgetLCAUtil.renderListener(menu, PROP_HIDE_LISTENER, MenuLCA.hasHideListener(menu), false);
        WidgetLCAUtil.renderCustomVariant(menu);
        WidgetLCAUtil.renderListenHelp(menu);
        MenuLCA.renderBounds(menu);
        MenuLCA.renderShow(menu);
        MenuLCA.renderUnhideItems(menu);
    }

    public void renderDispose(Widget widget) throws IOException {
        RemoteObjectFactory.getRemoteObject(widget).destroy();
    }

    private static void renderBounds(Menu menu) {
        if (MenuLCA.isMenuBar(menu)) {
            WidgetLCAUtil.renderProperty((Widget)menu, "bounds", MenuLCA.getBounds(menu), DEFAULT_BOUNDS);
        }
    }

    private static void renderShow(Menu menu) {
        if (MenuLCA.isPopupMenu(menu) && menu.isVisible()) {
            IMenuAdapter adapter = menu.getAdapter(IMenuAdapter.class);
            Point location = adapter.getLocation();
            JsonObject parameters = new JsonObject().add("x", location.x).add("y", location.y);
            RemoteObjectFactory.getRemoteObject(menu).call(METHOD_SHOW_MENU, parameters);
            menu.setVisible(false);
        }
    }

    private static void renderUnhideItems(Menu menu) {
        if ((MenuLCA.isPopupMenu(menu) || MenuLCA.isDropDownMenu(menu)) && WidgetLCAUtil.wasEventSent(menu, PROP_SHOW_LISTENER)) {
            boolean reveal = menu.getItemCount() > 0;
            JsonObject parameters = new JsonObject().add("reveal", reveal);
            RemoteObjectFactory.getRemoteObject(menu).call(METHOD_UNHIDE_ITEMS, parameters);
        }
    }

    private static boolean hasShowListener(Menu menu) {
        boolean result = false;
        if (!MenuLCA.isMenuBar(menu) && !(result = EventLCAUtil.isListening(menu, 22))) {
            MenuItem[] items = menu.getItems();
            int i = 0;
            while (!result && i < items.length && !result) {
                result = EventLCAUtil.isListening(items[i], 30);
                ++i;
            }
        }
        return result;
    }

    private static boolean hasHideListener(Menu menu) {
        return MenuLCA.isMenuBar(menu) ? false : EventLCAUtil.isListening(menu, 23);
    }

    private static Rectangle getBounds(Menu menu) {
        Rectangle result = new Rectangle(0, 0, 0, 0);
        Decorations parent = MenuLCA.getBoundingShell(menu);
        if (parent != null) {
            result = parent.getAdapter(IShellAdapter.class).getMenuBounds();
        }
        return result;
    }

    private static Decorations getBoundingShell(Menu menu) {
        Decorations result = null;
        if (menu.getParent().getMenuBar() == menu) {
            result = menu.getParent();
        }
        return result;
    }

    private static boolean isMenuBar(Menu menu) {
        return (menu.getStyle() & 2) != 0;
    }

    private static boolean isPopupMenu(Menu menu) {
        return (menu.getStyle() & 8) != 0;
    }

    private static boolean isDropDownMenu(Menu menu) {
        return (menu.getStyle() & 4) != 0;
    }
}

