/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.shellkit;

import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.protocol.ControlOperationHandler;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.events.EventUtil;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.internal.widgets.IShellAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellOperationHandler
extends ControlOperationHandler<Shell> {
    private static final String PROP_MODE = "mode";
    private static final String PROP_BOUNDS = "bounds";
    private static final String PROP_ACTIVE_CONTROL = "activeControl";

    public ShellOperationHandler(Shell shell) {
        super(shell);
    }

    @Override
    public void handleSet(Shell shell, JsonObject properties) {
        super.handleSet(shell, properties);
        this.handleSetMode(shell, properties);
        this.handleSetBounds(shell, properties);
        this.handleSetActiveControl(shell, properties);
    }

    @Override
    public void handleNotify(Shell shell, String eventName, JsonObject properties) {
        if ("Close".equals(eventName)) {
            this.handleNotifyClose(shell, properties);
        } else if ("Resize".equals(eventName)) {
            this.handleNotifyResize(shell, properties);
        } else if ("Move".equals(eventName)) {
            this.handleNotifyMove(shell, properties);
        } else {
            super.handleNotify(shell, eventName, properties);
        }
    }

    public void handleSetMode(Shell shell, JsonObject properties) {
        JsonValue value = properties.get(PROP_MODE);
        if (value != null) {
            String mode = value.asString();
            if ("maximized".equals(mode)) {
                shell.setMaximized(true);
            } else if ("minimized".equals(mode)) {
                shell.setMinimized(true);
            } else {
                shell.setMinimized(false);
                shell.setMaximized(false);
            }
        }
    }

    public void handleSetBounds(Shell shell, JsonObject properties) {
        JsonValue value = properties.get(PROP_BOUNDS);
        if (value != null) {
            JsonArray arrayValue = value.asArray();
            Rectangle bounds = new Rectangle(arrayValue.get(0).asInt(), arrayValue.get(1).asInt(), arrayValue.get(2).asInt(), arrayValue.get(3).asInt());
            ShellOperationHandler.getAdapter(shell).setBounds(bounds);
        }
    }

    public void handleSetActiveControl(Shell shell, JsonObject properties) {
        String activeControlId;
        Widget widget;
        JsonValue value = properties.get(PROP_ACTIVE_CONTROL);
        if (value != null && (widget = WidgetUtil.find(shell, activeControlId = value.asString())) != null) {
            ShellOperationHandler.setActiveControl(shell, widget);
        }
    }

    public void handleNotifyClose(Shell shell, JsonObject properties) {
        shell.close();
    }

    public void handleNotifyResize(Shell shell, JsonObject properties) {
    }

    public void handleNotifyMove(Shell shell, JsonObject properties) {
    }

    @Override
    public void handleNotifyActivate(Shell shell, JsonObject properties) {
        IDisplayAdapter displayAdapter = shell.getDisplay().getAdapter(IDisplayAdapter.class);
        displayAdapter.setActiveShell(shell);
        displayAdapter.invalidateFocus();
    }

    private static void setActiveControl(Shell shell, Widget widget) {
        if (EventUtil.isAccessible(widget)) {
            ShellOperationHandler.getAdapter(shell).setActiveControl((Control)widget);
        }
    }

    private static IShellAdapter getAdapter(Shell shell) {
        return shell.getAdapter(IShellAdapter.class);
    }
}

