/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.tabfolderkit;

import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.protocol.ControlOperationHandler;
import org.eclipse.rap.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabFolderOperationHandler
extends ControlOperationHandler<TabFolder> {
    private static final String PROP_SELECTION = "selection";

    public TabFolderOperationHandler(TabFolder folder) {
        super(folder);
    }

    @Override
    public void handleSet(TabFolder folder, JsonObject properties) {
        super.handleSet(folder, properties);
        this.handleSetSelection(folder, properties);
    }

    @Override
    public void handleNotify(TabFolder folder, String eventName, JsonObject properties) {
        if ("Selection".equals(eventName)) {
            this.handleNotifySelection(folder, properties);
        } else {
            super.handleNotify(folder, eventName, properties);
        }
    }

    public void handleSetSelection(final TabFolder folder, JsonObject properties) {
        JsonValue value = properties.get(PROP_SELECTION);
        if (value != null) {
            final TabItem item = TabFolderOperationHandler.getItem(folder, value.asString());
            ProcessActionRunner.add(new Runnable(){

                public void run() {
                    folder.setSelection(item);
                    WidgetLCAUtil.preserveProperty((Widget)folder, TabFolderOperationHandler.PROP_SELECTION, WidgetUtil.getId(item));
                }
            });
        }
    }

    public void handleNotifySelection(TabFolder folder, JsonObject properties) {
        Event event = TabFolderOperationHandler.createSelectionEvent(13, properties);
        event.item = TabFolderOperationHandler.getItem(folder, properties.get("item").asString());
        folder.notifyListeners(13, event);
    }

    private static TabItem getItem(TabFolder folder, String itemId) {
        return (TabItem)WidgetUtil.find(folder, itemId);
    }
}

