/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.tablecolumnkit;

import java.util.Arrays;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.rwt.internal.protocol.WidgetOperationHandler;
import org.eclipse.rap.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.internal.widgets.ITableAdapter;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableColumnOperationHandler
extends WidgetOperationHandler<TableColumn> {
    private static final String METHOD_MOVE = "move";
    private static final String METHOD_RESIZE = "resize";
    private static final String PROP_LEFT = "left";
    private static final String PROP_WIDTH = "width";

    public TableColumnOperationHandler(TableColumn column) {
        super(column);
    }

    @Override
    public void handleCall(TableColumn column, String method, JsonObject properties) {
        if (METHOD_MOVE.equals(method)) {
            this.handleCallMove(column, properties);
        } else if (METHOD_RESIZE.equals(method)) {
            this.handleCallResize(column, properties);
        }
    }

    @Override
    public void handleNotify(TableColumn column, String eventName, JsonObject properties) {
        if ("Selection".equals(eventName)) {
            this.handleNotifySelection(column, properties);
        } else if ("DefaultSelection".equals(eventName)) {
            this.handleNotifyDefaultSelection(column, properties);
        } else {
            super.handleNotify(column, eventName, properties);
        }
    }

    public void handleCallMove(final TableColumn column, JsonObject properties) {
        final int newLeft = properties.get(PROP_LEFT).asInt();
        ProcessActionRunner.add(new Runnable(){

            public void run() {
                TableColumnOperationHandler.moveColumn(column, newLeft);
            }
        });
    }

    public void handleCallResize(final TableColumn column, JsonObject properties) {
        final int width = properties.get(PROP_WIDTH).asInt();
        ProcessActionRunner.add(new Runnable(){

            public void run() {
                column.setWidth(width);
            }
        });
    }

    public void handleNotifySelection(TableColumn column, JsonObject properties) {
        Event event = TableColumnOperationHandler.createSelectionEvent(13, properties);
        column.notifyListeners(13, event);
    }

    public void handleNotifyDefaultSelection(TableColumn column, JsonObject properties) {
        Event event = TableColumnOperationHandler.createSelectionEvent(14, properties);
        column.notifyListeners(14, event);
    }

    static void moveColumn(TableColumn column, int newLeft) {
        Table table = column.getParent();
        int targetColumn = TableColumnOperationHandler.findMoveTarget(table, newLeft);
        int[] columnOrder = table.getColumnOrder();
        int index = table.indexOf(column);
        int orderIndex = TableColumnOperationHandler.arrayIndexOf(columnOrder, index);
        columnOrder = TableColumnOperationHandler.arrayRemove(columnOrder, orderIndex);
        if (orderIndex < targetColumn) {
            --targetColumn;
        }
        if (TableColumnOperationHandler.isFixed(column) || TableColumnOperationHandler.isFixed(table.getColumn(targetColumn))) {
            targetColumn = table.indexOf(column);
        }
        if (Arrays.equals(columnOrder = TableColumnOperationHandler.arrayInsert(columnOrder, targetColumn, index), table.getColumnOrder())) {
            TableColumn[] columns = table.getColumns();
            int i = 0;
            while (i < columns.length) {
                WidgetUtil.getAdapter(columns[i]).preserve(PROP_LEFT, null);
                ++i;
            }
        } else {
            table.setColumnOrder(columnOrder);
            WidgetUtil.getAdapter(column).preserve(PROP_LEFT, null);
        }
    }

    private static int findMoveTarget(Table table, int newLeft) {
        int result = -1;
        TableColumn[] columns = table.getColumns();
        int[] columnOrder = table.getColumnOrder();
        if (newLeft < 0) {
            result = 0;
        } else {
            int i = 0;
            while (result == -1 && i < columns.length) {
                TableColumn column = columns[columnOrder[i]];
                int left = TableColumnOperationHandler.getLeft(column);
                int width = column.getWidth();
                if (TableColumnOperationHandler.isFixed(column)) {
                    left += TableColumnOperationHandler.getLeftOffset(column);
                }
                if (newLeft >= left && newLeft <= left + width) {
                    result = i;
                    if (newLeft >= left + width / 2 && result < columns.length && !TableColumnOperationHandler.isFixed(column)) {
                        ++result;
                    }
                }
                ++i;
            }
        }
        if (result == -1) {
            result = columns.length;
        }
        return result;
    }

    private static boolean isFixed(TableColumn column) {
        return TableColumnOperationHandler.getTableAdapter(column).isFixedColumn(column);
    }

    private static int getLeft(TableColumn column) {
        return TableColumnOperationHandler.getTableAdapter(column).getColumnLeft(column);
    }

    private static int getLeftOffset(TableColumn column) {
        return TableColumnOperationHandler.getTableAdapter(column).getLeftOffset();
    }

    private static ITableAdapter getTableAdapter(TableColumn column) {
        return column.getParent().getAdapter(ITableAdapter.class);
    }

    private static int arrayIndexOf(int[] array, int value) {
        int result = -1;
        int i = 0;
        while (result == -1 && i < array.length) {
            if (array[i] == value) {
                result = i;
            }
            ++i;
        }
        return result;
    }

    private static int[] arrayRemove(int[] array, int index) {
        int length = array.length;
        int[] result = new int[length - 1];
        System.arraycopy(array, 0, result, 0, index);
        if (index < length - 1) {
            System.arraycopy(array, index + 1, result, index, length - index - 1);
        }
        return result;
    }

    private static int[] arrayInsert(int[] array, int index, int value) {
        int length = array.length;
        int[] result = new int[length + 1];
        System.arraycopy(array, 0, result, 0, length);
        System.arraycopy(result, index, result, index + 1, length - index);
        result[index] = value;
        return result;
    }
}

