/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.textkit;

import java.io.IOException;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.textkit.TextOperationHandler;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public final class TextLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.Text";
    private static final String[] ALLOWED_STYLES = new String[]{"CENTER", "LEFT", "RIGHT", "MULTI", "SINGLE", "PASSWORD", "SEARCH", "WRAP", "H_SCROLL", "V_SCROLL", "BORDER"};
    private static final String[] ALLOWED_STYLES_WITH_SEARCH = new String[]{"CENTER", "LEFT", "RIGHT", "SINGLE", "SEARCH", "ICON_CANCEL", "ICON_SEARCH", "BORDER"};
    private static final String PROP_TEXT = "text";
    private static final String PROP_TEXT_LIMIT = "textLimit";
    private static final String PROP_SELECTION = "selection";
    private static final String PROP_EDITABLE = "editable";
    private static final String PROP_ECHO_CHAR = "echoChar";
    private static final String PROP_MESSAGE = "message";
    private static final String PROP_MODIFY_LISTENER = "Modify";
    private static final String PROP_DEFAULT_SELECTION_LISTENER = "DefaultSelection";
    private static final Point ZERO_SELECTION = new Point(0, 0);

    public void preserveValues(Widget widget) {
        Text text = (Text)widget;
        ControlLCAUtil.preserveValues(text);
        WidgetLCAUtil.preserveCustomVariant(text);
        WidgetLCAUtil.preserveProperty((Widget)text, PROP_TEXT, text.getText());
        WidgetLCAUtil.preserveProperty((Widget)text, PROP_SELECTION, text.getSelection());
        WidgetLCAUtil.preserveProperty((Widget)text, PROP_TEXT_LIMIT, TextLCA.getTextLimit(text));
        WidgetLCAUtil.preserveProperty((Widget)text, PROP_EDITABLE, text.getEditable());
        WidgetLCAUtil.preserveProperty((Widget)text, PROP_ECHO_CHAR, TextLCA.getEchoChar(text));
        WidgetLCAUtil.preserveProperty((Widget)text, PROP_MESSAGE, text.getMessage());
        WidgetLCAUtil.preserveListener(text, PROP_MODIFY_LISTENER, TextLCA.hasModifyListener(text));
        WidgetLCAUtil.preserveListener(text, PROP_DEFAULT_SELECTION_LISTENER, EventLCAUtil.isListening(text, 14));
    }

    public void renderInitialization(Widget widget) throws IOException {
        Text text = (Text)widget;
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(text, TYPE);
        remoteObject.setHandler(new TextOperationHandler(text));
        remoteObject.set("parent", WidgetUtil.getId(text.getParent()));
        remoteObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(text, TextLCA.getAllowedStyles(text))));
    }

    public void renderChanges(Widget widget) throws IOException {
        Text text = (Text)widget;
        ControlLCAUtil.renderChanges(text);
        WidgetLCAUtil.renderCustomVariant(text);
        WidgetLCAUtil.renderProperty((Widget)text, PROP_TEXT, text.getText(), "");
        WidgetLCAUtil.renderProperty((Widget)text, PROP_EDITABLE, text.getEditable(), true);
        TextLCA.renderSelection(text);
        WidgetLCAUtil.renderProperty((Widget)text, PROP_TEXT_LIMIT, TextLCA.getTextLimit(text), null);
        WidgetLCAUtil.renderProperty((Widget)text, PROP_ECHO_CHAR, TextLCA.getEchoChar(text), null);
        WidgetLCAUtil.renderProperty((Widget)text, PROP_MESSAGE, text.getMessage(), "");
        WidgetLCAUtil.renderListener(text, PROP_MODIFY_LISTENER, TextLCA.hasModifyListener(text), false);
        WidgetLCAUtil.renderListener(text, PROP_DEFAULT_SELECTION_LISTENER, EventLCAUtil.isListening(text, 14), false);
        WidgetLCAUtil.renderClientListeners(text);
    }

    private static void renderSelection(Text text) {
        Point newValue = text.getSelection();
        boolean changed = WidgetLCAUtil.hasChanged(text, PROP_SELECTION, newValue, ZERO_SELECTION);
        if (!changed) {
            boolean bl = changed = WidgetLCAUtil.hasChanged(text, PROP_TEXT, text.getText()) && !newValue.equals(ZERO_SELECTION);
        }
        if (changed) {
            RemoteObject remoteObject = RemoteObjectFactory.getRemoteObject(text);
            remoteObject.set(PROP_SELECTION, new JsonArray().add(newValue.x).add(newValue.y));
        }
    }

    private static String[] getAllowedStyles(Text text) {
        return (text.getStyle() & 0x80) != 0 ? ALLOWED_STYLES_WITH_SEARCH : ALLOWED_STYLES;
    }

    private static Integer getTextLimit(Text text) {
        Integer result = null;
        int textLimit = text.getTextLimit();
        if (textLimit > 0 && textLimit != Integer.MAX_VALUE) {
            result = new Integer(textLimit);
        }
        return result;
    }

    private static String getEchoChar(Text text) {
        return text.getEchoChar() == '\u0000' ? null : String.valueOf(text.getEchoChar());
    }

    private static boolean hasModifyListener(Text text) {
        return EventLCAUtil.isListening(text, 24) || EventLCAUtil.isListening(text, 25);
    }
}

