/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.treecolumnkit;

import java.util.Arrays;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.rwt.internal.protocol.WidgetOperationHandler;
import org.eclipse.rap.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.internal.widgets.ITreeAdapter;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeColumnOperationHandler
extends WidgetOperationHandler<TreeColumn> {
    private static final String METHOD_MOVE = "move";
    private static final String METHOD_RESIZE = "resize";
    private static final String PROP_LEFT = "left";
    private static final String PROP_WIDTH = "width";

    public TreeColumnOperationHandler(TreeColumn column) {
        super(column);
    }

    @Override
    public void handleCall(TreeColumn column, String method, JsonObject properties) {
        if (METHOD_MOVE.equals(method)) {
            this.handleCallMove(column, properties);
        } else if (METHOD_RESIZE.equals(method)) {
            this.handleCallResize(column, properties);
        }
    }

    @Override
    public void handleNotify(TreeColumn column, String eventName, JsonObject properties) {
        if ("Selection".equals(eventName)) {
            this.handleNotifySelection(column, properties);
        } else if ("DefaultSelection".equals(eventName)) {
            this.handleNotifyDefaultSelection(column, properties);
        } else {
            super.handleNotify(column, eventName, properties);
        }
    }

    public void handleCallMove(final TreeColumn column, JsonObject properties) {
        final int newLeft = properties.get(PROP_LEFT).asInt();
        ProcessActionRunner.add(new Runnable(){

            public void run() {
                TreeColumnOperationHandler.moveColumn(column, newLeft);
            }
        });
    }

    public void handleCallResize(final TreeColumn column, JsonObject properties) {
        final int width = properties.get(PROP_WIDTH).asInt();
        ProcessActionRunner.add(new Runnable(){

            public void run() {
                column.setWidth(width);
            }
        });
    }

    public void handleNotifySelection(TreeColumn column, JsonObject properties) {
        Event event = TreeColumnOperationHandler.createSelectionEvent(13, properties);
        column.notifyListeners(13, event);
    }

    public void handleNotifyDefaultSelection(TreeColumn column, JsonObject properties) {
        Event event = TreeColumnOperationHandler.createSelectionEvent(14, properties);
        column.notifyListeners(14, event);
    }

    static void moveColumn(TreeColumn column, int newLeft) {
        Tree tree = column.getParent();
        int targetColumn = TreeColumnOperationHandler.findMoveTarget(tree, newLeft);
        int[] columnOrder = tree.getColumnOrder();
        int index = tree.indexOf(column);
        int orderIndex = TreeColumnOperationHandler.arrayIndexOf(columnOrder, index);
        columnOrder = TreeColumnOperationHandler.arrayRemove(columnOrder, orderIndex);
        if (orderIndex < targetColumn) {
            --targetColumn;
        }
        if (TreeColumnOperationHandler.isFixed(column) || TreeColumnOperationHandler.isFixed(tree.getColumn(targetColumn))) {
            targetColumn = tree.indexOf(column);
        }
        if (Arrays.equals(columnOrder = TreeColumnOperationHandler.arrayInsert(columnOrder, targetColumn, index), tree.getColumnOrder())) {
            TreeColumn[] columns = tree.getColumns();
            int i = 0;
            while (i < columns.length) {
                WidgetUtil.getAdapter(columns[i]).preserve(PROP_LEFT, null);
                ++i;
            }
        } else {
            tree.setColumnOrder(columnOrder);
            WidgetUtil.getAdapter(column).preserve(PROP_LEFT, null);
        }
    }

    private static int findMoveTarget(Tree tree, int newLeft) {
        int result = -1;
        TreeColumn[] columns = tree.getColumns();
        int[] columnOrder = tree.getColumnOrder();
        if (newLeft < 0) {
            result = 0;
        } else {
            int i = 0;
            while (result == -1 && i < columns.length) {
                TreeColumn column = columns[columnOrder[i]];
                int left = TreeColumnOperationHandler.getLeft(column);
                int width = column.getWidth();
                if (TreeColumnOperationHandler.isFixed(column)) {
                    left += TreeColumnOperationHandler.getLeftOffset(column);
                }
                if (newLeft >= left && newLeft <= left + width) {
                    result = i;
                    if (newLeft >= left + width / 2 && result < columns.length && !TreeColumnOperationHandler.isFixed(column)) {
                        ++result;
                    }
                }
                ++i;
            }
        }
        if (result == -1) {
            result = columns.length;
        }
        return result;
    }

    private static boolean isFixed(TreeColumn column) {
        return TreeColumnOperationHandler.getTreeAdapter(column).isFixedColumn(column);
    }

    private static int getLeft(TreeColumn column) {
        return TreeColumnOperationHandler.getTreeAdapter(column).getColumnLeft(column);
    }

    private static int getLeftOffset(TreeColumn column) {
        return TreeColumnOperationHandler.getTreeAdapter(column).getScrollLeft();
    }

    private static ITreeAdapter getTreeAdapter(TreeColumn column) {
        return column.getParent().getAdapter(ITreeAdapter.class);
    }

    private static int arrayIndexOf(int[] array, int value) {
        int result = -1;
        int i = 0;
        while (result == -1 && i < array.length) {
            if (array[i] == value) {
                result = i;
            }
            ++i;
        }
        return result;
    }

    private static int[] arrayRemove(int[] array, int index) {
        int length = array.length;
        int[] result = new int[length - 1];
        System.arraycopy(array, 0, result, 0, index);
        if (index < length - 1) {
            System.arraycopy(array, index + 1, result, index, length - index - 1);
        }
        return result;
    }

    private static int[] arrayInsert(int[] array, int index, int value) {
        int length = array.length;
        int[] result = new int[length + 1];
        System.arraycopy(array, 0, result, 0, length);
        System.arraycopy(result, index, result, index + 1, length - index);
        result[index] = value;
        return result;
    }
}

