/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rap.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.widgets.MenuHolder;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Decorations
extends Canvas {
    private Menu menuBar;
    private MenuHolder menuHolder;
    private DisposeListener menuBarDisposeListener;
    private Image image;
    private Image[] images = new Image[0];
    private String text = "";
    private Button defaultButton;
    private Button saveDefault;
    private Listener defaultButtonFocusListener;
    private Control savedFocus;

    Decorations(Composite parent) {
        super(parent);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        Object result;
        if (adapter == MenuHolder.IMenuHolderAdapter.class) {
            if (this.menuHolder == null) {
                this.menuHolder = new MenuHolder();
            }
            result = this.menuHolder;
        } else {
            result = super.getAdapter(adapter);
        }
        return result;
    }

    public void setImages(Image[] images) {
        this.checkWidget();
        if (images == null) {
            this.error(5);
        }
        int i = 0;
        while (i < images.length) {
            if (images[i] == null) {
                this.error(5);
            }
            ++i;
        }
        this.images = images;
    }

    public Image[] getImages() {
        this.checkWidget();
        return this.images;
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.image = image;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public void setText(String text) {
        this.checkWidget();
        if (text == null) {
            this.error(4);
        }
        this.text = text;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public void setMenuBar(Menu menuBar) {
        this.checkWidget();
        if (this.menuBar != menuBar) {
            if (menuBar != null) {
                if (menuBar.isDisposed()) {
                    SWT.error(5);
                }
                if (menuBar.getParent() != this) {
                    SWT.error(32);
                }
                if ((menuBar.getStyle() & 2) == 0) {
                    SWT.error(33);
                }
            }
            this.removeMenuBarDisposeListener();
            this.menuBar = menuBar;
            this.addMenuBarDisposeListener();
        }
    }

    public Menu getMenuBar() {
        this.checkWidget();
        return this.menuBar;
    }

    public void setDefaultButton(Button button) {
        this.checkWidget();
        if (button != null) {
            if (button.isDisposed()) {
                this.error(5);
            }
            if (button.getShell() != this) {
                this.error(32);
            }
        }
        this.setDefaultButton(button, true);
    }

    public Button getDefaultButton() {
        this.checkWidget();
        Button result = null;
        if (this.defaultButton != null && !this.defaultButton.isDisposed()) {
            result = this.defaultButton;
        }
        return result;
    }

    void updateDefaultButton(final Control focusControl, final boolean set) {
        if (Decorations.isPushButton(focusControl)) {
            ProcessActionRunner.add(new Runnable(){

                public void run() {
                    Button defaultButton = (Button)focusControl;
                    Decorations.this.updateDefaultButtonFocusListener(defaultButton, set);
                    Decorations.this.setDefaultButton(set ? defaultButton : null, false);
                }
            });
        }
    }

    void setDefaultButton(Button button, boolean save) {
        if (button == null) {
            if (this.defaultButton == this.saveDefault) {
                if (save) {
                    this.saveDefault = null;
                }
                return;
            }
        } else {
            if ((button.getStyle() & 8) == 0) {
                return;
            }
            if (button == this.defaultButton) {
                if (save) {
                    this.saveDefault = this.defaultButton;
                }
                return;
            }
        }
        if (this.defaultButton != null && !this.defaultButton.isDisposed()) {
            this.defaultButton.setDefault(false);
        }
        this.defaultButton = button;
        if (this.defaultButton == null) {
            this.defaultButton = this.saveDefault;
        }
        if (this.defaultButton != null && !this.defaultButton.isDisposed()) {
            this.defaultButton.setDefault(true);
        }
        if (save) {
            this.saveDefault = this.defaultButton;
        }
        if (this.saveDefault != null && this.saveDefault.isDisposed()) {
            this.saveDefault = null;
        }
    }

    final void setSavedFocus(Control control) {
        this.savedFocus = control;
    }

    final Control getSavedFocus() {
        return this.savedFocus;
    }

    final void saveFocus() {
        Control control = this.display.getFocusControl();
        if (control != null && control != this && this == control.getShell()) {
            this.setSavedFocus(control);
        }
    }

    final boolean restoreFocus() {
        if (this.savedFocus != null && this.savedFocus.isDisposed()) {
            this.savedFocus = null;
        }
        boolean result = false;
        if (this.savedFocus != null && this.savedFocus.setSavedFocus()) {
            result = true;
        }
        return result;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    static int checkStyle(int style) {
        int result = style;
        if ((result & 8) != 0) {
            int trim = 3312;
            result &= ~trim;
        }
        if ((result & 0x4C0) != 0) {
            result |= 0x20;
        }
        if ((result & 0x480) != 0) {
            result |= 0x40;
        }
        return result;
    }

    @Override
    final void releaseWidget() {
        this.removeMenuBarDisposeListener();
        super.releaseWidget();
    }

    private void addMenuBarDisposeListener() {
        if (this.menuBar != null) {
            if (this.menuBarDisposeListener == null) {
                this.menuBarDisposeListener = new DisposeListener(){

                    public void widgetDisposed(DisposeEvent event) {
                        Decorations.this.menuBar = null;
                    }
                };
            }
            this.menuBar.addDisposeListener(this.menuBarDisposeListener);
        }
    }

    private void removeMenuBarDisposeListener() {
        if (this.menuBar != null) {
            this.menuBar.removeDisposeListener(this.menuBarDisposeListener);
        }
    }

    private static boolean isPushButton(Control control) {
        return control instanceof Button && (control.style & 8) != 0;
    }

    private void updateDefaultButtonFocusListener(Button defaultButton, boolean set) {
        if (!defaultButton.isDisposed()) {
            if (set) {
                defaultButton.addListener(16, this.getDefaultButtonFocusListener());
            } else {
                defaultButton.removeListener(16, this.getDefaultButtonFocusListener());
            }
        }
    }

    private Listener getDefaultButtonFocusListener() {
        if (this.defaultButtonFocusListener == null) {
            this.defaultButtonFocusListener = new Listener(){

                public void handleEvent(Event event) {
                }
            };
        }
        return this.defaultButtonFocusListener;
    }

    @Override
    void reskinChildren(int flags) {
        if (this.menuBar != null) {
            this.menuBar.reskin(flags);
        }
        Menu[] menus = MenuHolder.getMenus(this);
        int i = 0;
        while (i < menus.length) {
            Menu menu = menus[i];
            if (menu != null) {
                menu.reskin(flags);
            }
            ++i;
        }
        super.reskinChildren(flags);
    }
}

