/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.rap.demo.controls.Util;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

class RowLayoutTab
extends ExampleTab {
    private boolean propPrefSize;
    private boolean propWrap;

    public RowLayoutTab() {
        super("RowLayout");
    }

    protected void createStyleControls(Composite parent) {
        this.createStyleButton("HORIZONTAL", 256);
        this.createStyleButton("VERTICAL", 512);
        final Button prefSizeButton = this.createPropertyButton("Preferred Size");
        prefSizeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RowLayoutTab.this.propPrefSize = prefSizeButton.getSelection();
                RowLayoutTab.this.createNew();
            }
        });
        final Button wrapButton = this.createPropertyButton("Wrap");
        wrapButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RowLayoutTab.this.propWrap = wrapButton.getSelection();
                RowLayoutTab.this.createNew();
            }
        });
    }

    protected void createExampleControls(Composite parent) {
        int style = this.getStyle();
        GridLayout parentLayout = new GridLayout();
        parentLayout.marginWidth = 5;
        parent.setLayout((Layout)parentLayout);
        Composite comp = new Composite(parent, 0);
        comp.setBackground(this.bgColors[3]);
        RowLayout layout = new RowLayout(style);
        layout.wrap = this.propWrap;
        comp.setLayout((Layout)layout);
        Button b1 = new Button(comp, 8);
        b1.setText("Button 1");
        Button b2 = new Button(comp, 8);
        b2.setText("Button 2");
        Button b3 = new Button(comp, 8);
        b3.setText("Button 3");
        Label l1 = new Label(comp, 2048);
        l1.setText("Label");
        Text t1 = new Text(comp, 2052);
        t1.setText("Lorem ipsum dolor sit amet");
        this.createSomeImages(comp);
        this.createTabFolder(comp);
        new Text(comp, 2052);
        if (this.propPrefSize) {
            comp.setLayoutData((Object)new GridData());
        } else {
            comp.setLayoutData((Object)new GridData(1808));
        }
        comp.layout();
        this.registerControl((Control)comp);
    }

    private void createSomeImages(Composite parent) {
        Image image1 = Util.loadImage(parent.getDisplay(), "icons/info.gif");
        Image image2 = Util.loadImage(parent.getDisplay(), "icons/lockkey.gif");
        Image image3 = Util.loadImage(parent.getDisplay(), "icons/test-100x50.png");
        Image image4 = Util.loadImage(parent.getDisplay(), "icons/test-50x100.png");
        Label l1 = new Label(parent, 2048);
        l1.setImage(image1);
        Label l2 = new Label(parent, 2048);
        l2.setImage(image2);
        Label l3 = new Label(parent, 2048);
        l3.setImage(image3);
        Label l4 = new Label(parent, 2048);
        l4.setImage(image4);
    }

    private TabFolder createTabFolder(Composite parent) {
        TabFolder tf = new TabFolder(parent, 2048);
        TabItem tab1 = new TabItem(tf, 0);
        tab1.setText("Tab1");
        Label tla1 = new Label((Composite)tf, 0);
        tla1.setText("Content 1");
        tab1.setControl((Control)tla1);
        TabItem tab2 = new TabItem(tf, 0);
        tab2.setText("Tab2");
        Label tla2 = new Label((Composite)tf, 0);
        tla2.setText("Content 2\nwith two lines");
        tab2.setControl((Control)tla2);
        TabItem tab3 = new TabItem(tf, 0);
        tab3.setText("Tab3");
        Label tla3 = new Label((Composite)tf, 0);
        tla3.setText("Content 3 is somewhat longer");
        tab3.setControl((Control)tla3);
        tf.setSelection(0);
        return tf;
    }
}

