/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.examples.internal;

import java.util.List;
import org.eclipse.rap.examples.ExampleUtil;
import org.eclipse.rap.examples.IExampleContribution;
import org.eclipse.rap.examples.internal.DropDownNavigation;
import org.eclipse.rap.examples.internal.ExampleCategory;
import org.eclipse.rap.examples.internal.Examples;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public abstract class Navigation {
    private final Composite composite;

    public Navigation(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)ExampleUtil.createGridLayoutWithoutMargin(9, false));
        this.composite.setData("org.eclipse.rap.rwt.customVariant", (Object)"navigation");
        this.createNavigationControls(this.composite);
    }

    public Control getControl() {
        return this.composite;
    }

    private void createNavigationControls(Composite parent) {
        List<ExampleCategory> categories = Examples.getInstance().getCategories();
        for (ExampleCategory category : categories) {
            this.createNavigationDropDown(parent, category);
        }
    }

    private void createNavigationDropDown(Composite parent, ExampleCategory category) {
        new DropDownNavigation(parent, category){

            protected void contributionSelected(IExampleContribution contribution) {
                Navigation.this.selectContribution(contribution);
            }
        };
    }

    protected abstract void selectContribution(IExampleContribution var1);

    public void selectNavigationEntry(IExampleContribution contribution) {
        Control[] children;
        Control[] controlArray = children = this.composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof DropDownNavigation) {
                this.changeSelectedDropDownEntry(contribution, (DropDownNavigation)control);
            }
            ++n2;
        }
    }

    private void changeSelectedDropDownEntry(IExampleContribution contribution, DropDownNavigation navEntry) {
        boolean belongsToDropDownNav = this.contributionBelongsToDropDownNav(contribution, navEntry);
        ToolItem item = ((ToolBar)navEntry.getChildren()[0]).getItem(0);
        if (belongsToDropDownNav) {
            item.setData("org.eclipse.rap.rwt.customVariant", (Object)"selected");
        } else {
            item.setData("org.eclipse.rap.rwt.customVariant", (Object)"navigation");
        }
    }

    private boolean contributionBelongsToDropDownNav(IExampleContribution contribution, DropDownNavigation navEntry) {
        ExampleCategory category = navEntry.getCategory();
        return category.getContributionIds().contains(contribution.getId());
    }
}

