/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.testfixture;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestMessage {
    private final JsonObject message;
    private final JsonArray operations;

    public TestMessage(JsonObject json) {
        ParamCheck.notNull((Object)json, (String)"json");
        this.message = json;
        try {
            this.operations = this.message.get("operations").asArray();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Missing operations array: " + json);
        }
    }

    public JsonObject getHead() {
        return this.message.get("head").asObject();
    }

    public int getRequestCounter() {
        return this.message.get("head").asObject().get("requestCounter").asInt();
    }

    public String getError() {
        return this.message.get("head").asObject().get("error").asString();
    }

    public String getErrorMessage() {
        return this.message.get("head").asObject().get("message").asString();
    }

    public int getOperationCount() {
        return this.operations.size();
    }

    public Operation getOperation(int position) {
        Operation result;
        JsonArray operation = this.getOperationAsJson(position);
        String action = this.getOperationAction(operation);
        if (action.equals("create")) {
            result = new CreateOperation(operation, position);
        } else if (action.equals("call")) {
            result = new CallOperation(operation, position);
        } else if (action.equals("set")) {
            result = new SetOperation(operation, position);
        } else if (action.equals("listen")) {
            result = new ListenOperation(operation, position);
        } else if (action.equals("destroy")) {
            result = new DestroyOperation(operation, position);
        } else {
            throw new IllegalArgumentException("Unknown operation action: " + action);
        }
        return result;
    }

    public JsonValue findSetProperty(Widget widget, String property) {
        return this.findSetProperty(WidgetUtil.getId((Widget)widget), property);
    }

    public JsonValue findSetProperty(String target, String property) {
        SetOperation operation = this.findSetOperation(target, property);
        if (operation == null) {
            throw new IllegalStateException("operation not found");
        }
        return operation.getProperty(property);
    }

    public SetOperation findSetOperation(Widget widget, String property) {
        return this.findSetOperation(WidgetUtil.getId((Widget)widget), property);
    }

    public ListenOperation findListenOperation(Widget widget, String property) {
        return this.findListenOperation(WidgetUtil.getId((Widget)widget), property);
    }

    public ListenOperation findListenOperation(String target, String property) {
        return (ListenOperation)this.findOperation(ListenOperation.class, target, property);
    }

    public JsonValue findListenProperty(Widget widget, String property) {
        return this.findListenProperty(WidgetUtil.getId((Widget)widget), property);
    }

    public JsonValue findListenProperty(String target, String property) {
        ListenOperation operation = this.findListenOperation(target, property);
        if (operation == null) {
            throw new IllegalStateException("operation not found");
        }
        return operation.getProperty(property);
    }

    public CreateOperation findCreateOperation(Widget widget) {
        return this.findCreateOperation(WidgetUtil.getId((Widget)widget));
    }

    public JsonValue findCreateProperty(Widget widget, String property) {
        return this.findCreateProperty(WidgetUtil.getId((Widget)widget), property);
    }

    public JsonValue findCreateProperty(String target, String property) {
        CreateOperation operation = this.findCreateOperation(target);
        if (operation == null || operation.getPropertyNames().indexOf(property) == -1) {
            throw new IllegalStateException("operation not found");
        }
        return operation.getProperty(property);
    }

    public CreateOperation findCreateOperation(String target) {
        return (CreateOperation)this.findOperation(CreateOperation.class, target);
    }

    public DestroyOperation findDestroyOperation(Widget widget) {
        return (DestroyOperation)this.findOperation(DestroyOperation.class, WidgetUtil.getId((Widget)widget));
    }

    public SetOperation findSetOperation(String target, String property) {
        return (SetOperation)this.findOperation(SetOperation.class, target, property);
    }

    public CallOperation findCallOperation(Widget widget, String method) {
        return this.findCallOperation(WidgetUtil.getId((Widget)widget), method);
    }

    public CallOperation findCallOperation(String target, String method) {
        CallOperation result = null;
        List<Operation> operations = this.getOperations();
        for (Operation operation : operations) {
            if (!operation.getTarget().equals(target) || !(operation instanceof CallOperation) || !method.equals(((CallOperation)operation).getMethodName())) continue;
            result = (CallOperation)operation;
        }
        return result;
    }

    public String toString() {
        return this.message.toString();
    }

    public int hashCode() {
        return this.message.hashCode();
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (this == obj) {
            equals = true;
        } else if (obj != null && this.getClass() == obj.getClass()) {
            TestMessage other = (TestMessage)obj;
            equals = this.message.equals((Object)other.message);
        }
        return equals;
    }

    private List<Operation> getOperations() {
        ArrayList<Operation> result = new ArrayList<Operation>();
        int i = 0;
        while (i < this.getOperationCount()) {
            result.add(this.getOperation(i));
            ++i;
        }
        return result;
    }

    private Operation findOperation(Class opClass, String target) {
        return this.findOperation(opClass, target, null);
    }

    private Operation findOperation(Class opClass, String target, String property) {
        Operation result = null;
        List<Operation> operations = this.getOperations();
        for (Operation operation : operations) {
            if (!operation.getTarget().equals(target) || !opClass.isInstance(operation) || property != null && !operation.getPropertyNames().contains(property)) continue;
            result = operation;
        }
        return result;
    }

    private JsonArray getOperationAsJson(int position) {
        JsonArray result;
        try {
            result = this.operations.get(position).asArray();
        }
        catch (Exception exception) {
            throw new IllegalStateException("Could not find operation at position " + position);
        }
        return result;
    }

    private String getOperationAction(JsonArray operation) {
        String action;
        try {
            action = operation.get(0).asString();
        }
        catch (Exception exception) {
            throw new IllegalStateException("Could not find action for operation " + operation);
        }
        return action;
    }

    public final class CallOperation
    extends Operation {
        private CallOperation(JsonArray operation, int position) {
            super(operation, position);
        }

        public String getMethodName() {
            String result;
            try {
                result = this.operation.get(2).asString();
            }
            catch (Exception e) {
                throw new IllegalStateException("Invalid call operation method name", e);
            }
            return result;
        }

        protected JsonObject getProperties() {
            JsonObject properties;
            try {
                properties = this.operation.get(3).asObject();
            }
            catch (Exception e) {
                throw new IllegalStateException("Properties object missing in operation", e);
            }
            return properties;
        }
    }

    public final class CreateOperation
    extends Operation {
        private CreateOperation(JsonArray operation, int position) {
            super(operation, position);
        }

        public String getParent() {
            return this.getProperty("parent").asString();
        }

        public String getType() {
            String result;
            try {
                result = this.operation.get(2).asString();
            }
            catch (Exception e) {
                throw new IllegalStateException("Invalid create operation type", e);
            }
            return result;
        }

        protected JsonObject getProperties() {
            JsonObject properties;
            try {
                properties = this.operation.get(3).asObject();
            }
            catch (Exception e) {
                throw new IllegalStateException("Properties object missing in operation", e);
            }
            return properties;
        }

        public Object[] getStyles() {
            Object[] result = null;
            JsonValue detail = this.getProperty("style");
            if (detail != null) {
                JsonArray parameters = detail.asArray();
                result = new Object[parameters.size()];
                int i = 0;
                while (i < result.length) {
                    try {
                        result[i] = parameters.get(i).asString();
                    }
                    catch (Exception exception) {
                        String message = "Style array is not valid for operation ";
                        throw new IllegalStateException(message);
                    }
                    ++i;
                }
            }
            return result;
        }
    }

    public final class DestroyOperation
    extends Operation {
        private DestroyOperation(JsonArray operation, int position) {
            super(operation, position);
        }

        protected JsonObject getProperties() {
            throw new IllegalStateException("Destroy operation has no properties");
        }
    }

    public final class ListenOperation
    extends Operation {
        private ListenOperation(JsonArray operation, int position) {
            super(operation, position);
        }

        public boolean listensTo(String eventName) {
            return this.getProperty(eventName).asBoolean();
        }

        protected JsonObject getProperties() {
            JsonObject properties;
            try {
                properties = this.operation.get(2).asObject();
            }
            catch (Exception e) {
                throw new IllegalStateException("Properties object missing in operation", e);
            }
            return properties;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class Operation {
        private final String target;
        private final int position;
        protected final JsonArray operation;

        private Operation(JsonArray operation, int position) {
            this.operation = operation;
            this.position = position;
            try {
                this.target = operation.get(1).asString();
            }
            catch (Exception e) {
                throw new IllegalStateException("Invalid operation target", e);
            }
        }

        public String getTarget() {
            return this.target;
        }

        public List<String> getPropertyNames() {
            return this.getProperties().names();
        }

        public JsonValue getProperty(String key) {
            return this.getProperties().get(key);
        }

        public int getPosition() {
            return this.position;
        }

        protected abstract JsonObject getProperties();
    }

    public final class SetOperation
    extends Operation {
        private SetOperation(JsonArray operation, int position) {
            super(operation, position);
        }

        protected JsonObject getProperties() {
            JsonObject properties;
            try {
                properties = this.operation.get(2).asObject();
            }
            catch (Exception e) {
                throw new IllegalStateException("Properties object missing in operation", e);
            }
            return properties;
        }
    }
}

