/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.protocol;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.protocol.Message;
import org.eclipse.rap.rwt.internal.protocol.Operation;
import org.eclipse.rap.rwt.internal.protocol.OperationReader;
import org.eclipse.rap.rwt.internal.util.ParamCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageImpl
implements Message {
    private final JsonObject head;
    private final List<Operation> operations;
    public static final String PROP_HEAD = "head";
    public static final String PROP_OPERATIONS = "operations";
    public static final String OPERATION_SET = "set";
    public static final String OPERATION_NOTIFY = "notify";
    public static final String OPERATION_CALL = "call";

    public MessageImpl() {
        this.head = new JsonObject();
        this.operations = new ArrayList<Operation>();
    }

    public MessageImpl(Message message) {
        ParamCheck.notNull(message, "message");
        this.head = message.getHead();
        this.operations = message.getOperations();
    }

    public MessageImpl(JsonObject json) {
        ParamCheck.notNull(json, "json");
        this.head = MessageImpl.readHead(json);
        this.operations = MessageImpl.readOperations(json);
    }

    @Override
    public JsonObject getHead() {
        return this.head;
    }

    @Override
    public List<Operation> getOperations() {
        return this.operations;
    }

    public String toString() {
        return this.toJson().toString();
    }

    private JsonObject toJson() {
        JsonArray operationsArray = new JsonArray();
        for (Operation operation : this.operations) {
            operationsArray.add(operation.toJson());
        }
        return new JsonObject().add(PROP_HEAD, this.head).add(PROP_OPERATIONS, operationsArray);
    }

    private static JsonObject readHead(JsonObject message) {
        try {
            return message.get(PROP_HEAD).asObject();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Failed to read head from JSON message", exception);
        }
    }

    private static List<Operation> readOperations(JsonObject message) {
        try {
            return MessageImpl.processOperations(message.get(PROP_OPERATIONS).asArray());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Failed to read operations from JSON message", exception);
        }
    }

    private static List<Operation> processOperations(JsonArray operationsArray) {
        ArrayList<Operation> operations = new ArrayList<Operation>(operationsArray.size());
        for (JsonValue operation : operationsArray) {
            operations.add(OperationReader.readOperation((JsonValue)operation.asArray()));
        }
        return operations;
    }
}

