/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.protocol;

import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.protocol.Operation;
import org.eclipse.rap.rwt.internal.util.ParamCheck;

public class OperationReader {
    public static Operation readOperation(JsonValue json) {
        ParamCheck.notNull(json, "json");
        try {
            return OperationReader.readOperation(json.asArray());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not read operation: " + json, exception);
        }
    }

    private static Operation readOperation(JsonArray json) {
        String action = json.get(0).asString();
        String target = json.get(1).asString();
        if (action.equals("set")) {
            return OperationReader.readSetOperation(json, target);
        }
        if (action.equals("notify")) {
            return OperationReader.readNotifyOperation(json, target);
        }
        if (action.equals("call")) {
            return OperationReader.readCallOperation(json, target);
        }
        throw new IllegalArgumentException("Unknown operation type: " + action);
    }

    private static Operation readSetOperation(JsonArray json, String target) {
        JsonObject properties = json.get(2).asObject();
        return new Operation.SetOperation(target, properties);
    }

    private static Operation readCallOperation(JsonArray json, String target) {
        String method = json.get(2).asString();
        JsonObject parameters = json.get(3).asObject();
        return new Operation.CallOperation(target, method, parameters);
    }

    private static Operation readNotifyOperation(JsonArray json, String target) {
        String event = json.get(2).asString();
        JsonObject properties = json.get(3).asObject();
        return new Operation.NotifyOperation(target, event, properties);
    }
}

