/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.client.WebClient;
import org.eclipse.rap.rwt.internal.lifecycle.RequestCounter;
import org.eclipse.rap.rwt.internal.protocol.ClientMessage;
import org.eclipse.rap.rwt.internal.protocol.Message;
import org.eclipse.rap.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.RWTMessageHandler;
import org.eclipse.rap.rwt.internal.service.ServiceContext;
import org.eclipse.rap.rwt.internal.service.StartupJson;
import org.eclipse.rap.rwt.internal.service.StartupPage;
import org.eclipse.rap.rwt.internal.service.UISessionBuilder;
import org.eclipse.rap.rwt.internal.service.UISessionImpl;
import org.eclipse.rap.rwt.internal.service.UrlParameters;
import org.eclipse.rap.rwt.service.ServiceHandler;
import org.eclipse.rap.rwt.service.UISession;

public class LifeCycleServiceHandler
implements ServiceHandler {
    private static final String PROP_ERROR = "error";
    private static final String PROP_REQUEST_COUNTER = "requestCounter";
    private static final String ATTR_LAST_PROTOCOL_MESSAGE = String.valueOf(LifeCycleServiceHandler.class.getName()) + "#lastProtocolMessage";
    private static final String ATTR_SESSION_STARTED = String.valueOf(LifeCycleServiceHandler.class.getName()) + "#isSessionStarted";
    private final RWTMessageHandler messageHandler;
    private final StartupPage startupPage;

    public LifeCycleServiceHandler(RWTMessageHandler messageHandler, StartupPage startupPage) {
        this.messageHandler = messageHandler;
        this.startupPage = startupPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        UISessionImpl uiSession = (UISessionImpl)ContextProvider.getUISession();
        Object object = uiSession.getRequestLock();
        synchronized (object) {
            this.synchronizedService(request, response);
        }
    }

    void synchronizedService(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if ("POST".equals(request.getMethod()) && LifeCycleServiceHandler.isContentTypeValid((ServletRequest)request)) {
            this.handleUIRequest(request, response);
        } else {
            this.handleStartupRequest(request, response);
        }
    }

    private void handleStartupRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            this.sendStartupContent((ServletRequest)request, response);
        }
        finally {
            LifeCycleServiceHandler.shutdownUISession();
        }
    }

    private void handleUIRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            this.processUIRequest(request, response);
        }
        catch (IOException exception) {
            LifeCycleServiceHandler.shutdownUISession();
            throw exception;
        }
        catch (RuntimeException exception) {
            LifeCycleServiceHandler.shutdownUISession();
            throw exception;
        }
    }

    private void sendStartupContent(ServletRequest request, HttpServletResponse response) throws IOException {
        if (RWT.getClient() instanceof WebClient) {
            this.startupPage.send(response);
        } else {
            StartupJson.send(response);
        }
    }

    private void processUIRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Message message = this.readMessage(request);
        LifeCycleServiceHandler.setJsonResponseHeaders((ServletResponse)response);
        if (LifeCycleServiceHandler.isSessionShutdown(message)) {
            LifeCycleServiceHandler.shutdownUISession();
            LifeCycleServiceHandler.writeEmptyMessage((ServletResponse)response);
        } else if (LifeCycleServiceHandler.isSessionTimeout(message)) {
            LifeCycleServiceHandler.writeSessionTimeoutError(response);
        } else if (!LifeCycleServiceHandler.isRequestCounterValid(message)) {
            if (LifeCycleServiceHandler.isDuplicateRequest(message)) {
                LifeCycleServiceHandler.writeBufferedResponse(response);
            } else {
                LifeCycleServiceHandler.writeInvalidRequestCounterError(response);
            }
        } else {
            if (LifeCycleServiceHandler.isSessionRestart(message)) {
                LifeCycleServiceHandler.reinitializeUISession(request);
                LifeCycleServiceHandler.reinitializeServiceStore();
            }
            UrlParameters.merge(message);
            JsonObject outMessage = this.processMessage(message);
            LifeCycleServiceHandler.writeProtocolMessage(outMessage, (ServletResponse)response);
            LifeCycleServiceHandler.markSessionStarted();
        }
    }

    private Message readMessage(HttpServletRequest request) {
        try {
            return new ClientMessage(JsonObject.readFrom(LifeCycleServiceHandler.getReader(request)));
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Unable to read the json message", ioe);
        }
    }

    private static Reader getReader(HttpServletRequest request) throws IOException {
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return new InputStreamReader((InputStream)request.getInputStream(), encoding);
    }

    private JsonObject processMessage(Message inMessage) {
        return this.messageHandler.handleMessage(inMessage);
    }

    private static boolean isRequestCounterValid(Message message) {
        return LifeCycleServiceHandler.hasInitializeParameter(message) || LifeCycleServiceHandler.hasValidRequestCounter(message);
    }

    static boolean hasValidRequestCounter(Message message) {
        int currentRequestId = RequestCounter.getInstance().currentRequestId();
        JsonValue sentRequestId = message.getHead().get(PROP_REQUEST_COUNTER);
        if (sentRequestId == null) {
            return currentRequestId == 0;
        }
        return currentRequestId == sentRequestId.asInt();
    }

    private static boolean isDuplicateRequest(Message message) {
        int currentRequestId = RequestCounter.getInstance().currentRequestId();
        JsonValue sentRequestId = message.getHead().get(PROP_REQUEST_COUNTER);
        return sentRequestId != null && sentRequestId.asInt() == currentRequestId - 1;
    }

    private static boolean isContentTypeValid(ServletRequest request) {
        String contentType = request.getContentType();
        return contentType != null && contentType.startsWith("application/json");
    }

    private static void shutdownUISession() {
        UISessionImpl uiSession = (UISessionImpl)ContextProvider.getUISession();
        uiSession.shutdown();
    }

    private static void writeInvalidRequestCounterError(HttpServletResponse response) throws IOException {
        LifeCycleServiceHandler.writeError(response, 412, "invalid request counter");
    }

    private static void writeSessionTimeoutError(HttpServletResponse response) throws IOException {
        LifeCycleServiceHandler.writeError(response, 403, "session timeout");
    }

    private static void writeError(HttpServletResponse response, int statusCode, String errorType) throws IOException {
        response.setStatus(statusCode);
        ProtocolMessageWriter writer = new ProtocolMessageWriter();
        writer.appendHead(PROP_ERROR, JsonValue.valueOf(errorType));
        writer.createMessage().writeTo(response.getWriter());
    }

    private static void reinitializeUISession(HttpServletRequest request) {
        ServiceContext serviceContext = ContextProvider.getContext();
        UISessionImpl uiSession = (UISessionImpl)ContextProvider.getUISession();
        uiSession.shutdown();
        UISessionBuilder builder = new UISessionBuilder(serviceContext);
        uiSession = builder.buildUISession();
        serviceContext.setUISession(uiSession);
    }

    private static void reinitializeServiceStore() {
        ClientMessage clientMessage = ProtocolUtil.getClientMessage();
        ContextProvider.getServiceStore().clear();
        ProtocolUtil.setClientMessage(clientMessage);
    }

    private static boolean isSessionRestart(Message message) {
        return LifeCycleServiceHandler.isSessionStarted() && LifeCycleServiceHandler.hasInitializeParameter(message);
    }

    private static boolean isSessionTimeout(Message message) {
        return !LifeCycleServiceHandler.isSessionStarted() && !LifeCycleServiceHandler.hasInitializeParameter(message);
    }

    static void markSessionStarted() {
        ContextProvider.getUISession().setAttribute(ATTR_SESSION_STARTED, Boolean.TRUE);
    }

    private static boolean isSessionStarted() {
        return Boolean.TRUE.equals(ContextProvider.getUISession().getAttribute(ATTR_SESSION_STARTED));
    }

    private static boolean isSessionShutdown(Message message) {
        return JsonValue.TRUE.equals(message.getHead().get("shutdown"));
    }

    private static boolean hasInitializeParameter(Message message) {
        return JsonValue.TRUE.equals(message.getHead().get("rwt_initialize"));
    }

    private static void setJsonResponseHeaders(ServletResponse response) {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
    }

    private static void writeEmptyMessage(ServletResponse response) throws IOException {
        new ProtocolMessageWriter().createMessage().writeTo(response.getWriter());
    }

    private static void writeProtocolMessage(JsonObject message, ServletResponse response) throws IOException {
        LifeCycleServiceHandler.bufferProtocolMessage(message);
        message.writeTo(response.getWriter());
    }

    private static void writeBufferedResponse(HttpServletResponse response) throws IOException {
        LifeCycleServiceHandler.getBufferedMessage().writeTo(response.getWriter());
    }

    private static void bufferProtocolMessage(JsonObject message) {
        UISession uiSession = ContextProvider.getUISession();
        if (uiSession != null) {
            uiSession.setAttribute(ATTR_LAST_PROTOCOL_MESSAGE, message);
        }
    }

    private static JsonObject getBufferedMessage() {
        return (JsonObject)ContextProvider.getUISession().getAttribute(ATTR_LAST_PROTOCOL_MESSAGE);
    }
}

