/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.engine;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.rap.rwt.internal.application.ApplicationContextImpl;
import org.eclipse.rap.rwt.internal.engine.PostDeserialization;
import org.eclipse.rap.rwt.internal.lifecycle.RequestCounter;
import org.eclipse.rap.rwt.internal.service.UISessionImpl;
import org.eclipse.rap.rwt.service.UISession;

public class RWTClusterSupport
implements Filter {
    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        RWTClusterSupport.beforeService(request);
        chain.doFilter(request, response);
        RWTClusterSupport.afterService(request);
    }

    public void destroy() {
    }

    private static void beforeService(ServletRequest request) {
        HttpSession httpSession = RWTClusterSupport.getHttpSession(request);
        if (httpSession != null) {
            RWTClusterSupport.beforeService(httpSession, RWTClusterSupport.getConnectionId(request));
        }
    }

    private static void beforeService(HttpSession httpSession, String connectionId) {
        UISessionImpl uiSession = UISessionImpl.getInstanceFromSession(httpSession, connectionId);
        if (uiSession != null) {
            uiSession.setHttpSession(httpSession);
            RWTClusterSupport.attachApplicationContext(uiSession);
            PostDeserialization.runProcessors(uiSession);
        }
    }

    private static void attachApplicationContext(UISession uiSession) {
        ServletContext servletContext = uiSession.getHttpSession().getServletContext();
        ApplicationContextImpl applicationContext = ApplicationContextImpl.getFrom(servletContext);
        ((UISessionImpl)uiSession).setApplicationContext(applicationContext);
    }

    private static void afterService(ServletRequest request) {
        HttpSession httpSession = RWTClusterSupport.getHttpSession(request);
        if (httpSession != null) {
            RWTClusterSupport.afterService(httpSession, RWTClusterSupport.getConnectionId(request));
        }
    }

    private static void afterService(HttpSession httpSession, String connectionId) {
        RWTClusterSupport.markSessionChanged(httpSession, connectionId);
    }

    private static void markSessionChanged(HttpSession httpSession, String connectionId) {
        UISessionImpl uiSession = UISessionImpl.getInstanceFromSession(httpSession, connectionId);
        if (uiSession != null) {
            uiSession.attachToHttpSession();
        }
        RequestCounter.reattachToHttpSession(httpSession, connectionId);
    }

    private static HttpSession getHttpSession(ServletRequest request) {
        return ((HttpServletRequest)request).getSession(false);
    }

    private static String getConnectionId(ServletRequest request) {
        return request.getParameter("cid");
    }
}

