/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.service;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.eclipse.rap.rwt.internal.util.ParamCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WrappedRequest
extends HttpServletRequestWrapper {
    private final Map<String, String[]> parameterMap;

    WrappedRequest(HttpServletRequest request, Map<String, String[]> paramMap) {
        super(request);
        ParamCheck.notNull(paramMap, "paramMap");
        this.parameterMap = new HashMap<String, String[]>(paramMap);
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String name = (String)parameterNames.nextElement();
            this.parameterMap.put(name, request.getParameterValues(name));
        }
    }

    public String getParameter(String name) {
        String[] value = this.parameterMap.get(name);
        String result = null;
        if (value != null) {
            result = value[0];
        }
        return result;
    }

    public String[] getParameterValues(String name) {
        String[] values = this.parameterMap.get(name);
        String[] result = null;
        if (values != null) {
            result = new String[values.length];
            System.arraycopy(values, 0, result, 0, values.length);
        }
        return result;
    }

    public Enumeration<String> getParameterNames() {
        final Iterator<String> iterator = this.parameterMap.keySet().iterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public String nextElement() {
                return (String)iterator.next();
            }
        };
    }

    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(this.parameterMap);
    }
}

